/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.timeseriesviewer;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.timeseriesviewer.Plot;
import ca.pfv.spmf.algorithms.timeseries.timeseriesviewer.TimeSeriesViewerPanelListener;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TimeSeriesViewerPanel
extends JPanel {
    Plot plot = null;
    double scaleLevel = 1.0;
    int height;
    int width;
    private List<TimeSeries> multipleTimeSeries;
    double minX = 0.0;
    double maxX = Double.MIN_VALUE;
    double minY = Double.MAX_VALUE;
    double maxY = Double.MIN_VALUE;
    List<TimeSeriesViewerPanelListener> listeners = new ArrayList<TimeSeriesViewerPanelListener>();
    Color[] colors = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.magenta, Color.orange, Color.cyan, Color.pink, Color.darkGray, Color.gray, Color.lightGray};

    public TimeSeriesViewerPanel(List<TimeSeries> timeSeries) {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Rectangle area = TimeSeriesViewerPanel.this.plot.getPlotAreaRectangle();
                double x = (double)e.getX() / TimeSeriesViewerPanel.this.scaleLevel - area.getX();
                double y = area.getHeight() - ((double)e.getY() / TimeSeriesViewerPanel.this.scaleLevel - area.getY());
                double chartMouseX = x / (double)area.width * (TimeSeriesViewerPanel.this.maxX - TimeSeriesViewerPanel.this.minX) + TimeSeriesViewerPanel.this.minX;
                double chartMouseY = y / (double)area.height * (TimeSeriesViewerPanel.this.maxY - TimeSeriesViewerPanel.this.minY) + TimeSeriesViewerPanel.this.minY;
                if (chartMouseX < TimeSeriesViewerPanel.this.minX || chartMouseX > TimeSeriesViewerPanel.this.maxX || chartMouseY < TimeSeriesViewerPanel.this.minY || chartMouseY > TimeSeriesViewerPanel.this.maxY) {
                    TimeSeriesViewerPanel.this.setCursor(new Cursor(0));
                    for (TimeSeriesViewerPanelListener listener : TimeSeriesViewerPanel.this.listeners) {
                        listener.notifyMouseOutOfChart();
                    }
                } else {
                    TimeSeriesViewerPanel.this.setCursor(new Cursor(1));
                    for (TimeSeriesViewerPanelListener listener : TimeSeriesViewerPanel.this.listeners) {
                        listener.notifyOfNewMousePosition(chartMouseX, chartMouseY);
                    }
                }
            }
        });
        this.multipleTimeSeries = timeSeries;
        int maxTimeSeriesLength = 0;
        for (TimeSeries singleTimeSeries : timeSeries) {
            if (singleTimeSeries.size() <= maxTimeSeriesLength) continue;
            maxTimeSeriesLength = singleTimeSeries.size();
        }
        this.width = 400 + maxTimeSeriesLength * 30;
        this.height = 400;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.plot = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scaleLevel, this.scaleLevel);
        Image image = this.drawThePlot();
        g2.drawImage(image, 0, 0, this);
    }

    private Image drawThePlot() {
        Image image = this.createImage(this.width, this.height);
        this.plot = Plot.plot(Plot.plotOpts().width(this.width).height(this.height).bgColor(Color.WHITE).fgColor(Color.BLACK).labelFont(new Font("Arial", 1, 12)).legend(Plot.LegendFormat.BOTTOM));
        boolean seriesCount = false;
        int i = 0;
        while (i < this.multipleTimeSeries.size()) {
            int count = 0;
            TimeSeries singleTimeSeries = this.multipleTimeSeries.get(i);
            Plot.Data data = Plot.data();
            int j = 0;
            while (j < singleTimeSeries.size()) {
                double point = singleTimeSeries.get(j);
                if (point != Double.NEGATIVE_INFINITY) {
                    data.xy(count++, point);
                }
                if (point < this.minY) {
                    this.minY = point;
                }
                if (point > this.maxY) {
                    this.maxY = point;
                }
                ++j;
            }
            this.maxX = count - 1;
            Color color = this.colors[i % this.colors.length];
            this.plot.series(singleTimeSeries.getName(), data, Plot.seriesOpts().color(color).line(Plot.Line.SOLID).lineWidth(1).marker(Plot.Marker.DIAMOND).markerColor(color).markerSize(5));
            ++i;
        }
        this.plot.xAxis("x", Plot.axisOpts().format(Plot.AxisFormat.NUMBER).range(this.minX, this.maxX)).yAxis("y", Plot.axisOpts().range(this.minY, this.maxY));
        this.plot.drawChartOnGraphics2D((Graphics2D)image.getGraphics());
        return image;
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)this.scaleLevel * this.width, (int)this.scaleLevel * this.height);
    }

    public void increaseZoom() {
        this.scaleLevel *= 2.0;
        System.out.println(this.scaleLevel);
        this.revalidate();
        this.repaint();
    }

    public void decreaseZoom() {
        this.scaleLevel /= 2.0;
        System.out.println(this.scaleLevel);
        this.revalidate();
        this.repaint();
    }

    protected void export() {
        String outputFilePath;
        block7: {
            outputFilePath = null;
            try {
                URL main;
                String previousPath = PreferencesManager.getInstance().getOutputFilePath();
                Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
                JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    outputFilePath = file.getPath();
                    if (fc.getSelectedFile() != null) {
                        PreferencesManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                    }
                    break block7;
                }
                return;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured while opening the save plot dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
        }
        try {
            if (!outputFilePath.endsWith("png")) {
                outputFilePath = String.valueOf(outputFilePath) + ".png";
            }
            File outputFile = new File(outputFilePath);
            BufferedImage image = (BufferedImage)this.drawThePlot();
            ImageIO.write((RenderedImage)image, "png", outputFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while attempting to save the plot. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    public void doPrint() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(" SPMF print time series");
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics pg, PageFormat pageFormat, int pageNum) throws PrinterException {
                if (pageNum > 0) {
                    return 1;
                }
                Image image = TimeSeriesViewerPanel.this.drawThePlot();
                Graphics2D g2 = (Graphics2D)pg;
                g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                g2.scale(pageFormat.getImageableWidth() / (double)TimeSeriesViewerPanel.this.width, pageFormat.getImageableHeight() / (double)TimeSeriesViewerPanel.this.height);
                g2.drawImage(image, 0, 0, null);
                return 0;
            }
        });
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    public void doPrintSetup() {
    }

    public void addListener(TimeSeriesViewerPanelListener listener) {
        this.listeners.add(listener);
    }
}

