/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.redblacktree;

import java.util.Iterator;
import java.util.Stack;

public class RedBlackTree<T extends Comparable<T>>
implements Iterable<T> {
    static final boolean BLACK = true;
    static final boolean RED = false;
    private final Node NULL = new Node();
    private int size = 0;
    private Node root = this.NULL;
    boolean allowSameElementMultipleTimes = true;

    public RedBlackTree(boolean allowSameElementMultipleTimes) {
        this.allowSameElementMultipleTimes = allowSameElementMultipleTimes;
    }

    public RedBlackTree() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.root == this.NULL;
    }

    private void leftRotate(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (!y.left.equals(this.NULL)) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent.equals(this.NULL)) {
            this.root = y;
        } else if (x.equals(x.parent.left)) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    private void rightRotate(Node x) {
        Node y = x.left;
        x.left = y.right;
        if (!y.right.equals(this.NULL)) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent.equals(this.NULL)) {
            this.root = y;
        } else if (x.equals(x.parent.right)) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
    }

    public void add(T element) {
        Node z = new Node();
        z.key = element;
        Node y = this.NULL;
        Node x = this.root;
        while (x != this.NULL) {
            y = x;
            int compare = z.key.compareTo(x.key);
            if (compare < 0) {
                x = x.left;
                continue;
            }
            if (compare == 0 && !this.allowSameElementMultipleTimes) {
                return;
            }
            x = x.right;
        }
        z.parent = y;
        if (y == this.NULL) {
            this.root = z;
        } else if (z.key.compareTo(y.key) < 0) {
            y.left = z;
        } else {
            y.right = z;
        }
        ++this.size;
        z.left = this.NULL;
        z.right = this.NULL;
        z.color = false;
        this.insertFixup(z);
    }

    private void insertFixup(Node z) {
        while (!z.parent.color) {
            Node y;
            if (z.parent.equals(z.parent.parent.left)) {
                y = z.parent.parent.right;
                if (!y.color) {
                    z.parent.color = true;
                    y.color = true;
                    z.parent.parent.color = false;
                    z = z.parent.parent;
                    continue;
                }
                if (z.equals(z.parent.right)) {
                    z = z.parent;
                    this.leftRotate(z);
                }
                z.parent.color = true;
                z.parent.parent.color = false;
                this.rightRotate(z.parent.parent);
                continue;
            }
            y = z.parent.parent.left;
            if (!y.color) {
                z.parent.color = true;
                y.color = true;
                z.parent.parent.color = false;
                z = z.parent.parent;
                continue;
            }
            if (z.equals(z.parent.left)) {
                z = z.parent;
                this.rightRotate(z);
            }
            z.parent.color = true;
            z.parent.parent.color = false;
            this.leftRotate(z.parent.parent);
        }
        this.root.color = true;
    }

    private void transplant(Node u, Node v) {
        if (u.parent == this.NULL) {
            this.root = v;
        } else if (u == u.parent.left) {
            u.parent.left = v;
        } else {
            u.parent.right = v;
        }
        v.parent = u.parent;
    }

    public void remove(T element) {
        Node z = this.search(this.root, element);
        if (z == this.NULL) {
            return;
        }
        this.performDelete(z);
    }

    private void performDelete(Node z) {
        Node x;
        Node y = z;
        boolean yOriginalColor = y.color;
        if (z.left == this.NULL) {
            x = z.right;
            this.transplant(z, z.right);
        } else if (z.right == this.NULL) {
            x = z.left;
            this.transplant(z, z.left);
        } else {
            y = this.minimum(z.right);
            yOriginalColor = y.color;
            x = y.right;
            if (y.parent.equals(z)) {
                x.parent = y;
            } else {
                this.transplant(y, y.right);
                y.right = z.right;
                y.right.parent = y;
            }
            this.transplant(z, y);
            y.left = z.left;
            y.left.parent = y;
            y.color = z.color;
        }
        if (yOriginalColor) {
            this.deleteFixup(x);
        }
        --this.size;
    }

    private void deleteFixup(Node x) {
        while (x != this.root && x.color) {
            Node w;
            if (x.equals(x.parent.left)) {
                w = x.parent.right;
                if (!w.color) {
                    w.color = true;
                    x.parent.color = false;
                    this.leftRotate(x.parent);
                    w = x.parent.right;
                }
                if (w.left.color && w.right.color) {
                    w.color = false;
                    x = x.parent;
                    continue;
                }
                if (w.right.color) {
                    w.left.color = true;
                    w.color = false;
                    this.rightRotate(w);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = true;
                w.right.color = true;
                this.leftRotate(x.parent);
                x = this.root;
                continue;
            }
            w = x.parent.left;
            if (!w.color) {
                w.color = true;
                x.parent.color = false;
                this.rightRotate(x.parent);
                w = x.parent.left;
            }
            if (w.right.color && w.left.color) {
                w.color = false;
                x = x.parent;
                continue;
            }
            if (w.left.color) {
                w.right.color = true;
                w.color = false;
                this.leftRotate(w);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = true;
            w.left.color = true;
            this.rightRotate(x.parent);
            x = this.root;
        }
        x.color = true;
    }

    private Node successor(Node x) {
        if (x.right != this.NULL) {
            return this.minimum(x.right);
        }
        Node y = x.parent;
        while (y != this.NULL && x.equals(y.right)) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    private Node predecessor(Node x) {
        if (x.left != this.NULL) {
            return this.maximum(x.left);
        }
        Node y = x.parent;
        while (y != this.NULL && x.equals(y.left)) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    public T lower(T k) {
        Node result = this.lowerNode(k);
        if (result == this.NULL) {
            return null;
        }
        return result.key;
    }

    public Node lowerNode(T k) {
        Node x = this.root;
        while (x != this.NULL) {
            if (k.compareTo(x.key) > 0) {
                if (x.right != this.NULL) {
                    x = x.right;
                    continue;
                }
                return x;
            }
            if (x.left != this.NULL) {
                x = x.left;
                continue;
            }
            Node current = x;
            while (current.parent != this.NULL && current.parent.left == current) {
                current = current.parent;
            }
            return current.parent;
        }
        return this.NULL;
    }

    public T higher(T k) {
        Node result = this.higherNode(k);
        if (result == this.NULL) {
            return null;
        }
        return result.key;
    }

    private Node higherNode(T k) {
        Node x = this.root;
        while (x != this.NULL) {
            if (k.compareTo(x.key) < 0) {
                if (x.left != this.NULL) {
                    x = x.left;
                    continue;
                }
                return x;
            }
            if (x.right != this.NULL) {
                x = x.right;
                continue;
            }
            Node current = x;
            while (current.parent != this.NULL && current.parent.right == current) {
                current = current.parent;
            }
            return current.parent;
        }
        return this.NULL;
    }

    public T popMinimum() {
        if (this.root == this.NULL) {
            return null;
        }
        Node x = this.root;
        while (x.left != this.NULL) {
            x = x.left;
        }
        Object value = x.key;
        this.performDelete(x);
        return value;
    }

    public T popMaximum() {
        if (this.root == this.NULL) {
            return null;
        }
        Node x = this.root;
        while (x.right != this.NULL) {
            x = x.right;
        }
        Object value = x.key;
        this.performDelete(x);
        return value;
    }

    public T minimum() {
        if (this.root == this.NULL) {
            return null;
        }
        return this.minimum((Node)this.root).key;
    }

    private Node minimum(Node x) {
        while (x.left != this.NULL) {
            x = x.left;
        }
        return x;
    }

    public T maximum() {
        if (this.root == this.NULL) {
            return null;
        }
        return this.maximum((Node)this.root).key;
    }

    private Node maximum(Node x) {
        while (x.right != this.NULL) {
            x = x.right;
        }
        return x;
    }

    public boolean contains(T k) {
        return this.search(this.root, k) != this.NULL;
    }

    private Node search(Node x, T k) {
        while (x != this.NULL && !k.equals(x.key)) {
            x = k.compareTo(x.key) < 0 ? x.left : x.right;
        }
        return x;
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.print(this.root, new StringBuilder()).toString();
    }

    private StringBuilder print(Node x, StringBuilder buffer) {
        if (x != null && x.key != null) {
            this.print(x.left, buffer);
            buffer.append(x.key + " ");
            this.print(x.right, buffer);
        }
        return buffer;
    }

    @Override
    public Iterator<T> iterator() {
        return new RedBlackTreeIterator(this.root);
    }

    public class Node {
        public T key = null;
        boolean color = true;
        public Node left;
        public Node right;
        Node parent;

        public Node() {
            this.left = RedBlackTree.this.NULL;
            this.right = RedBlackTree.this.NULL;
            this.parent = RedBlackTree.this.NULL;
        }
    }

    public class RedBlackTreeIterator<S>
    implements Iterator<S> {
        private Stack<Node> nodesToVisitNext = new Stack();

        public RedBlackTreeIterator(Node root) {
            this.nodesToVisitNext.push(root);
        }

        @Override
        public boolean hasNext() {
            return !this.nodesToVisitNext.isEmpty();
        }

        @Override
        public S next() {
            Node currentNode = this.nodesToVisitNext.pop();
            if (currentNode.left != null && currentNode.left.key != null) {
                this.nodesToVisitNext.push(currentNode.left);
            }
            if (currentNode.right != null && currentNode.right.key != null) {
                this.nodesToVisitNext.push(currentNode.right);
            }
            return (S)currentNode.key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
    }
}

