/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.triangularmatrix;

import ca.pfv.spmf.datastructures.triangularmatrix.AbstractTriangularMatrix;
import java.util.HashMap;
import java.util.Map;

public class SparseTriangularMatrix
implements AbstractTriangularMatrix {
    private Map<Integer, Map<Integer, Integer>> matrix = new HashMap<Integer, Map<Integer, Integer>>();

    public SparseTriangularMatrix() {
    }

    public SparseTriangularMatrix(int itemCount) {
    }

    @Override
    public String toString() {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.matrix.keySet().size()) {
            temp.append(i);
            temp.append(": ");
            int j = 0;
            while (j < this.matrix.get(i).size()) {
                temp.append(this.matrix.get(i).get(j));
                temp.append(" ");
                ++j;
            }
            temp.append("\n");
            ++i;
        }
        return temp.toString();
    }

    @Override
    public void incrementCount(int i, int j) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(i, mapCount);
                mapCount.put(j, 1);
            } else {
                Integer count = mapCount.get(j);
                if (count == null) {
                    mapCount.put(j, 1);
                } else {
                    count = count + 1;
                    mapCount.put(j, count);
                }
            }
        } else {
            Map<Integer, Integer> mapCount = this.matrix.get(j);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(j, mapCount);
                mapCount.put(i, 1);
            } else {
                Integer count = mapCount.get(i);
                if (count == null) {
                    mapCount.put(i, 1);
                } else {
                    count = count + 1;
                    mapCount.put(i, count);
                }
            }
        }
    }

    @Override
    public int getSupportForItems(int i, int j) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                return 0;
            }
            Integer count = mapCount.get(j);
            if (count == null) {
                return 0;
            }
            return count;
        }
        Map<Integer, Integer> mapCount = this.matrix.get(j);
        if (mapCount == null) {
            return 0;
        }
        Integer count = mapCount.get(i);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public void setSupport(Integer i, Integer j, int support) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(i, mapCount);
                mapCount.put(j, support);
            } else {
                mapCount.put(j, support);
            }
        } else {
            Map<Integer, Integer> mapCount = this.matrix.get(j);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(j, mapCount);
                mapCount.put(i, support);
            } else {
                mapCount.put(i, support);
            }
        }
    }
}

