/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.triangularmatrix;

import ca.pfv.spmf.datastructures.triangularmatrix.AbstractTriangularMatrix;

public class TriangularMatrix
implements AbstractTriangularMatrix {
    private int[][] matrix;
    private int elementCount;

    public TriangularMatrix(int elementCount) {
        this.elementCount = elementCount;
        this.matrix = new int[elementCount - 1][];
        int i = 0;
        while (i < elementCount - 1) {
            this.matrix[i] = new int[elementCount - i - 1];
            ++i;
        }
    }

    private int get(int i, int j) {
        return this.matrix[i][j];
    }

    public static void main(String[] args) {
        TriangularMatrix a = new TriangularMatrix(5);
        System.out.println(a.toString());
        a.incrementCount(1, 0);
        System.out.println(a.toString());
        a.incrementCount(1, 4);
        a.incrementCount(1, 3);
        a.incrementCount(2, 4);
        a.incrementCount(2, 4);
        a.incrementCount(4, 3);
        System.out.println(a.toString());
        a.incrementCount(0, 2);
        a.incrementCount(0, 3);
        a.incrementCount(0, 4);
        System.out.println(a.toString());
    }

    @Override
    public String toString() {
        System.out.println("Element count = " + this.elementCount);
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.matrix.length) {
            temp.append(i);
            temp.append(": ");
            int j = 0;
            while (j < this.matrix[i].length) {
                temp.append(this.matrix[i][j]);
                temp.append(" ");
                ++j;
            }
            temp.append("\n");
            ++i;
        }
        return temp.toString();
    }

    @Override
    public void incrementCount(int i, int j) {
        if (j < i) {
            int[] nArray = this.matrix[this.elementCount - i - 1];
            int n = j;
            nArray[n] = nArray[n] + 1;
        } else {
            int[] nArray = this.matrix[this.elementCount - j - 1];
            int n = i;
            nArray[n] = nArray[n] + 1;
        }
    }

    @Override
    public int getSupportForItems(int i, int j) {
        if (j < i) {
            return this.matrix[this.elementCount - i - 1][j];
        }
        return this.matrix[this.elementCount - j - 1][i];
    }

    @Override
    public void setSupport(Integer i, Integer j, int support) {
        if (j < i) {
            this.matrix[this.elementCount - i.intValue() - 1][j.intValue()] = support;
        } else {
            this.matrix[this.elementCount - j.intValue() - 1][i.intValue()] = support;
        }
    }
}

