/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import ca.pfv.spmf.algorithmmanager.AlgorithmManager;
import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.tools.dataset_converter.SequenceDatabaseConverter;
import ca.pfv.spmf.tools.dataset_converter.TransactionDatabaseConverter;
import ca.pfv.spmf.tools.resultConverter.ResultConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class CommandProcessor {
    public static void runAlgorithm(String algorithmName, String inputFile, String outputFile, String[] parameters) throws Exception {
        Map<Object, Object> mapItemToString = null;
        String originalOutputFile = null;
        String originalInputFile = null;
        AlgorithmManager manager = AlgorithmManager.getInstance();
        DescriptionOfAlgorithm algorithm = manager.getDescriptionOfAlgorithm(algorithmName);
        if (algorithm == null) {
            throw new IllegalArgumentException("\n\n There is no algorithm with the name '" + algorithmName + "' in SPMF. ");
        }
        if (algorithm.getInputFileTypes() == null) {
            inputFile = null;
        }
        if (algorithm.getOutputFileTypes() == null) {
            outputFile = null;
        }
        if (algorithm.getInputFileTypes() != null) {
            if (inputFile == null) {
                throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + "No input file has been provided.");
            }
            File input = new File(inputFile);
            if (!input.exists()) {
                throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + " The input file '" + inputFile + "' does not exist.");
            }
        }
        if (algorithm.getOutputFileTypes() != null && outputFile == null) {
            throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + " No output file path has been provided.");
        }
        int numberOfParameter = algorithm.getParametersDescription().length;
        int i = 0;
        while (i < numberOfParameter) {
            DescriptionOfParameter parameterI = algorithm.getParametersDescription()[i];
            String ordinal = CommandProcessor.ordinal(i + 1);
            if (i == parameters.length) {
                if (parameterI.isOptional) break;
                throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + " The " + ordinal + " parameter of this algorithm '" + parameterI.name + "' is mandatory. Please provide a value of type: " + parameterI.parameterType.getSimpleName() + ".");
            }
            String valueI = parameters[i];
            if ("".equals(valueI)) {
                if (!parameterI.isOptional) {
                    throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + " The " + ordinal + " parameter of this algorithm '" + parameterI.name + "' is mandatory. Please provide a value of type: " + parameterI.parameterType.getSimpleName() + ".");
                }
            } else {
                boolean isCorrectType = algorithm.isParameterOfCorrectType(parameters[i], i);
                if (!isCorrectType) {
                    throw new IllegalArgumentException(String.valueOf(System.lineSeparator()) + System.lineSeparator() + " The " + ordinal + " parameter value of this algorithm '" + parameterI.name + "' is of an incorrect type. The provided value is '" + parameters[i] + "' but it should be of type: " + parameterI.parameterType.getSimpleName() + ".");
                }
            }
            ++i;
        }
        if (!algorithmName.startsWith("Convert") && inputFile != null) {
            FileInputStream fin = new FileInputStream(new File(inputFile));
            BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
            String firstLine = myInput.readLine();
            myInput.close();
            if (firstLine.startsWith("@CONVERTED_FROM_ARFF") || firstLine.startsWith("@CONVERTED_FROM_TEXT") || firstLine.startsWith("@CONVERTED_FROM_TIME_SERIES")) {
                String thisLine;
                originalOutputFile = outputFile;
                originalInputFile = inputFile;
                outputFile = String.valueOf(outputFile) + ".tmp";
                mapItemToString = new HashMap();
                fin = new FileInputStream(new File(inputFile));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (!thisLine.startsWith("@ITEM")) continue;
                    thisLine = thisLine.substring(6);
                    int index = thisLine.indexOf("=");
                    int itemID = Integer.parseInt(thisLine.substring(0, index));
                    String stringValue = thisLine.substring(index + 1);
                    mapItemToString.put(itemID, stringValue);
                }
                myInput.close();
            } else if (inputFile.endsWith(".arff") || inputFile.endsWith(".ARFF")) {
                TransactionDatabaseConverter converter = new TransactionDatabaseConverter();
                System.out.println("Converting ARFF to SPMF format.");
                originalOutputFile = outputFile;
                originalInputFile = inputFile;
                inputFile = String.valueOf(inputFile) + ".tmp";
                outputFile = String.valueOf(outputFile) + ".tmp";
                mapItemToString = converter.convertARFFandReturnMap(originalInputFile, inputFile, Integer.MAX_VALUE);
                System.out.println("Conversion completed.");
            } else if (inputFile.endsWith(".text") || inputFile.endsWith(".TEXT")) {
                Charset charset = PreferencesManager.getInstance().getPreferedCharset();
                SequenceDatabaseConverter converter = new SequenceDatabaseConverter();
                System.out.println("Converting TEXT to SPMF format.");
                originalOutputFile = outputFile;
                originalInputFile = inputFile;
                inputFile = String.valueOf(inputFile) + ".tmp";
                outputFile = String.valueOf(outputFile) + ".tmp";
                mapItemToString = converter.convertTEXTandReturnMap(originalInputFile, inputFile, Integer.MAX_VALUE, charset);
                System.out.println("Conversion completed.");
            }
        }
        algorithm.runAlgorithm(parameters, inputFile, outputFile);
        if (mapItemToString != null) {
            Charset charset = PreferencesManager.getInstance().getPreferedCharset();
            ResultConverter converter = new ResultConverter();
            System.out.println("Post-processing to show result in terms of string values.");
            converter.convert(mapItemToString, outputFile, originalOutputFile, charset);
            System.out.println("Post-processing completed.");
            File file = new File(outputFile);
            file.delete();
            if (!inputFile.equals(originalInputFile)) {
                File file2 = new File(inputFile);
                file2.delete();
            }
            outputFile = originalOutputFile;
            inputFile = originalInputFile;
        }
    }

    public static String ordinal(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return String.valueOf(i) + "th";
            }
        }
        return String.valueOf(i) + sufixes[i % 10];
    }
}

