/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import ca.pfv.spmf.gui.CommandProcessor;
import ca.pfv.spmf.gui.MainWindow;
import java.lang.reflect.Method;

public class Main {
    public static String SPMF_VERSION = "2.05";

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            Main.processCommandLineArguments(args);
        } else {
            MainWindow mainWindow = new MainWindow();
            mainWindow.setVisible(true);
        }
    }

    public static void processCommandLineArguments(String[] args) {
        if ("version".equals(args[0])) {
            System.out.println(" \n-- SPMF version " + SPMF_VERSION + " --\n");
        } else if ("help".equals(args[0])) {
            System.out.println("\n\nFor help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n\n");
        } else if ("run".equals(args[0])) {
            String[] parameters;
            String algoName = null;
            if (args.length > 1) {
                algoName = args[1];
            }
            String input = null;
            if (args.length > 2) {
                input = args[2];
            }
            String output = null;
            if (args.length > 3) {
                output = args[3];
            }
            if (args.length > 4) {
                parameters = new String[args.length - 4];
                System.arraycopy(args, 4, parameters, 0, args.length - 4);
            } else {
                parameters = new String[]{};
            }
            try {
                CommandProcessor.runAlgorithm(algoName, input, output, parameters);
            }
            catch (NumberFormatException e) {
                System.out.println("Error. Please check the parameters of the algorithm.  The format for numbers is incorrect. \n\n ERROR MESSAGE = " + e.toString());
            }
            catch (Throwable e) {
                System.out.println("An error while trying to run the algorithm. \n ERROR MESSAGE = " + e.toString());
                e.printStackTrace();
            }
        } else if ("test".equals(args[0])) {
            String testName = args[1];
            try {
                Class<?> testClass = Class.forName("ca.pfv.spmf.tests." + testName);
                Method mainMethod = testClass.getMethod("main", String[].class);
                Object params = null;
                mainMethod.invoke(null, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\n\n Command not recognized.\n For help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n \n");
        }
    }
}

