/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import ca.pfv.spmf.algorithmmanager.AlgorithmManager;
import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.gui.CommandProcessor;
import ca.pfv.spmf.gui.Main;
import ca.pfv.spmf.gui.NotifyingThread;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.gui.ThreadCompleteListener;
import ca.pfv.spmf.gui.patternvizualizer.PatternVizualizer;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MainWindow
extends JFrame
implements ThreadCompleteListener,
Thread.UncaughtExceptionHandler {
    private String inputFile = null;
    private String outputFile = null;
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField textFieldParam1;
    private JTextField textFieldParam2;
    private JTextField textFieldParam3;
    private JTextField textFieldParam4;
    private JTextField textFieldParam5;
    private JTextField textFieldParam6;
    private JLabel labelParam1;
    private JLabel labelParam2;
    private JLabel labelParam3;
    private JLabel labelParam4;
    private JLabel labelParam5;
    private JLabel labelParam6;
    private JLabel lbHelp1;
    private JLabel lbHelp2;
    private JLabel lbHelp3;
    private JLabel lbHelp4;
    private JLabel lbHelp5;
    private JLabel lbHelp6;
    private JTextField textFieldInput;
    private JTextField textFieldOutput;
    private JComboBox<String> comboBox;
    private JTextArea textArea;
    private JButton buttonRun;
    private JCheckBox checkboxOpenOutputText;
    private JButton buttonExample;
    private JLabel lblSetOutputFile;
    private JButton buttonOutput;
    private JButton buttonInput;
    private JLabel lblChooseInputFile;
    private JProgressBar progressBar;
    private static NotifyingThread currentRunningAlgorithmThread = null;
    private JCheckBox checkboxOpenOutputPatterViewer;
    private JLabel lblOpenOutputFile;

    public MainWindow() throws Exception {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                System.exit(0);
            }
        });
        this.setTitle("SPMF v" + Main.SPMF_VERSION);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 706, 621);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.comboBox = new JComboBox(new Vector());
        this.comboBox.setMaximumRowCount(20);
        this.comboBox.addItem("");
        AlgorithmManager manager = AlgorithmManager.getInstance();
        List<String> algorithmList = manager.getListOfAlgorithmsAsString();
        for (String algorithmOrCategoryName : algorithmList) {
            this.comboBox.addItem(algorithmOrCategoryName);
        }
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                try {
                    MainWindow.this.updateUserInterfaceAfterAlgorithmSelection(evt.getItem().toString(), evt.getStateChange() == 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.comboBox.setBounds(263, 74, 367, 20);
        this.contentPane.add(this.comboBox);
        this.buttonRun = new JButton("Run algorithm");
        this.buttonRun.setEnabled(false);
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.processRunAlgorithmCommandFromGUI();
            }
        });
        this.buttonRun.setBounds(285, 364, 119, 23);
        this.contentPane.add(this.buttonRun);
        JLabel lblChooseAnAlgorithm = new JLabel("Choose an algorithm:");
        lblChooseAnAlgorithm.setBounds(22, 73, 204, 20);
        this.contentPane.add(lblChooseAnAlgorithm);
        JLabel lblNewLabel = new JLabel("New label");
        lblNewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                MainWindow.this.openWebPage("http://www.philippe-fournier-viger.com/spmf/");
            }
        });
        lblNewLabel.setIcon(new ImageIcon(MainWindow.class.getResource("spmf.png")));
        lblNewLabel.setBounds(12, 13, 140, 47);
        this.contentPane.add(lblNewLabel);
        this.textFieldParam1 = new JTextField();
        this.textFieldParam1.setBounds(263, 164, 157, 20);
        this.contentPane.add(this.textFieldParam1);
        this.textFieldParam1.setColumns(10);
        String buffer = new String(new byte[]{83, 80, 77, 70});
        if (!this.getTitle().startsWith(buffer)) {
            this.setTitle(buffer);
        }
        this.buttonInput = new JButton("...");
        this.buttonInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.askUserToChooseInputFile();
            }
        });
        this.buttonInput.setBounds(430, 104, 32, 23);
        this.contentPane.add(this.buttonInput);
        this.buttonOutput = new JButton("...");
        this.buttonOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.askUserToChooseOutputFile();
            }
        });
        this.buttonOutput.setBounds(430, 133, 32, 23);
        this.contentPane.add(this.buttonOutput);
        this.labelParam1 = new JLabel("Parameter 1:");
        this.labelParam1.setBounds(22, 167, 204, 14);
        this.contentPane.add(this.labelParam1);
        this.labelParam2 = new JLabel("Parameter 2:");
        this.labelParam2.setBounds(22, 192, 204, 14);
        this.contentPane.add(this.labelParam2);
        this.labelParam3 = new JLabel("Parameter 3:");
        this.labelParam3.setBounds(22, 217, 204, 14);
        this.contentPane.add(this.labelParam3);
        this.labelParam4 = new JLabel("Parameter 4:");
        this.labelParam4.setBounds(22, 239, 231, 14);
        this.contentPane.add(this.labelParam4);
        this.labelParam5 = new JLabel("Parameter 5:");
        this.labelParam5.setBounds(22, 264, 231, 14);
        this.contentPane.add(this.labelParam5);
        this.labelParam6 = new JLabel("Parameter 6:");
        this.labelParam6.setBounds(22, 289, 231, 14);
        this.contentPane.add(this.labelParam6);
        this.textFieldParam2 = new JTextField();
        this.textFieldParam2.setColumns(10);
        this.textFieldParam2.setBounds(263, 189, 157, 20);
        this.contentPane.add(this.textFieldParam2);
        this.textFieldParam3 = new JTextField();
        this.textFieldParam3.setColumns(10);
        this.textFieldParam3.setBounds(263, 214, 157, 20);
        this.contentPane.add(this.textFieldParam3);
        this.textFieldParam4 = new JTextField();
        this.textFieldParam4.setColumns(10);
        this.textFieldParam4.setBounds(263, 236, 157, 20);
        this.contentPane.add(this.textFieldParam4);
        this.textFieldParam5 = new JTextField();
        this.textFieldParam5.setColumns(10);
        this.textFieldParam5.setBounds(263, 261, 157, 20);
        this.contentPane.add(this.textFieldParam5);
        this.textFieldParam6 = new JTextField();
        this.textFieldParam6.setColumns(10);
        this.textFieldParam6.setBounds(263, 286, 157, 20);
        this.contentPane.add(this.textFieldParam6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(12, 415, 681, 170);
        this.contentPane.add(scrollPane);
        this.textArea = new JTextArea();
        scrollPane.setViewportView(this.textArea);
        System.setOut(new PrintStream(new TextAreaOutputStream(this.textArea)));
        this.textFieldInput = new JTextField();
        this.textFieldInput.setEditable(false);
        this.textFieldInput.setBounds(263, 105, 157, 20);
        this.contentPane.add(this.textFieldInput);
        this.textFieldInput.setColumns(10);
        this.textFieldOutput = new JTextField();
        this.textFieldOutput.setEditable(false);
        this.textFieldOutput.setColumns(10);
        this.textFieldOutput.setBounds(263, 134, 157, 20);
        this.contentPane.add(this.textFieldOutput);
        this.checkboxOpenOutputText = new JCheckBox("using text editor");
        this.checkboxOpenOutputText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainWindow.this.checkboxOpenOutputText.isSelected()) {
                    MainWindow.this.checkboxOpenOutputPatterViewer.setSelected(false);
                }
            }
        });
        this.checkboxOpenOutputText.setSelected(true);
        this.checkboxOpenOutputText.setBounds(220, 332, 150, 23);
        this.contentPane.add(this.checkboxOpenOutputText);
        this.checkboxOpenOutputPatterViewer = new JCheckBox("using SPMF viewer");
        this.checkboxOpenOutputPatterViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainWindow.this.checkboxOpenOutputPatterViewer.isSelected()) {
                    MainWindow.this.checkboxOpenOutputText.setSelected(false);
                }
            }
        });
        this.checkboxOpenOutputPatterViewer.setBounds(49, 329, 164, 29);
        this.contentPane.add(this.checkboxOpenOutputPatterViewer);
        this.buttonExample = new JButton("?");
        this.buttonExample.setEnabled(false);
        this.buttonExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String choice = (String)MainWindow.this.comboBox.getSelectedItem();
                try {
                    MainWindow.this.openHelpWebPageForAlgorithm(choice);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.buttonExample.setBounds(642, 73, 49, 23);
        this.contentPane.add(this.buttonExample);
        this.lblChooseInputFile = new JLabel("Choose input file");
        this.lblChooseInputFile.setBounds(22, 108, 97, 14);
        this.contentPane.add(this.lblChooseInputFile);
        this.lblSetOutputFile = new JLabel("Set output file");
        this.lblSetOutputFile.setBounds(22, 137, 97, 14);
        this.contentPane.add(this.lblSetOutputFile);
        this.lbHelp1 = new JLabel("help1");
        this.lbHelp1.setBounds(430, 167, 211, 14);
        this.contentPane.add(this.lbHelp1);
        this.lbHelp2 = new JLabel("help2");
        this.lbHelp2.setBounds(430, 192, 211, 14);
        this.contentPane.add(this.lbHelp2);
        this.lbHelp3 = new JLabel("help3");
        this.lbHelp3.setBounds(430, 217, 200, 14);
        this.contentPane.add(this.lbHelp3);
        this.lbHelp4 = new JLabel("help4");
        this.lbHelp4.setBounds(430, 239, 200, 14);
        this.contentPane.add(this.lbHelp4);
        this.lbHelp5 = new JLabel("help5");
        this.lbHelp5.setBounds(430, 264, 200, 14);
        this.contentPane.add(this.lbHelp5);
        this.lbHelp6 = new JLabel("help6");
        this.lbHelp6.setBounds(430, 289, 200, 14);
        this.contentPane.add(this.lbHelp6);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(268, 394, 163, 16);
        this.contentPane.add(this.progressBar);
        this.lblOpenOutputFile = new JLabel("Open output file: ");
        this.lblOpenOutputFile.setBounds(22, 310, 157, 20);
        this.contentPane.add(this.lblOpenOutputFile);
        this.hideAllParams();
    }

    private void updateUserInterfaceAfterAlgorithmSelection(String algorithmName, boolean isSelected) throws Exception {
        if (isSelected) {
            this.buttonRun.setEnabled(true);
            this.buttonExample.setEnabled(true);
            this.hideAllParams();
            JTextField[] textFieldsParams = new JTextField[]{this.textFieldParam1, this.textFieldParam2, this.textFieldParam3, this.textFieldParam4, this.textFieldParam5, this.textFieldParam6};
            JLabel[] labelsParams = new JLabel[]{this.labelParam1, this.labelParam2, this.labelParam3, this.labelParam4, this.labelParam5, this.labelParam6};
            AlgorithmManager manager = AlgorithmManager.getInstance();
            DescriptionOfAlgorithm algorithm = manager.getDescriptionOfAlgorithm(algorithmName);
            if (algorithm != null) {
                DescriptionOfParameter[] parameters = algorithm.getParametersDescription();
                int i = 0;
                while (i < parameters.length) {
                    DescriptionOfParameter parameter = parameters[i];
                    String optional = parameter.isOptional ? " (optional)" : "";
                    this.setParam(textFieldsParams[i], String.valueOf(parameter.name) + optional, labelsParams[i], parameter.example);
                    ++i;
                }
                if (algorithm.getInputFileTypes() != null) {
                    this.lblChooseInputFile.setVisible(true);
                    this.buttonInput.setVisible(true);
                    this.textFieldInput.setVisible(true);
                }
                if (algorithm.getOutputFileTypes() != null) {
                    this.lblSetOutputFile.setVisible(true);
                    this.buttonOutput.setVisible(true);
                    this.textFieldOutput.setVisible(true);
                    this.checkboxOpenOutputText.setVisible(true);
                    this.lblOpenOutputFile.setVisible(true);
                    this.checkboxOpenOutputPatterViewer.setVisible(true);
                    this.checkboxOpenOutputText.setVisible(true);
                }
            } else {
                if (!this.isVisible()) {
                    System.out.println("There is no algorithm with this name.  To fix this problem, you may check the command syntax in the SPMF documentation and/or verify if there is a new version of SPMF on the SPMF website.");
                }
                this.hideAllParams();
                this.buttonRun.setEnabled(false);
                this.buttonExample.setEnabled(false);
            }
        } else {
            this.hideAllParams();
            this.buttonRun.setEnabled(false);
            this.buttonExample.setEnabled(false);
        }
    }

    private void setParam(JTextField textfield, String name, JLabel label, String helpText) {
        label.setText(name);
        textfield.setEnabled(true);
        textfield.setVisible(true);
        label.setVisible(true);
        if (textfield == this.textFieldParam1) {
            this.lbHelp1.setText(helpText);
            this.lbHelp1.setVisible(true);
        } else if (textfield == this.textFieldParam2) {
            this.lbHelp2.setText(helpText);
            this.lbHelp2.setVisible(true);
        } else if (textfield == this.textFieldParam3) {
            this.lbHelp3.setText(helpText);
            this.lbHelp3.setVisible(true);
        } else if (textfield == this.textFieldParam4) {
            this.lbHelp4.setText(helpText);
            this.lbHelp4.setVisible(true);
        } else if (textfield == this.textFieldParam5) {
            this.lbHelp5.setText(helpText);
            this.lbHelp5.setVisible(true);
        } else if (textfield == this.textFieldParam6) {
            this.lbHelp6.setText(helpText);
            this.lbHelp6.setVisible(true);
        }
    }

    private void hideAllParams() {
        this.labelParam1.setVisible(false);
        this.labelParam2.setVisible(false);
        this.labelParam3.setVisible(false);
        this.labelParam4.setVisible(false);
        this.labelParam5.setVisible(false);
        this.labelParam6.setVisible(false);
        this.lbHelp1.setVisible(false);
        this.lbHelp2.setVisible(false);
        this.lbHelp3.setVisible(false);
        this.lbHelp4.setVisible(false);
        this.lbHelp5.setVisible(false);
        this.lbHelp6.setVisible(false);
        this.textFieldParam1.setVisible(false);
        this.textFieldParam2.setVisible(false);
        this.textFieldParam3.setVisible(false);
        this.textFieldParam4.setVisible(false);
        this.textFieldParam5.setVisible(false);
        this.textFieldParam6.setVisible(false);
        this.lblSetOutputFile.setVisible(false);
        this.buttonOutput.setVisible(false);
        this.textFieldOutput.setVisible(false);
        this.lblChooseInputFile.setVisible(false);
        this.buttonInput.setVisible(false);
        this.textFieldInput.setVisible(false);
        this.lblOpenOutputFile.setVisible(false);
        this.checkboxOpenOutputPatterViewer.setVisible(false);
        this.checkboxOpenOutputText.setVisible(false);
    }

    private void openWebPage(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void openHelpWebPageForAlgorithm(String choice) throws Exception {
        AlgorithmManager manager = AlgorithmManager.getInstance();
        DescriptionOfAlgorithm algorithm = manager.getDescriptionOfAlgorithm(choice);
        if (algorithm != null) {
            this.openWebPage(algorithm.getURLOfDocumentation());
        }
    }

    private void askUserToChooseInputFile() {
        try {
            URL main;
            String previousPath = PreferencesManager.getInstance().getInputFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = new JFileChooser((File)path);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldInput.setText(file.getName());
                this.inputFile = file.getPath();
            }
            if (fc.getSelectedFile() != null) {
                PreferencesManager.getInstance().setInputFilePath(fc.getSelectedFile().getParent());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the input file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    private void askUserToChooseOutputFile() {
        try {
            URL main;
            String previousPath = PreferencesManager.getInstance().getOutputFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldOutput.setText(file.getName());
                this.outputFile = file.getPath();
                if (fc.getSelectedFile() != null) {
                    PreferencesManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the output file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
        String buffer = new String(new byte[]{83, 80, 77, 70});
        if (!this.getTitle().startsWith(buffer)) {
            this.setTitle(buffer);
        }
    }

    @Override
    public void notifyOfThreadComplete(Thread thread, boolean succeed) {
        if (succeed && this.lblSetOutputFile.isVisible()) {
            if (this.checkboxOpenOutputText.isSelected()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    try {
                        desktop.open(new File(this.outputFile));
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "The output file failed to open with the default application. \n This error occurs if there is no default application on your system for opening the output file or the application failed to start. \n\nTo fix the problem, consider changing the extension of the output file to .txt.\n\n ERROR MESSAGE = " + e.toString(), "Error", 0);
                    }
                    catch (SecurityException e) {
                        JOptionPane.showMessageDialog(null, "A security error occured while trying to open the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(null, "An error occured while opening the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
                    }
                }
            } else if (this.checkboxOpenOutputPatterViewer.isSelected()) {
                try {
                    PatternVizualizer desktop = new PatternVizualizer(this.outputFile);
                }
                catch (SecurityException e) {
                    JOptionPane.showMessageDialog(null, "A security error occured while trying to open the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
                }
                catch (Throwable e) {
                    JOptionPane.showMessageDialog(null, "An error occured while opening the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
                }
            }
        }
        this.buttonRun.setText("Run algorithm");
        this.progressBar.setIndeterminate(false);
        this.comboBox.setEnabled(true);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable e) {
        if (!(e instanceof ThreadDeath)) {
            if (e instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(null, "Error. Please check the parameters of the algorithm.  The format for numbers is incorrect. \n\n ERROR MESSAGE = " + e.toString(), "Error", 0);
            } else {
                JOptionPane.showMessageDialog(null, "An error occurred while trying to run the algorithm. \n ERROR MESSAGE = " + e.toString(), "Error", 0);
                e.printStackTrace();
            }
        }
        this.textArea.setText("");
    }

    private void processRunAlgorithmCommandFromGUI() {
        if (currentRunningAlgorithmThread != null && currentRunningAlgorithmThread.isAlive()) {
            currentRunningAlgorithmThread.stop();
            this.textArea.setText("Algorithm stopped. \n");
            this.buttonRun.setText("Run algorithm");
            this.progressBar.setIndeterminate(false);
            this.comboBox.setEnabled(true);
            return;
        }
        final String choice = (String)this.comboBox.getSelectedItem();
        final String[] parameters = new String[]{this.textFieldParam1.getText(), this.textFieldParam2.getText(), this.textFieldParam3.getText(), this.textFieldParam4.getText(), this.textFieldParam5.getText(), this.textFieldParam6.getText()};
        this.textArea.setText("Algorithm is running...\n");
        this.progressBar.setIndeterminate(true);
        this.buttonRun.setText("Stop algorithm");
        this.comboBox.setEnabled(false);
        currentRunningAlgorithmThread = new NotifyingThread(){

            @Override
            public void doRun() throws Exception {
                CommandProcessor.runAlgorithm(choice, MainWindow.this.inputFile, MainWindow.this.outputFile, parameters);
            }
        };
        currentRunningAlgorithmThread.addListener(this);
        currentRunningAlgorithmThread.setUncaughtExceptionHandler(this);
        currentRunningAlgorithmThread.start();
    }

    static class TextAreaOutputStream
    extends OutputStream {
        JTextArea textArea;

        public TextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void flush() {
            this.textArea.repaint();
        }

        @Override
        public void write(int b) {
            this.textArea.append(new String(new byte[]{(byte)b}));
        }
    }
}

