/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import java.nio.charset.Charset;
import java.util.prefs.Preferences;

public class PreferencesManager {
    public static final String REGKEY_SPMF_INPUT_FILE = "ca.pfv.spmf.gui.input";
    public static final String REGKEY_SPMF_OUTPUT_FILE = "ca.pfv.spmf.gui.output";
    public static final String REGKEY_SPMF_PREFERED_CHARSET = "ca.pfv.spmf.gui.charset";
    private static PreferencesManager instance;

    private PreferencesManager() {
    }

    public static PreferencesManager getInstance() {
        if (instance == null) {
            instance = new PreferencesManager();
        }
        return instance;
    }

    public String getInputFilePath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_INPUT_FILE, null);
    }

    public void setInputFilePath(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_INPUT_FILE, filepath);
    }

    public String getOutputFilePath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_OUTPUT_FILE, null);
    }

    public void setOutputFilePath(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_OUTPUT_FILE, filepath);
    }

    public Charset getPreferedCharset() {
        Preferences p = Preferences.userRoot();
        String charsetName = p.get(REGKEY_SPMF_PREFERED_CHARSET, null);
        return charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public void setPreferedCharset(String charsetName) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_PREFERED_CHARSET, charsetName);
    }
}

