/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_list_strings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sequence {
    private final List<List<String>> itemsets = new ArrayList<List<String>>();
    private int id;

    public Sequence(int id) {
        this.id = id;
    }

    public void addItemset(List<String> itemset) {
        this.itemsets.add(itemset);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (List<String> itemset : this.itemsets) {
            r.append('(');
            for (String item : itemset) {
                r.append(item);
                r.append(' ');
            }
            r.append(')');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<List<String>> getItemsets() {
        return this.itemsets;
    }

    public List<String> get(int index) {
        return this.itemsets.get(index);
    }

    public int size() {
        return this.itemsets.size();
    }

    public Sequence cloneSequenceMinusItems(Map<String, Set<Integer>> mapSequenceID, double relativeMinSup) {
        Sequence sequence = new Sequence(this.getId());
        for (List<String> itemset : this.itemsets) {
            List<String> newItemset = this.cloneItemsetMinusItems(itemset, mapSequenceID, relativeMinSup);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public List<String> cloneItemsetMinusItems(List<String> itemset, Map<String, Set<Integer>> mapSequenceID, double relativeMinsup) {
        ArrayList<String> newItemset = new ArrayList<String>();
        for (String item : itemset) {
            if (!((double)mapSequenceID.get(item).size() >= relativeMinsup)) continue;
            newItemset.add(item);
        }
        return newItemset;
    }
}

