/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.transaction_database_list_integers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransactionDatabase {
    private final Set<Integer> items = new HashSet<Integer>();
    private final List<List<Integer>> transactions = new ArrayList<List<Integer>>();

    public void addTransaction(List<Integer> transaction) {
        this.transactions.add(transaction);
        this.items.addAll(transaction);
    }

    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.addTransaction(thisLine.split(" "));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void addTransaction(String[] itemsString) {
        ArrayList<Integer> itemset = new ArrayList<Integer>();
        String[] stringArray = itemsString;
        int n = itemsString.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            int item = Integer.parseInt(attribute);
            itemset.add(item);
            this.items.add(item);
            ++n2;
        }
        this.transactions.add(itemset);
    }

    public void printDatabase() {
        System.out.println("===================  TRANSACTION DATABASE ===================");
        int count = 0;
        for (List<Integer> itemset : this.transactions) {
            System.out.print(String.valueOf(count) + ":  ");
            this.print(itemset);
            ++count;
        }
    }

    private void print(List<Integer> itemset) {
        StringBuilder r = new StringBuilder();
        for (Integer item : itemset) {
            r.append(item.toString());
            r.append(' ');
        }
        System.out.println(r);
    }

    public int size() {
        return this.transactions.size();
    }

    public List<List<Integer>> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getItems() {
        return this.items;
    }
}

