/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count;

public class Rule {
    private int[] itemset1;
    private int[] itemset2;
    private int coverage;
    private int transactionCount;
    private double confidence;

    public Rule(int[] itemset1, int[] itemset2, int coverage, int transactionCount, double confidence) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.coverage = coverage;
        this.transactionCount = transactionCount;
        this.confidence = confidence;
    }

    public double getRelativeSupport(int databaseSize) {
        return (double)this.transactionCount / (double)databaseSize;
    }

    public int getAbsoluteSupport() {
        return this.transactionCount;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.itemset1.length) {
            buffer.append(this.itemset1[i]);
            if (i != this.itemset1.length - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        buffer.append(" ==> ");
        i = 0;
        while (i < this.itemset2.length) {
            buffer.append(this.itemset2[i]);
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    public int[] getItemset1() {
        return this.itemset1;
    }

    public int[] getItemset2() {
        return this.itemset2;
    }
}

