/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_converter;

import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TransactionDatabaseConverter {
    String input;
    String output;
    int lineCount = 0;

    public void convert(String input, String output, Formats inputFileformat, int lineCount) throws IOException {
        this.input = input;
        this.output = output;
        this.lineCount = lineCount;
        if (inputFileformat.equals((Object)Formats.CSV_INTEGER)) {
            this.convertCSV();
        } else if (inputFileformat.equals((Object)Formats.ARFF)) {
            this.convertARFF(true, false);
        } else if (inputFileformat.equals((Object)Formats.ARFF_WITH_MISSING_VALUES)) {
            this.convertARFF(false, false);
        } else if (inputFileformat.equals((Object)Formats.SPMF_SEQUENCE_DB)) {
            this.convertSequenceDB();
        }
    }

    public Map<Integer, String> convertARFFandReturnMap(String inputFile, String outputFile, int lineCount) throws IOException {
        this.input = inputFile;
        this.output = outputFile;
        this.lineCount = lineCount;
        return this.convertARFF(true, true);
    }

    private Map<Integer, String> convertARFF(boolean ignoreMissingValues, boolean returnMapItemIDValue) throws IOException {
        HashMap<Integer, String> mapItemsIDsToAttributeValues = null;
        if (returnMapItemIDValue) {
            mapItemsIDsToAttributeValues = new HashMap<Integer, String>();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(this.input));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int count = 0;
                int attributeCount = 0;
                int lastItemAdded = 0;
                ArrayList mapAttributeValuesItemsID = null;
                ArrayList<String> listAttributeNames = new ArrayList<String>();
                while ((thisLine = myInput.readLine()) != null) {
                    Integer itemID;
                    int i;
                    int n;
                    String[] stringArray;
                    if (thisLine.length() < 2 || thisLine.startsWith("%")) continue;
                    int indexComment = thisLine.indexOf(37);
                    if (indexComment >= 0) {
                        thisLine = thisLine.substring(0, indexComment);
                    }
                    if (thisLine.startsWith("@RELATION") || thisLine.startsWith("@relation")) {
                        String relationName = thisLine.split(" ")[1];
                        if (relationName.contains("'")) {
                            relationName = relationName.split("'")[1];
                        }
                        if (returnMapItemIDValue) continue;
                        writer.write("@CONVERTED_FROM_ARFF");
                        writer.newLine();
                        writer.write("@RELATION_NAME=");
                        writer.write(String.valueOf(relationName) + "=");
                        writer.newLine();
                        continue;
                    }
                    if (thisLine.startsWith("@ATTRIBUTE") || thisLine.startsWith("@attribute")) {
                        String attributeName;
                        ++attributeCount;
                        if (!returnMapItemIDValue) {
                            writer.write("@ATTRIBUTE=");
                        }
                        int firstPositionOfAttributeName = thisLine.indexOf(32) + 1;
                        boolean useQuotes = false;
                        if (thisLine.charAt(firstPositionOfAttributeName) == '\'') {
                            useQuotes = true;
                            ++firstPositionOfAttributeName;
                        }
                        thisLine = thisLine.substring(firstPositionOfAttributeName);
                        thisLine = thisLine.trim();
                        if (useQuotes) {
                            int quotePosition = thisLine.indexOf(39);
                            attributeName = thisLine.substring(0, quotePosition);
                            if (!returnMapItemIDValue) {
                                writer.write(String.valueOf(attributeName) + "=");
                            }
                            listAttributeNames.add(attributeName);
                            thisLine = thisLine.substring(quotePosition + 1);
                        } else {
                            int spacePosition = thisLine.indexOf(32);
                            attributeName = thisLine.substring(0, spacePosition);
                            if (!returnMapItemIDValue) {
                                writer.write(String.valueOf(attributeName) + "=");
                            }
                            listAttributeNames.add(attributeName);
                            thisLine = thisLine.substring(spacePosition + 1);
                        }
                        String type = thisLine = thisLine.trim();
                        if (type.startsWith("{")) {
                            if (!returnMapItemIDValue) {
                                writer.write("ENUMERATION=");
                            }
                            thisLine = thisLine.substring(1, thisLine.length() - 1);
                            stringArray = thisLine.split(",");
                            n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String token = stringArray[n2];
                                token = token.trim();
                                if (!returnMapItemIDValue) {
                                    writer.write(String.valueOf(token) + "=");
                                }
                                ++n2;
                            }
                        } else if (!returnMapItemIDValue) {
                            writer.write(String.valueOf(type) + "=");
                        }
                        if (returnMapItemIDValue) continue;
                        writer.newLine();
                        continue;
                    }
                    if (thisLine.startsWith("@data") || thisLine.startsWith("@DATA")) {
                        mapAttributeValuesItemsID = new ArrayList(attributeCount);
                        int i2 = 0;
                        while (i2 < attributeCount) {
                            mapAttributeValuesItemsID.add(new HashMap());
                            ++i2;
                        }
                        continue;
                    }
                    ArrayList<Integer> transaction = new ArrayList<Integer>();
                    StringBuilder unseenAttributeValues = new StringBuilder();
                    if (thisLine.startsWith("{")) {
                        thisLine = thisLine.substring(1).trim();
                        thisLine = thisLine.substring(0, thisLine.length() - 1).trim();
                        HashSet<Integer> positionProcessed = new HashSet<Integer>();
                        stringArray = thisLine.split(",");
                        n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String entry = stringArray[n3];
                            entry = entry.trim();
                            int indexOfFirstSpace = entry.indexOf(32);
                            int i3 = Integer.parseInt(entry.substring(0, indexOfFirstSpace));
                            String val = entry.substring(indexOfFirstSpace + 1);
                            positionProcessed.add(i3);
                            if (!"?".equals(val) || !ignoreMissingValues) {
                                Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i3);
                                Integer itemID2 = (Integer)mapValueToItemID.get(val);
                                if (itemID2 == null) {
                                    itemID2 = ++lastItemAdded;
                                    mapValueToItemID.put(val, itemID2);
                                    if (mapItemsIDsToAttributeValues != null) {
                                        mapItemsIDsToAttributeValues.put(itemID2, String.valueOf((String)listAttributeNames.get(i3)) + "=" + val);
                                    }
                                    unseenAttributeValues.append("@ITEM=" + itemID2 + "=" + (String)listAttributeNames.get(i3) + "=" + val + "\n");
                                }
                                transaction.add(itemID2);
                            }
                            ++n3;
                        }
                        i = 0;
                        while (i < attributeCount) {
                            String val;
                            if (!(positionProcessed.contains(i) || "?".equals(val = "0") && ignoreMissingValues)) {
                                Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i);
                                itemID = (Integer)mapValueToItemID.get(val);
                                if (itemID == null) {
                                    itemID = ++lastItemAdded;
                                    mapValueToItemID.put(val, itemID);
                                    if (mapItemsIDsToAttributeValues != null) {
                                        mapItemsIDsToAttributeValues.put(itemID, String.valueOf((String)listAttributeNames.get(i)) + "=" + val);
                                    }
                                    unseenAttributeValues.append("@ITEM=" + itemID + "=" + (String)listAttributeNames.get(i) + "=" + val + "\n");
                                }
                                transaction.add(itemID);
                            }
                            ++i;
                        }
                    } else {
                        String[] split = thisLine.split(",");
                        i = 0;
                        while (i < attributeCount) {
                            String val = split[i].trim();
                            if (!"?".equals(val) || !ignoreMissingValues) {
                                Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i);
                                itemID = (Integer)mapValueToItemID.get(val);
                                if (itemID == null) {
                                    itemID = ++lastItemAdded;
                                    mapValueToItemID.put(val, itemID);
                                    if (mapItemsIDsToAttributeValues != null) {
                                        mapItemsIDsToAttributeValues.put(itemID, String.valueOf((String)listAttributeNames.get(i)) + "=" + val);
                                    }
                                    unseenAttributeValues.append("@ITEM=" + itemID + "=" + (String)listAttributeNames.get(i) + "=" + val + "\n");
                                }
                                transaction.add(itemID);
                            }
                            ++i;
                        }
                    }
                    Collections.sort(transaction);
                    writer.write(unseenAttributeValues.toString());
                    int i4 = 0;
                    while (i4 < transaction.size()) {
                        if (i4 != transaction.size() - 1) {
                            writer.write(transaction.get(i4) + " ");
                        } else {
                            writer.write("" + transaction.get(i4));
                        }
                        ++i4;
                    }
                    writer.newLine();
                    if (++count == this.lineCount) break;
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
        return mapItemsIDsToAttributeValues;
    }

    private void convertCSV() throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
                FileInputStream fin = new FileInputStream(new File(this.input));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int count = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    if (count != 0) {
                        writer.newLine();
                    }
                    String[] split = thisLine.split(",");
                    HashSet<Integer> values = new HashSet<Integer>();
                    int i = 0;
                    while (i < split.length) {
                        values.add(Integer.parseInt(split[i]));
                        ++i;
                    }
                    ArrayList listValues = new ArrayList(values);
                    Collections.sort(listValues);
                    int i2 = 0;
                    while (i2 < listValues.size()) {
                        if (i2 != listValues.size() - 1) {
                            writer.write(listValues.get(i2) + " ");
                        } else {
                            writer.write("" + listValues.get(i2));
                        }
                        ++i2;
                    }
                    if (++count == this.lineCount) break;
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void convertSequenceDB() throws IOException {
        SequenceDatabase database = new SequenceDatabase();
        database.loadFile(this.input);
        try (BufferedReader myInput = null;){
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
                int i = 0;
                while (i < database.getSequences().size()) {
                    Sequence sequence = database.getSequences().get(i);
                    HashSet<Integer> itemsInSequence = new HashSet<Integer>();
                    ArrayList<Integer> transaction = new ArrayList<Integer>();
                    Iterator<Integer[]> iterator = sequence.getItemsets().iterator();
                    while (iterator.hasNext()) {
                        Integer[] itemset;
                        Integer[] integerArray = itemset = iterator.next();
                        int n = itemset.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Integer item = integerArray[n2];
                            if (!itemsInSequence.contains(item)) {
                                transaction.add(item);
                                itemsInSequence.add(item);
                            }
                            ++n2;
                        }
                    }
                    Collections.sort(transaction);
                    int j = 0;
                    while (j < transaction.size()) {
                        writer.write(transaction.get(j) + " ");
                        ++j;
                    }
                    if (i + 1 == this.lineCount) break;
                    if (i != database.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }
}

