/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_stats;

import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TransactionStatsGenerator {
    public void getStats(String path) throws IOException {
        TransactionDatabase database = new TransactionDatabase();
        database.loadFile(path);
        System.out.println("============  TRANSACTION DATABASE STATS ==========");
        System.out.println("Number of transactions : " + database.size());
        int minItem = Integer.MAX_VALUE;
        int maxItem = 0;
        HashSet<Integer> items = new HashSet<Integer>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        HashMap<Integer, Integer> mapItemSupport = new HashMap<Integer, Integer>();
        for (List<Integer> transaction : database.getTransactions()) {
            sizes.add(transaction.size());
            for (int item : transaction) {
                Integer count;
                if (item > maxItem) {
                    maxItem = item;
                }
                if (item < minItem) {
                    minItem = item;
                }
                if ((count = (Integer)mapItemSupport.get(item)) == null) {
                    count = 0;
                }
                mapItemSupport.put(item, count + 1);
                items.add(item);
            }
        }
        ArrayList<Integer> listSupportOfItems = new ArrayList<Integer>(mapItemSupport.values());
        System.out.println("File " + path);
        System.out.println("Number of distinct items: " + items.size());
        System.out.println("Smallest item id: " + minItem);
        System.out.println("Largest item id: " + maxItem);
        System.out.println("Average number of items per transaction: " + TransactionStatsGenerator.calculateMean(sizes) + " standard deviation: " + TransactionStatsGenerator.calculateStdDeviation(sizes) + " variance: " + TransactionStatsGenerator.calculateVariance(sizes));
        System.out.println("Average item support in the database: " + TransactionStatsGenerator.calculateMean(listSupportOfItems) + " standard deviation: " + TransactionStatsGenerator.calculateStdDeviation(listSupportOfItems) + " variance: " + TransactionStatsGenerator.calculateVariance(listSupportOfItems) + " min value: " + TransactionStatsGenerator.calculateMinValue(listSupportOfItems) + " max value: " + TransactionStatsGenerator.calculateMaxValue(listSupportOfItems));
    }

    private static double calculateMean(List<Integer> list) {
        double sum = 0.0;
        for (Integer val : list) {
            sum += (double)val.intValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviation(List<Integer> list) {
        double deviation = 0.0;
        double mean = TransactionStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateMeanD(List<Double> list) {
        double sum = 0.0;
        for (Double val : list) {
            sum += val.doubleValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviationD(List<Double> list) {
        double deviation = 0.0;
        double mean = TransactionStatsGenerator.calculateMeanD(list);
        for (Double val : list) {
            deviation += Math.pow(mean - val, 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateVariance(List<Integer> list) {
        double deviation = 0.0;
        double mean = TransactionStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.pow(Math.sqrt(deviation / (double)list.size()), 2.0);
    }

    private static int calculateMinValue(List<Integer> list) {
        int min = Integer.MAX_VALUE;
        for (Integer val : list) {
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    private static int calculateMaxValue(List<Integer> list) {
        int max = 0;
        for (Integer val : list) {
            if (val < max) continue;
            max = val;
        }
        return max;
    }
}

