/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.resultConverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ResultConverter {
    public void convert(Map<Integer, String> mapItemIDtoStringValue, String outputFile, String outputFileConverted, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        FileInputStream finResult = new FileInputStream(new File(outputFile));
        BufferedReader myInputResult = new BufferedReader(new InputStreamReader(finResult));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileConverted), charset));
        String thisLine = null;
        boolean firstLine = true;
        while ((thisLine = myInputResult.readLine()) != null) {
            boolean noItemsLeft = false;
            if (thisLine.isEmpty()) continue;
            if (firstLine) {
                firstLine = false;
            } else {
                writer.newLine();
            }
            String[] split = thisLine.split(" ");
            int i = 0;
            while (i < split.length) {
                String token = split[i];
                if (token.startsWith("#") || noItemsLeft) {
                    noItemsLeft = true;
                    writer.write(token);
                } else {
                    Integer itemID = this.isInteger(token);
                    if (itemID == null) {
                        if (token.indexOf(44) >= 0) {
                            String[] parts = token.split(",");
                            int m = 0;
                            while (m < parts.length) {
                                Integer item = Integer.parseInt(parts[m]);
                                String stringRepresentation = mapItemIDtoStringValue.get(item);
                                writer.write(stringRepresentation);
                                if (m < parts.length - 1) {
                                    writer.write(",");
                                }
                                ++m;
                            }
                        } else {
                            writer.write(token);
                        }
                    } else if (itemID >= 0) {
                        writer.write(mapItemIDtoStringValue.get(itemID));
                    }
                }
                if (i != split.length - 1) {
                    writer.write(" ");
                }
                ++i;
            }
        }
        myInputResult.close();
        writer.close();
    }

    public void convert(String inputDB, String outputFile, String outputFileConverted, Charset charset) throws IOException {
        String thisLine;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        FileInputStream fin = new FileInputStream(new File(inputDB));
        BufferedReader myInputDB = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
        HashMap<Integer, String> mapItemIDtoStringValue = new HashMap<Integer, String>();
        while ((thisLine = myInputDB.readLine()) != null) {
            if (!thisLine.startsWith("@ITEM")) continue;
            thisLine = thisLine.substring(6);
            int index = thisLine.indexOf("=");
            int itemID = Integer.parseInt(thisLine.substring(0, index));
            String stringValue = thisLine.substring(index + 1);
            mapItemIDtoStringValue.put(itemID, stringValue);
        }
        myInputDB.close();
        this.convert(mapItemIDtoStringValue, outputFile, outputFileConverted, charset);
    }

    Integer isInteger(String string) {
        Integer result = null;
        try {
            result = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }
}

