/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import weka.core.FastVector;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.graphvisualizer.Messages;

public class HierarchicalBCEngine
implements GraphConstants,
LayoutEngine {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected FastVector layoutCompleteListeners;
    protected int[][] graphMatrix;
    protected int[][] nodeLevels;
    protected int m_nodeWidth;
    protected int m_nodeHeight;
    protected JRadioButton m_jRbNaiveLayout;
    protected JRadioButton m_jRbPriorityLayout;
    protected JRadioButton m_jRbTopdown;
    protected JRadioButton m_jRbBottomup;
    protected JCheckBox m_jCbEdgeConcentration;
    protected JPanel m_controlsPanel;
    protected JProgressBar m_progress;
    protected boolean m_completeReLayout = false;
    private int origNodesSize;

    public HierarchicalBCEngine(FastVector nodes, FastVector edges, int nodeWidth, int nodeHeight) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(false);
    }

    public HierarchicalBCEngine(FastVector nodes, FastVector edges, int nodeWidth, int nodeHeight, boolean edgeConcentration) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(edgeConcentration);
    }

    public HierarchicalBCEngine() {
    }

    protected void makeGUIPanel(boolean edgeConc) {
        Messages.getInstance();
        this.m_jRbNaiveLayout = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbTopdown_JRadioButton_Text"));
        Messages.getInstance();
        this.m_jRbPriorityLayout = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbPriorityLayout_JRadioButton_Text"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_jRbNaiveLayout);
        bg.add(this.m_jRbPriorityLayout);
        this.m_jRbPriorityLayout.setSelected(true);
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                HierarchicalBCEngine.this.m_completeReLayout = true;
            }
        };
        Messages.getInstance();
        this.m_jRbTopdown = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbTopdown_JRadioButton_Text"));
        Messages.getInstance();
        this.m_jRbBottomup = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbBottomup_JRadioButton_Text"));
        this.m_jRbTopdown.addActionListener(a);
        this.m_jRbBottomup.addActionListener(a);
        bg = new ButtonGroup();
        bg.add(this.m_jRbTopdown);
        bg.add(this.m_jRbBottomup);
        this.m_jRbBottomup.setSelected(true);
        Messages.getInstance();
        this.m_jCbEdgeConcentration = new JCheckBox(Messages.getString("HierarchicalBCEngine_JP1_JPanel_BorderFactoryCreateTitledBorder_Text"), edgeConc);
        this.m_jCbEdgeConcentration.setSelected(edgeConc);
        this.m_jCbEdgeConcentration.addActionListener(a);
        JPanel jp1 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jp1.add((Component)this.m_jRbNaiveLayout, gbc);
        jp1.add((Component)this.m_jRbPriorityLayout, gbc);
        Messages.getInstance();
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("HierarchicalBCEngine_JP1_SetBorder_Text")));
        JPanel jp2 = new JPanel(new GridBagLayout());
        jp2.add((Component)this.m_jRbTopdown, gbc);
        jp2.add((Component)this.m_jRbBottomup, gbc);
        Messages.getInstance();
        jp2.setBorder(BorderFactory.createTitledBorder(Messages.getString("HierarchicalBCEngine_JP2_BorderFactoryCreateTitledBorder_Text")));
        this.m_progress = new JProgressBar(0, 11);
        this.m_progress.setBorderPainted(false);
        this.m_progress.setStringPainted(true);
        this.m_progress.setString("");
        this.m_progress.setValue(0);
        this.m_controlsPanel = new JPanel(new GridBagLayout());
        this.m_controlsPanel.add((Component)jp1, gbc);
        this.m_controlsPanel.add((Component)jp2, gbc);
        this.m_controlsPanel.add((Component)this.m_jCbEdgeConcentration, gbc);
    }

    public FastVector getNodes() {
        return this.m_nodes;
    }

    public JPanel getControlPanel() {
        return this.m_controlsPanel;
    }

    public JProgressBar getProgressBar() {
        return this.m_progress;
    }

    public void setNodesEdges(FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    public void setNodeSize(int nodeWidth, int nodeHeight) {
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
    }

    public void addLayoutCompleteEventListener(LayoutCompleteEventListener l) {
        if (this.layoutCompleteListeners == null) {
            this.layoutCompleteListeners = new FastVector();
        }
        this.layoutCompleteListeners.addElement(l);
    }

    public void removeLayoutCompleteEventListener(LayoutCompleteEventListener e) {
        if (this.layoutCompleteListeners != null) {
            for (int i = 0; i < this.layoutCompleteListeners.size(); ++i) {
                LayoutCompleteEventListener l = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                if (l != e) continue;
                this.layoutCompleteListeners.removeElementAt(i);
                return;
            }
            Messages.getInstance();
            System.err.println(Messages.getString("HierarchicalBCEngine_RemoveLayoutCompleteEventListener_Error_Text_First"));
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("HierarchicalBCEngine_RemoveLayoutCompleteEventListener_Error_Text_Second"));
        }
    }

    public void fireLayoutCompleteEvent(LayoutCompleteEvent e) {
        if (this.layoutCompleteListeners != null && this.layoutCompleteListeners.size() != 0) {
            for (int i = 0; i < this.layoutCompleteListeners.size(); ++i) {
                LayoutCompleteEventListener l = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                l.layoutCompleted(e);
            }
        }
    }

    public void layoutGraph() {
        if (this.m_nodes == null || this.m_edges == null) {
            return;
        }
        Thread th = new Thread(){

            public void run() {
                HierarchicalBCEngine.this.m_progress.setBorderPainted(true);
                if (HierarchicalBCEngine.this.nodeLevels == null) {
                    HierarchicalBCEngine.this.makeProperHierarchy();
                } else if (HierarchicalBCEngine.this.m_completeReLayout) {
                    HierarchicalBCEngine.this.clearTemps_and_EdgesFromNodes();
                    HierarchicalBCEngine.this.makeProperHierarchy();
                    HierarchicalBCEngine.this.m_completeReLayout = false;
                }
                if (HierarchicalBCEngine.this.m_jRbTopdown.isSelected()) {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i + 4);
                        JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        jProgressBar.setString(stringBuilder.append(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_First")).append(i + 1).toString());
                        if (i != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(false, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i < 6);
                } else {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i + 4);
                        JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        jProgressBar.setString(stringBuilder.append(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Second")).append(i + 1).toString());
                        if (i != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(true, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i < 6);
                }
                HierarchicalBCEngine.this.m_progress.setValue(10);
                JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                Messages.getInstance();
                jProgressBar.setString(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Third"));
                if (HierarchicalBCEngine.this.m_jRbNaiveLayout.isSelected()) {
                    HierarchicalBCEngine.this.naiveLayout();
                } else {
                    HierarchicalBCEngine.this.priorityLayout1();
                }
                HierarchicalBCEngine.this.m_progress.setValue(11);
                JProgressBar jProgressBar2 = HierarchicalBCEngine.this.m_progress;
                Messages.getInstance();
                jProgressBar2.setString(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Fourth"));
                HierarchicalBCEngine.this.m_progress.repaint();
                HierarchicalBCEngine.this.fireLayoutCompleteEvent(new LayoutCompleteEvent(this));
                HierarchicalBCEngine.this.m_progress.setValue(0);
                HierarchicalBCEngine.this.m_progress.setString("");
                HierarchicalBCEngine.this.m_progress.setBorderPainted(false);
            }
        };
        th.start();
    }

    protected void clearTemps_and_EdgesFromNodes() {
        int curSize = this.m_nodes.size();
        for (int i = this.origNodesSize; i < curSize; ++i) {
            this.m_nodes.removeElementAt(this.origNodesSize);
        }
        for (int j = 0; j < this.m_nodes.size(); ++j) {
            ((GraphNode)this.m_nodes.elementAt((int)j)).edges = null;
        }
        this.nodeLevels = null;
    }

    protected void processGraph() {
        this.origNodesSize = this.m_nodes.size();
        this.graphMatrix = new int[this.m_nodes.size()][this.m_nodes.size()];
        for (int i = 0; i < this.m_edges.size(); ++i) {
            this.graphMatrix[((GraphEdge)this.m_edges.elementAt((int)i)).src][((GraphEdge)this.m_edges.elementAt((int)i)).dest] = ((GraphEdge)this.m_edges.elementAt((int)i)).type;
        }
    }

    protected void makeProperHierarchy() {
        int i;
        int i2;
        this.processGraph();
        this.m_progress.setValue(1);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_First"));
        this.removeCycles();
        this.m_progress.setValue(2);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_Second"));
        int[] nodesLevel = new int[this.m_nodes.size()];
        int depth = 0;
        for (i2 = 0; i2 < this.graphMatrix.length; ++i2) {
            this.assignLevels(nodesLevel, depth, i2, 0);
        }
        for (i2 = 0; i2 < nodesLevel.length; ++i2) {
            if (nodesLevel[i2] != 0) continue;
            int min = 65536;
            for (int j = 0; j < this.graphMatrix[i2].length; ++j) {
                if (this.graphMatrix[i2][j] != 1 || min <= nodesLevel[j]) continue;
                min = nodesLevel[j];
            }
            if (min == 65536 || min <= 1) continue;
            nodesLevel[i2] = min - 1;
        }
        int maxLevel = 0;
        for (int i3 = 0; i3 < nodesLevel.length; ++i3) {
            if (nodesLevel[i3] <= maxLevel) continue;
            maxLevel = nodesLevel[i3];
        }
        int[] levelCounts = new int[maxLevel + 1];
        for (int i4 = 0; i4 < nodesLevel.length; ++i4) {
            int n = nodesLevel[i4];
            levelCounts[n] = levelCounts[n] + 1;
        }
        int[] levelsCounter = new int[maxLevel + 1];
        this.nodeLevels = new int[maxLevel + 1][];
        for (i = 0; i < nodesLevel.length; ++i) {
            if (this.nodeLevels[nodesLevel[i]] == null) {
                this.nodeLevels[nodesLevel[i]] = new int[levelCounts[nodesLevel[i]]];
            }
            int n = nodesLevel[i];
            int n2 = levelsCounter[n];
            levelsCounter[n] = n2 + 1;
            this.nodeLevels[nodesLevel[i]][n2] = i;
        }
        this.m_progress.setValue(3);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_Third"));
        if (this.m_jCbEdgeConcentration.isSelected()) {
            this.removeGapsWithEdgeConcentration(nodesLevel);
        } else {
            this.removeGaps(nodesLevel);
        }
        for (i = 0; i < this.graphMatrix.length; ++i) {
            int j;
            GraphNode n = (GraphNode)this.m_nodes.elementAt(i);
            int sum = 0;
            for (j = 0; j < this.graphMatrix[i].length; ++j) {
                if (this.graphMatrix[i][j] == 0) continue;
                ++sum;
            }
            n.edges = new int[sum][2];
            int k = 0;
            for (j = 0; j < this.graphMatrix[i].length; ++j) {
                if (this.graphMatrix[i][j] == 0) continue;
                n.edges[k][0] = j;
                n.edges[k][1] = this.graphMatrix[i][j];
                ++k;
            }
        }
    }

    private void removeGaps(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        for (int n = 0; n < temp; ++n) {
            for (int i = 0; i < temp2; ++i) {
                int len = this.graphMatrix.length;
                if (this.graphMatrix[n][i] <= 0) continue;
                if (nodesLevel[i] > nodesLevel[n] + 1) {
                    int k;
                    int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i] - nodesLevel[n] - 1)][this.graphMatrix.length + (nodesLevel[i] - nodesLevel[n] - 1)];
                    int level = nodesLevel[n] + 1;
                    this.copyMatrix(this.graphMatrix, tempMatrix);
                    String s1 = new String("S" + tempCnt++);
                    this.m_nodes.addElement(new GraphNode(s1, s1, 1));
                    int[] temp3 = new int[this.nodeLevels[level].length + 1];
                    System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                    temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[level] = temp3;
                    ++level;
                    for (k = len; k < len + nodesLevel[i] - nodesLevel[n] - 1 - 1; ++k) {
                        String s2 = new String("S" + tempCnt);
                        this.m_nodes.addElement(new GraphNode(s2, s2, 1));
                        temp3 = new int[this.nodeLevels[level].length + 1];
                        System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                        temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[level++] = temp3;
                        tempMatrix[k][k + 1] = tempMatrix[n][i];
                        ++tempCnt;
                        if (k <= len) continue;
                        tempMatrix[k][k - 1] = -1 * tempMatrix[n][i];
                    }
                    tempMatrix[k][i] = tempMatrix[n][i];
                    tempMatrix[n][len] = tempMatrix[n][i];
                    tempMatrix[len][n] = -1 * tempMatrix[n][i];
                    tempMatrix[i][k] = -1 * tempMatrix[n][i];
                    if (k > len) {
                        tempMatrix[k][k - 1] = -1 * tempMatrix[n][i];
                    }
                    tempMatrix[n][i] = 0;
                    tempMatrix[i][n] = 0;
                    this.graphMatrix = tempMatrix;
                    continue;
                }
                this.graphMatrix[i][n] = -1 * this.graphMatrix[n][i];
            }
        }
    }

    private void removeGapsWithEdgeConcentration(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        for (int n = 0; n < temp; ++n) {
            for (int i = 0; i < temp2; ++i) {
                if (this.graphMatrix[n][i] <= 0) continue;
                if (nodesLevel[i] > nodesLevel[n] + 1) {
                    int m;
                    boolean tempNodePresent = false;
                    int k = temp;
                    int tempnode = n;
                    for (int tempLevel = nodesLevel[n]; tempLevel < nodesLevel[i] - 1; ++tempLevel) {
                        tempNodePresent = false;
                        while (k < this.graphMatrix.length) {
                            if (this.graphMatrix[tempnode][k] > 0) {
                                tempNodePresent = true;
                                break;
                            }
                            ++k;
                        }
                        if (tempNodePresent) {
                            tempnode = k++;
                            continue;
                        }
                        if (tempnode == n) break;
                        tempnode = k - 1;
                        break;
                    }
                    if (((GraphNode)this.m_nodes.elementAt((int)tempnode)).nodeType == 1) {
                        ((GraphNode)this.m_nodes.elementAt((int)tempnode)).nodeType = 2;
                    }
                    if (tempNodePresent) {
                        this.graphMatrix[tempnode][i] = this.graphMatrix[n][i];
                        this.graphMatrix[i][tempnode] = -this.graphMatrix[n][i];
                        this.graphMatrix[n][i] = 0;
                        this.graphMatrix[i][n] = 0;
                        continue;
                    }
                    int len = this.graphMatrix.length;
                    int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i] - nodesLevel[tempnode] - 1)][this.graphMatrix.length + (nodesLevel[i] - nodesLevel[tempnode] - 1)];
                    int level = nodesLevel[tempnode] + 1;
                    this.copyMatrix(this.graphMatrix, tempMatrix);
                    String s1 = new String("S" + tempCnt++);
                    this.m_nodes.addElement(new GraphNode(s1, s1, 1));
                    int[] temp3 = new int[this.nodeLevels[level].length + 1];
                    System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                    temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[level] = temp3;
                    temp3 = new int[this.m_nodes.size() + 1];
                    System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                    temp3[this.m_nodes.size() - 1] = level++;
                    nodesLevel = temp3;
                    for (m = len; m < len + nodesLevel[i] - nodesLevel[tempnode] - 1 - 1; ++m) {
                        String s2 = new String("S" + tempCnt++);
                        this.m_nodes.addElement(new GraphNode(s2, s2, 1));
                        temp3 = new int[this.nodeLevels[level].length + 1];
                        System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                        temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[level] = temp3;
                        temp3 = new int[this.m_nodes.size() + 1];
                        System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                        temp3[this.m_nodes.size() - 1] = level++;
                        nodesLevel = temp3;
                        tempMatrix[m][m + 1] = tempMatrix[n][i];
                        if (m <= len) continue;
                        tempMatrix[m][m - 1] = -1 * tempMatrix[n][i];
                    }
                    tempMatrix[m][i] = tempMatrix[n][i];
                    tempMatrix[tempnode][len] = tempMatrix[n][i];
                    tempMatrix[len][tempnode] = -1 * tempMatrix[n][i];
                    tempMatrix[i][m] = -1 * tempMatrix[n][i];
                    if (m > len) {
                        tempMatrix[m][m - 1] = -1 * tempMatrix[n][i];
                    }
                    tempMatrix[n][i] = 0;
                    tempMatrix[i][n] = 0;
                    this.graphMatrix = tempMatrix;
                    continue;
                }
                this.graphMatrix[i][n] = -1 * this.graphMatrix[n][i];
            }
        }
    }

    private int indexOfElementInLevel(int element, int[] level) throws Exception {
        for (int i = 0; i < level.length; ++i) {
            if (level[i] != element) continue;
            return i;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_IndexOfElementInLevel_Exception_Text_First")).append(((GraphNode)this.m_nodes.elementAt((int)element)).ID);
        Messages.getInstance();
        throw new Exception(stringBuilder2.append(Messages.getString("HierarchicalBCEngine_IndexOfElementInLevel_Exception_Text_Second")).append("weka.gui.graphvisualizer.HierarchicalBCEngine").toString());
    }

    protected int crossings(int[][] levels) {
        int sum = 0;
        for (int i = 0; i < levels.length - 1; ++i) {
            MyList upper = new MyList();
            MyList lower = new MyList();
            MyListNode[] lastOcrnce = new MyListNode[this.m_nodes.size()];
            int[] edgeOcrnce = new int[this.m_nodes.size()];
            int uidx = 0;
            int lidx = 0;
            for (int j = 0; j < levels[i].length + levels[i + 1].length; ++j) {
                MyListNode temp;
                int k;
                GraphNode n;
                int k3;
                int k2;
                int k1;
                if (j % 2 == 0 && uidx < levels[i].length || lidx >= levels[i + 1].length) {
                    k1 = 0;
                    k2 = 0;
                    k3 = 0;
                    n = (GraphNode)this.m_nodes.elementAt(levels[i][uidx]);
                    if (lastOcrnce[levels[i][uidx]] != null) {
                        MyListNode temp2 = new MyListNode(-1);
                        temp2.next = upper.first;
                        try {
                            do {
                                temp2 = temp2.next;
                                if (levels[i][uidx] == temp2.n) {
                                    ++k1;
                                    k3 += k2;
                                    upper.remove(temp2);
                                    continue;
                                }
                                ++k2;
                            } while (temp2 != lastOcrnce[levels[i][uidx]]);
                        }
                        catch (NullPointerException ex) {
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_First")).append(levels[i][uidx]);
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Second")).append(((GraphNode)this.m_nodes.elementAt((int)levels[i][uidx])).ID);
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Third")).append(temp2);
                            Messages.getInstance();
                            System.out.println(stringBuilder4.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Fourth")).append(upper.first).toString());
                            ex.printStackTrace();
                            System.exit(-1);
                        }
                        lastOcrnce[levels[i][uidx]] = null;
                        sum = sum + k1 * lower.size() + k3;
                    }
                    for (k = 0; k < n.edges.length; ++k) {
                        if (n.edges[k][1] <= 0) continue;
                        try {
                            if (this.indexOfElementInLevel(n.edges[k][0], levels[i + 1]) < uidx) continue;
                            edgeOcrnce[n.edges[k][0]] = 1;
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    for (k = 0; k < levels[i + 1].length; ++k) {
                        if (edgeOcrnce[levels[i + 1][k]] != 1) continue;
                        temp = new MyListNode(levels[i + 1][k]);
                        lower.add(temp);
                        lastOcrnce[levels[i + 1][k]] = temp;
                        edgeOcrnce[levels[i + 1][k]] = 0;
                    }
                    ++uidx;
                    continue;
                }
                k1 = 0;
                k2 = 0;
                k3 = 0;
                n = (GraphNode)this.m_nodes.elementAt(levels[i + 1][lidx]);
                if (lastOcrnce[levels[i + 1][lidx]] != null) {
                    MyListNode temp3 = new MyListNode(-1);
                    temp3.next = lower.first;
                    try {
                        do {
                            temp3 = temp3.next;
                            if (levels[i + 1][lidx] == temp3.n) {
                                ++k1;
                                k3 += k2;
                                lower.remove(temp3);
                                continue;
                            }
                            ++k2;
                        } while (temp3 != lastOcrnce[levels[i + 1][lidx]]);
                    }
                    catch (NullPointerException ex) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Fifth")).append(levels[i + 1][lidx]);
                        Messages.getInstance();
                        StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Sixth")).append(((GraphNode)this.m_nodes.elementAt((int)levels[i + 1][lidx])).ID);
                        Messages.getInstance();
                        System.out.print(stringBuilder6.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Seventh")).append(temp3).toString());
                        StringBuilder stringBuilder7 = new StringBuilder();
                        Messages.getInstance();
                        System.out.println(stringBuilder7.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Eighth")).append(lower.first).toString());
                        ex.printStackTrace();
                        System.exit(-1);
                    }
                    lastOcrnce[levels[i + 1][lidx]] = null;
                    sum = sum + k1 * upper.size() + k3;
                }
                for (k = 0; k < n.edges.length; ++k) {
                    if (n.edges[k][1] >= 0) continue;
                    try {
                        if (this.indexOfElementInLevel(n.edges[k][0], levels[i]) <= lidx) continue;
                        edgeOcrnce[n.edges[k][0]] = 1;
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (k = 0; k < levels[i].length; ++k) {
                    if (edgeOcrnce[levels[i][k]] != 1) continue;
                    temp = new MyListNode(levels[i][k]);
                    upper.add(temp);
                    lastOcrnce[levels[i][k]] = temp;
                    edgeOcrnce[levels[i][k]] = 0;
                }
                ++lidx;
            }
        }
        return sum;
    }

    protected void removeCycles() {
        int[] visited = new int[this.m_nodes.size()];
        for (int i = 0; i < this.graphMatrix.length; ++i) {
            if (visited[i] != 0) continue;
            this.removeCycles2(i, visited);
            visited[i] = 1;
        }
    }

    private void removeCycles2(int nindex, int[] visited) {
        visited[nindex] = 2;
        for (int i = 0; i < this.graphMatrix[nindex].length; ++i) {
            if (this.graphMatrix[nindex][i] != 1) continue;
            if (visited[i] == 0) {
                this.removeCycles2(i, visited);
                visited[i] = 1;
                continue;
            }
            if (visited[i] != 2) continue;
            if (nindex == i) {
                this.graphMatrix[nindex][i] = 0;
                continue;
            }
            if (this.graphMatrix[i][nindex] == 1) {
                this.graphMatrix[i][nindex] = 3;
                this.graphMatrix[nindex][i] = -3;
                continue;
            }
            this.graphMatrix[i][nindex] = 2;
            this.graphMatrix[nindex][i] = -2;
        }
    }

    protected void assignLevels(int[] levels, int depth, int i, int j) {
        if (i >= this.graphMatrix.length) {
            return;
        }
        if (j >= this.graphMatrix[i].length) {
            return;
        }
        if (this.graphMatrix[i][j] <= 0) {
            this.assignLevels(levels, depth, i, ++j);
        } else if (this.graphMatrix[i][j] == 1 || this.graphMatrix[i][j] == 3) {
            if (depth + 1 > levels[j]) {
                levels[j] = depth + 1;
                this.assignLevels(levels, depth + 1, j, 0);
            }
            this.assignLevels(levels, depth, i, ++j);
        }
    }

    private int[][] minimizeCrossings(boolean reversed, int[][] nodeLevels) {
        if (!reversed) {
            for (int times = 0; times < 1; ++times) {
                int i;
                int[][] tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i = 0; i < ((int[][])nodeLevels).length - 1; ++i) {
                    this.phaseID(i, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i = ((int[][])nodeLevels).length - 2; i >= 0; --i) {
                    this.phaseIU(i, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i = 0; i < ((int[][])nodeLevels).length - 1; ++i) {
                    this.phaseIID(i, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i = ((int[][])nodeLevels).length - 2; i >= 0; --i) {
                    this.phaseIIU(i, tempLevels);
                }
                if (this.crossings(tempLevels) >= this.crossings((int[][])nodeLevels)) continue;
                nodeLevels = tempLevels;
            }
            return nodeLevels;
        }
        for (int times = 0; times < 1; ++times) {
            int i;
            int[][] tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i = ((int[][])nodeLevels).length - 2; i >= 0; --i) {
                this.phaseIU(i, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i = 0; i < ((int[][])nodeLevels).length - 1; ++i) {
                this.phaseID(i, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i = ((int[][])nodeLevels).length - 2; i >= 0; --i) {
                this.phaseIIU(i, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i = 0; i < ((int[][])nodeLevels).length - 1; ++i) {
                this.phaseIID(i, tempLevels);
            }
            if (this.crossings(tempLevels) >= this.crossings((int[][])nodeLevels)) continue;
            nodeLevels = tempLevels;
        }
        return nodeLevels;
    }

    protected void phaseID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex + 1], colBC);
    }

    public void phaseIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex], rowBC);
    }

    public void phaseIID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        for (int i = 0; i < colBC.length - 1; ++i) {
            int k;
            if (colBC[i] != colBC[i + 1]) continue;
            int[][] tempLevels = new int[levels.length][];
            this.copy2DArray(levels, tempLevels);
            int node1 = levels[lindex + 1][i];
            int node2 = levels[lindex + 1][i + 1];
            levels[lindex + 1][i + 1] = node1;
            levels[lindex + 1][i] = node2;
            for (k = lindex + 1; k < levels.length - 1; ++k) {
                this.phaseID(k, levels);
            }
            if (this.crossings(levels) <= this.crossings(tempLevels)) {
                this.copy2DArray(levels, tempLevels);
            } else {
                this.copy2DArray(tempLevels, levels);
                levels[lindex + 1][i + 1] = node1;
                levels[lindex + 1][i] = node2;
            }
            for (k = levels.length - 2; k >= 0; --k) {
                this.phaseIU(k, levels);
            }
            if (this.crossings(tempLevels) >= this.crossings(levels)) continue;
            this.copy2DArray(tempLevels, levels);
        }
    }

    public void phaseIIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        for (int i = 0; i < rowBC.length - 1; ++i) {
            int k;
            if (rowBC[i] != rowBC[i + 1]) continue;
            int[][] tempLevels = new int[levels.length][];
            this.copy2DArray(levels, tempLevels);
            int node1 = levels[lindex][i];
            int node2 = levels[lindex][i + 1];
            levels[lindex][i + 1] = node1;
            levels[lindex][i] = node2;
            for (k = lindex - 1; k >= 0; --k) {
                this.phaseIU(k, levels);
            }
            if (this.crossings(levels) <= this.crossings(tempLevels)) {
                this.copy2DArray(levels, tempLevels);
            } else {
                this.copy2DArray(tempLevels, levels);
                levels[lindex][i + 1] = node1;
                levels[lindex][i] = node2;
            }
            for (k = 0; k < levels.length - 1; ++k) {
                this.phaseID(k, levels);
            }
            if (this.crossings(tempLevels) > this.crossings(levels)) continue;
            this.copy2DArray(tempLevels, levels);
        }
    }

    protected float[] calcRowBC(int lindex, int[][] levels) {
        float[] rowBC = new float[levels[lindex].length];
        for (int i = 0; i < levels[lindex].length; ++i) {
            int sum = 0;
            GraphNode n = (GraphNode)this.m_nodes.elementAt(levels[lindex][i]);
            for (int j = 0; j < n.edges.length; ++j) {
                if (n.edges[j][1] <= 0) continue;
                ++sum;
                try {
                    rowBC[i] = rowBC[i] + (float)this.indexOfElementInLevel(n.edges[j][0], levels[lindex + 1]) + 1.0f;
                    continue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (rowBC[i] == 0.0f) continue;
            rowBC[i] = rowBC[i] / (float)sum;
        }
        return rowBC;
    }

    protected float[] calcColBC(int lindex, int[][] levels) {
        float[] colBC = new float[levels[lindex + 1].length];
        for (int i = 0; i < levels[lindex + 1].length; ++i) {
            int sum = 0;
            GraphNode n = (GraphNode)this.m_nodes.elementAt(levels[lindex + 1][i]);
            for (int j = 0; j < n.edges.length; ++j) {
                if (n.edges[j][1] >= 1) continue;
                ++sum;
                try {
                    colBC[i] = colBC[i] + (float)this.indexOfElementInLevel(n.edges[j][0], levels[lindex]) + 1.0f;
                    continue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (colBC[i] == 0.0f) continue;
            colBC[i] = colBC[i] / (float)sum;
        }
        return colBC;
    }

    protected void printMatrices(int[][] levels) {
        int i = 0;
        for (i = 0; i < levels.length - 1; ++i) {
            int j;
            float[] rowBC = null;
            float[] colBC = null;
            try {
                rowBC = this.calcRowBC(i, levels);
                colBC = this.calcColBC(i, levels);
            }
            catch (NullPointerException ne) {
                System.out.println("i: " + i + " levels.length: " + levels.length);
                ne.printStackTrace();
                return;
            }
            System.out.print("\nM" + (i + 1) + "\t");
            for (j = 0; j < levels[i + 1].length; ++j) {
                System.out.print(((GraphNode)this.m_nodes.elementAt((int)levels[i + 1][j])).ID + " ");
            }
            System.out.println("");
            for (j = 0; j < levels[i].length; ++j) {
                System.out.print(((GraphNode)this.m_nodes.elementAt((int)levels[i][j])).ID + "\t");
                for (int k = 0; k < levels[i + 1].length; ++k) {
                    System.out.print(this.graphMatrix[levels[i][j]][levels[i + 1][k]] + " ");
                }
                System.out.println(rowBC[j]);
            }
            System.out.print("\t");
            for (int k = 0; k < levels[i + 1].length; ++k) {
                System.out.print(colBC[k] + " ");
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_PrintMatrices_Text_Second")).append(i);
        Messages.getInstance();
        System.out.println(stringBuilder2.append(Messages.getString("HierarchicalBCEngine_PrintMatrices_Text_First")).append(levels.length).toString());
    }

    protected static void isort(int[] level, float[] BC) {
        for (int i = 0; i < BC.length - 1; ++i) {
            int j = i;
            float temp = BC[j + 1];
            int temp2 = level[j + 1];
            if (temp == 0.0f) continue;
            int prej = j + 1;
            while (j > -1 && (temp < BC[j] || BC[j] == 0.0f)) {
                if (BC[j] == 0.0f) {
                    --j;
                    continue;
                }
                BC[prej] = BC[j];
                level[prej] = level[j];
                prej = j--;
            }
            BC[prej] = temp;
            level[prej] = temp2;
        }
    }

    protected void copyMatrix(int[][] from, int[][] to) {
        for (int i = 0; i < from.length; ++i) {
            for (int j = 0; j < from[i].length; ++j) {
                to[i][j] = from[i][j];
            }
        }
    }

    protected void copy2DArray(int[][] from, int[][] to) {
        for (int i = 0; i < from.length; ++i) {
            to[i] = new int[from[i].length];
            System.arraycopy(from[i], 0, to[i], 0, from[i].length);
        }
    }

    protected void naiveLayout() {
        if (this.nodeLevels == null) {
            this.makeProperHierarchy();
        }
        int temp = 0;
        for (int i = 0; i < this.nodeLevels.length; ++i) {
            for (int j = 0; j < this.nodeLevels[i].length; ++j) {
                temp = this.nodeLevels[i][j];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = j * this.m_nodeWidth;
                n.y = i * 3 * this.m_nodeHeight;
            }
        }
    }

    protected int uConnectivity(int lindex, int eindex) {
        int n = 0;
        for (int i = 0; i < this.nodeLevels[lindex - 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i]][this.nodeLevels[lindex][eindex]] <= 0) continue;
            ++n;
        }
        return n;
    }

    protected int lConnectivity(int lindex, int eindex) {
        int n = 0;
        for (int i = 0; i < this.nodeLevels[lindex + 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i]] <= 0) continue;
            ++n;
        }
        return n;
    }

    protected int uBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        for (int i = 0; i < this.nodeLevels[lindex - 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i]][this.nodeLevels[lindex][eindex]] <= 0) continue;
            sum += horPositions[this.nodeLevels[lindex - 1][i]];
        }
        if (sum != 0) {
            sum /= this.uConnectivity(lindex, eindex);
        }
        return sum;
    }

    protected int lBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        for (int i = 0; i < this.nodeLevels[lindex + 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i]] <= 0) continue;
            sum += horPositions[this.nodeLevels[lindex + 1][i]];
        }
        if (sum != 0) {
            sum /= this.lConnectivity(lindex, eindex);
        }
        return sum;
    }

    private void tempMethod(int[] horPositions) {
        int i;
        int minPosition = horPositions[0];
        for (i = 0; i < horPositions.length; ++i) {
            if (horPositions[i] >= minPosition) continue;
            minPosition = horPositions[i];
        }
        if (minPosition < 0) {
            minPosition *= -1;
            i = 0;
            while (i < horPositions.length) {
                int n = i++;
                horPositions[n] = horPositions[n] + minPosition;
            }
        }
        int temp = 0;
        for (i = 0; i < this.nodeLevels.length; ++i) {
            for (int j = 0; j < this.nodeLevels[i].length; ++j) {
                temp = this.nodeLevels[i][j];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = horPositions[temp] * this.m_nodeWidth;
                n.y = i * 3 * this.m_nodeHeight;
            }
        }
    }

    protected void priorityLayout1() {
        int i;
        int j;
        int i2;
        int[] horPositions = new int[this.m_nodes.size()];
        int maxCount = 0;
        for (int i3 = 0; i3 < this.nodeLevels.length; ++i3) {
            int count = 0;
            for (int j2 = 0; j2 < this.nodeLevels[i3].length; ++j2) {
                horPositions[this.nodeLevels[i3][j2]] = j2;
                ++count;
            }
            if (count <= maxCount) continue;
            maxCount = count;
        }
        for (i2 = 1; i2 < this.nodeLevels.length; ++i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        for (i2 = this.nodeLevels.length - 2; i2 >= 0; --i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.lConnectivity(i2, j);
                BC[j] = this.lBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        for (i2 = 2; i2 < this.nodeLevels.length; ++i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        int minPosition = horPositions[0];
        for (i = 0; i < horPositions.length; ++i) {
            if (horPositions[i] >= minPosition) continue;
            minPosition = horPositions[i];
        }
        if (minPosition < 0) {
            minPosition *= -1;
            i = 0;
            while (i < horPositions.length) {
                int n = i++;
                horPositions[n] = horPositions[n] + minPosition;
            }
        }
        int temp = 0;
        for (i = 0; i < this.nodeLevels.length; ++i) {
            for (int j3 = 0; j3 < this.nodeLevels[i].length; ++j3) {
                temp = this.nodeLevels[i][j3];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = horPositions[temp] * this.m_nodeWidth;
                n.y = i * 3 * this.m_nodeHeight;
            }
        }
    }

    private void priorityLayout2(int[] level, int[] priorities, int[] bCenters, int[] horPositions) {
        int[] descOrder = new int[priorities.length];
        descOrder[0] = 0;
        for (int i = 0; i < priorities.length - 1; ++i) {
            int temp = i + 1;
            for (int j = i; j > -1 && priorities[descOrder[j]] < priorities[temp]; --j) {
                descOrder[j + 1] = descOrder[j];
            }
            descOrder[++j] = temp;
        }
        for (int k = 0; k < descOrder.length; ++k) {
            block3: for (int i = 0; i < descOrder.length; ++i) {
                int j;
                boolean cantMove;
                int temp;
                int j2;
                int leftCount = 0;
                int rightCount = 0;
                for (j2 = 0; j2 < priorities.length; ++j2) {
                    if (horPositions[level[descOrder[i]]] > horPositions[level[j2]]) {
                        ++leftCount;
                        continue;
                    }
                    if (horPositions[level[descOrder[i]]] >= horPositions[level[j2]]) continue;
                    ++rightCount;
                }
                int[] leftNodes = new int[leftCount];
                int[] rightNodes = new int[rightCount];
                int l = 0;
                int r = 0;
                for (j2 = 0; j2 < priorities.length; ++j2) {
                    if (horPositions[level[descOrder[i]]] > horPositions[level[j2]]) {
                        leftNodes[l++] = j2;
                        continue;
                    }
                    if (horPositions[level[descOrder[i]]] >= horPositions[level[j2]]) continue;
                    rightNodes[r++] = j2;
                }
                while (Math.abs(horPositions[level[descOrder[i]]] - 1 - bCenters[descOrder[i]]) < Math.abs(horPositions[level[descOrder[i]]] - bCenters[descOrder[i]])) {
                    temp = horPositions[level[descOrder[i]]];
                    cantMove = false;
                    for (j = leftNodes.length - 1; j >= 0 && temp - horPositions[level[leftNodes[j]]] <= 1; --j) {
                        if (priorities[descOrder[i]] <= priorities[leftNodes[j]]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[leftNodes[j]]];
                    }
                    if (cantMove) break;
                    temp = horPositions[level[descOrder[i]]] - 1;
                    for (j = leftNodes.length - 1; j >= 0; --j) {
                        if (temp != horPositions[level[leftNodes[j]]]) continue;
                        horPositions[level[leftNodes[j]]] = temp = horPositions[level[leftNodes[j]]] - 1;
                    }
                    horPositions[level[descOrder[i]]] = horPositions[level[descOrder[i]]] - 1;
                }
                while (Math.abs(horPositions[level[descOrder[i]]] + 1 - bCenters[descOrder[i]]) < Math.abs(horPositions[level[descOrder[i]]] - bCenters[descOrder[i]])) {
                    temp = horPositions[level[descOrder[i]]];
                    cantMove = false;
                    for (j = 0; j < rightNodes.length && horPositions[level[rightNodes[j]]] - temp <= 1; ++j) {
                        if (priorities[descOrder[i]] <= priorities[rightNodes[j]]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[rightNodes[j]]];
                    }
                    if (cantMove) continue block3;
                    temp = horPositions[level[descOrder[i]]] + 1;
                    for (j = 0; j < rightNodes.length; ++j) {
                        if (temp != horPositions[level[rightNodes[j]]]) continue;
                        horPositions[level[rightNodes[j]]] = temp = horPositions[level[rightNodes[j]]] + 1;
                    }
                    horPositions[level[descOrder[i]]] = horPositions[level[descOrder[i]]] + 1;
                }
            }
        }
    }

    private class MyListNode {
        int n;
        MyListNode next;
        MyListNode previous;

        public MyListNode(int i) {
            this.n = i;
            this.next = null;
            this.previous = null;
        }
    }

    private class MyList {
        int size;
        MyListNode first = null;
        MyListNode last = null;

        private MyList() {
        }

        public void add(int i) {
            if (this.first == null) {
                this.first = this.last = new MyListNode(i);
            } else if (this.last.next == null) {
                this.last.next = new MyListNode(i);
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("HierarchicalBCEngine_MyList_Add_Error_Text_First"));
                --this.size;
            }
            ++this.size;
        }

        public void add(MyListNode n) {
            if (this.first == null) {
                this.first = this.last = n;
            } else if (this.last.next == null) {
                this.last.next = n;
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("HierarchicalBCEngine_MyList_Add_Error_Text_Second"));
                --this.size;
            }
            ++this.size;
        }

        public void remove(MyListNode n) {
            if (n.previous != null) {
                n.previous.next = n.next;
            }
            if (n.next != null) {
                n.next.previous = n.previous;
            }
            if (this.last == n) {
                this.last = n.previous;
            }
            if (this.first == n) {
                this.first = n.next;
            }
            --this.size;
        }

        public void remove(int i) {
            MyListNode temp = this.first;
            while (temp != null && temp.n != i) {
                temp = temp.next;
            }
            if (temp == null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_MyList_Remove_Error_Text_First")).append(i);
                Messages.getInstance();
                System.err.println(stringBuilder2.append(Messages.getString("HierarchicalBCEngine_MyList_Remove_Error_Text_Second")).toString());
                return;
            }
            if (temp.previous != null) {
                temp.previous.next = temp.next;
            }
            if (temp.next != null) {
                temp.next.previous = temp.previous;
            }
            if (this.last == temp) {
                this.last = temp.previous;
            }
            if (this.first == temp) {
                this.first = temp.next;
            }
            --this.size;
        }

        public int size() {
            return this.size;
        }
    }
}

