/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.FloatStack;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.geom.Frustum;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GLException;
import javax.media.opengl.fixedfunc.GLMatrixFunc;
import jogamp.opengl.ProjectFloat;

public class PMVMatrix
implements GLMatrixFunc {
    public static final int MODIFIED_PROJECTION = 1;
    public static final int MODIFIED_MODELVIEW = 2;
    public static final int MODIFIED_TEXTURE = 4;
    public static final int MODIFIED_ALL = 7;
    public static final int DIRTY_INVERSE_MODELVIEW = 1;
    public static final int DIRTY_INVERSE_TRANSPOSED_MODELVIEW = 2;
    public static final int DIRTY_FRUSTUM = 4;
    public static final int DIRTY_ALL = 7;
    private int nioBackupArraySupported = 0;
    private final String msgCantComputeInverse = "Invalid source Mv matrix, can't compute inverse";
    protected final float[] matrixBufferArray;
    protected final boolean usesBackingArray;
    protected Buffer matrixBuffer;
    protected FloatBuffer matrixIdent;
    protected FloatBuffer matrixPMvMvit;
    protected FloatBuffer matrixPMvMvi;
    protected FloatBuffer matrixPMv;
    protected FloatBuffer matrixP;
    protected FloatBuffer matrixTex;
    protected FloatBuffer matrixMv;
    protected FloatBuffer matrixMvi;
    protected FloatBuffer matrixMvit;
    protected float[] matrixMult;
    protected float[] matrixTrans;
    protected float[] matrixRot;
    protected float[] matrixScale;
    protected float[] matrixOrtho;
    protected float[] matrixFrustum;
    protected float[] vec3f;
    protected FloatStack matrixTStack;
    protected FloatStack matrixPStack;
    protected FloatStack matrixMvStack;
    protected int matrixMode = 5888;
    protected int modifiedBits = 7;
    protected int dirtyBits = 7;
    protected int requestMask = 0;
    protected ProjectFloat projectFloat;
    protected float[] mulPMV;
    protected Frustum frustum;

    public static final boolean isMatrixModeName(int n) {
        switch (n) {
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixModeName2MatrixGetName(int n) {
        switch (n) {
            case 5888: {
                return 2982;
            }
            case 5889: {
                return 2983;
            }
            case 5890: {
                return 2984;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public static final boolean isMatrixGetName(int n) {
        switch (n) {
            case 2976: 
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixGetName2MatrixModeName(int n) {
        switch (n) {
            case 2982: {
                return 5888;
            }
            case 2983: {
                return 5889;
            }
            case 2984: {
                return 5890;
            }
        }
        throw new GLException("unsupported matrixGetName: " + n);
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, FloatBuffer floatBuffer) {
        return FloatUtil.matrixToString(stringBuilder, null, string, floatBuffer, 0, 4, 4, false);
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        return FloatUtil.matrixToString(stringBuilder, null, string, floatBuffer, 0, floatBuffer2, 0, 4, 4, false);
    }

    public PMVMatrix() {
        this(true);
    }

    public PMVMatrix(boolean bl) {
        this.usesBackingArray = bl;
        if (bl) {
            this.matrixBufferArray = new float[96 + ProjectFloat.getRequiredFloatBufferSize()];
            this.matrixBuffer = null;
        } else {
            this.matrixBufferArray = null;
            this.matrixBuffer = Buffers.newDirectByteBuffer((96 + ProjectFloat.getRequiredFloatBufferSize()) * 4);
            this.matrixBuffer.mark();
        }
        this.matrixIdent = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 0, 16);
        this.matrixTex = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 16, 16);
        this.matrixPMvMvit = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 64);
        this.matrixPMvMvi = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 48);
        this.matrixPMv = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 32);
        this.matrixP = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 16);
        this.matrixMv = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 48, 16);
        this.matrixMvi = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 64, 16);
        this.matrixMvit = Buffers.slice2Float(this.matrixBuffer, this.matrixBufferArray, 80, 16);
        this.projectFloat = new ProjectFloat(this.matrixBuffer, this.matrixBufferArray, 96);
        if (null != this.matrixBuffer) {
            this.matrixBuffer.reset();
        }
        FloatUtil.makeIdentityf(this.matrixIdent);
        this.vec3f = new float[3];
        this.matrixMult = new float[16];
        this.matrixTrans = new float[16];
        this.matrixRot = new float[16];
        this.matrixScale = new float[16];
        this.matrixOrtho = new float[16];
        this.matrixFrustum = new float[16];
        FloatUtil.makeIdentityf(this.matrixTrans, 0);
        FloatUtil.makeIdentityf(this.matrixRot, 0);
        FloatUtil.makeIdentityf(this.matrixScale, 0);
        FloatUtil.makeIdentityf(this.matrixOrtho, 0);
        FloatUtil.makeZero(this.matrixFrustum, 0);
        this.matrixTStack = new FloatStack(0, 32);
        this.matrixPStack = new FloatStack(0, 32);
        this.matrixMvStack = new FloatStack(0, 256);
        this.glMatrixMode(5889);
        this.glLoadIdentity();
        this.glMatrixMode(5888);
        this.glLoadIdentity();
        this.glMatrixMode(5890);
        this.glLoadIdentity();
        this.modifiedBits = 7;
        this.dirtyBits = 7;
        this.requestMask = 0;
        this.matrixMode = 5888;
        this.mulPMV = null;
        this.frustum = null;
    }

    public final boolean usesBackingArray() {
        return this.usesBackingArray;
    }

    public final void destroy() {
        if (null != this.projectFloat) {
            this.projectFloat.destroy();
            this.projectFloat = null;
        }
        this.matrixBuffer = null;
        this.matrixBuffer = null;
        this.matrixPMvMvit = null;
        this.matrixPMvMvi = null;
        this.matrixPMv = null;
        this.matrixP = null;
        this.matrixTex = null;
        this.matrixMv = null;
        this.matrixMvi = null;
        this.matrixMvit = null;
        this.vec3f = null;
        this.matrixMult = null;
        this.matrixTrans = null;
        this.matrixRot = null;
        this.matrixScale = null;
        this.matrixOrtho = null;
        this.matrixFrustum = null;
        if (null != this.matrixPStack) {
            this.matrixPStack = null;
        }
        if (null != this.matrixMvStack) {
            this.matrixMvStack = null;
        }
        if (null != this.matrixPStack) {
            this.matrixPStack = null;
        }
        if (null != this.matrixTStack) {
            this.matrixTStack = null;
        }
    }

    public final int glGetMatrixMode() {
        return this.matrixMode;
    }

    public final FloatBuffer glGetTMatrixf() {
        return this.matrixTex;
    }

    public final FloatBuffer glGetPMatrixf() {
        return this.matrixP;
    }

    public final FloatBuffer glGetMvMatrixf() {
        return this.matrixMv;
    }

    public final FloatBuffer glGetMviMatrixf() {
        this.requestMask |= 1;
        this.updateImpl(false);
        return this.matrixMvi;
    }

    public final FloatBuffer glGetMvitMatrixf() {
        this.requestMask |= 2;
        this.updateImpl(false);
        return this.matrixMvit;
    }

    public final FloatBuffer glGetPMvMatrixf() {
        return this.matrixPMv;
    }

    public final FloatBuffer glGetPMvMviMatrixf() {
        this.requestMask |= 1;
        this.updateImpl(false);
        return this.matrixPMvMvi;
    }

    public final FloatBuffer glGetPMvMvitMatrixf() {
        this.requestMask |= 3;
        this.updateImpl(false);
        return this.matrixPMvMvit;
    }

    public Frustum glGetFrustum() {
        this.requestMask |= 4;
        this.updateImpl(false);
        return this.frustum;
    }

    public final FloatBuffer glGetMatrixf() {
        return this.glGetMatrixf(this.matrixMode);
    }

    public final FloatBuffer glGetMatrixf(int n) {
        switch (n) {
            case 2982: 
            case 5888: {
                return this.matrixMv;
            }
            case 2983: 
            case 5889: {
                return this.matrixP;
            }
            case 2984: 
            case 5890: {
                return this.matrixTex;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    @Override
    public final void glMatrixMode(int n) {
        switch (n) {
            case 5888: 
            case 5889: 
            case 5890: {
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        this.matrixMode = n;
    }

    @Override
    public final void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        if (n == 2976) {
            floatBuffer.put(this.matrixMode);
        } else {
            FloatBuffer floatBuffer2 = this.glGetMatrixf(n);
            floatBuffer.put(floatBuffer2);
            floatBuffer2.reset();
        }
        floatBuffer.position(n2);
    }

    @Override
    public final void glGetFloatv(int n, float[] fArray, int n2) {
        if (n == 2976) {
            fArray[n2] = this.matrixMode;
        } else {
            FloatBuffer floatBuffer = this.glGetMatrixf(n);
            floatBuffer.get(fArray, n2, 16);
            floatBuffer.reset();
        }
    }

    @Override
    public final void glGetIntegerv(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        intBuffer.put(this.matrixMode);
        intBuffer.position(n2);
    }

    @Override
    public final void glGetIntegerv(int n, int[] nArray, int n2) {
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        nArray[n2] = this.matrixMode;
    }

    @Override
    public final void glLoadMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.matrixMv.put(fArray, n, 16);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(fArray, n, 16);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(fArray, n, 16);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.matrixMv.put(floatBuffer);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(floatBuffer);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(floatBuffer);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
        floatBuffer.position(n);
    }

    @Override
    public final void glPopMatrix() {
        FloatStack floatStack;
        if (this.matrixMode == 5888) {
            floatStack = this.matrixMvStack;
        } else if (this.matrixMode == 5889) {
            floatStack = this.matrixPStack;
        } else if (this.matrixMode == 5890) {
            floatStack = this.matrixTStack;
        } else {
            throw new InternalError("XXX: mode " + this.matrixMode);
        }
        floatStack.position(floatStack.position() - 16);
        this.glLoadMatrixf(floatStack.buffer(), floatStack.position());
    }

    @Override
    public final void glPushMatrix() {
        if (this.matrixMode == 5888) {
            this.matrixMvStack.putOnTop(this.matrixMv, 16);
            this.matrixMv.reset();
        } else if (this.matrixMode == 5889) {
            this.matrixPStack.putOnTop(this.matrixP, 16);
            this.matrixP.reset();
        } else if (this.matrixMode == 5890) {
            this.matrixTStack.putOnTop(this.matrixTex, 16);
            this.matrixTex.reset();
        }
    }

    @Override
    public final void glLoadIdentity() {
        if (this.matrixMode == 5888) {
            this.matrixMv.put(this.matrixIdent);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(this.matrixIdent);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(this.matrixIdent);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
        this.matrixIdent.reset();
    }

    @Override
    public final void glMultMatrixf(FloatBuffer floatBuffer) {
        if (this.matrixMode == 5888) {
            FloatUtil.multMatrixf(this.matrixMv, floatBuffer);
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            FloatUtil.multMatrixf(this.matrixP, floatBuffer);
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            FloatUtil.multMatrixf(this.matrixTex, floatBuffer);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glMultMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            FloatUtil.multMatrixf(this.matrixMv, fArray, n);
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            FloatUtil.multMatrixf(this.matrixP, fArray, n);
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            FloatUtil.multMatrixf(this.matrixTex, fArray, n);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glTranslatef(float f, float f2, float f3) {
        this.matrixTrans[12] = f;
        this.matrixTrans[13] = f2;
        this.matrixTrans[14] = f3;
        this.glMultMatrixf(this.matrixTrans, 0);
    }

    @Override
    public final void glRotatef(float f, float f2, float f3, float f4) {
        float f5 = f * (float)Math.PI / 180.0f;
        float f6 = (float)Math.cos(f5);
        float f7 = 1.0f - f6;
        float f8 = (float)Math.sin(f5);
        this.vec3f[0] = f2;
        this.vec3f[1] = f3;
        this.vec3f[2] = f4;
        FloatUtil.normalize(this.vec3f);
        f2 = this.vec3f[0];
        f3 = this.vec3f[1];
        f4 = this.vec3f[2];
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f2 * f8;
        float f12 = f3 * f8;
        float f13 = f3 * f4;
        float f14 = f4 * f8;
        this.matrixRot[0] = f2 * f2 * f7 + f6;
        this.matrixRot[1] = f9 * f7 + f14;
        this.matrixRot[2] = f10 * f7 - f12;
        this.matrixRot[4] = f9 * f7 - f14;
        this.matrixRot[5] = f3 * f3 * f7 + f6;
        this.matrixRot[6] = f13 * f7 + f11;
        this.matrixRot[8] = f10 * f7 + f12;
        this.matrixRot[9] = f13 * f7 - f11;
        this.matrixRot[10] = f4 * f4 * f7 + f6;
        this.glMultMatrixf(this.matrixRot, 0);
    }

    @Override
    public final void glScalef(float f, float f2, float f3) {
        this.matrixScale[0] = f;
        this.matrixScale[5] = f2;
        this.matrixScale[10] = f3;
        this.glMultMatrixf(this.matrixScale, 0);
    }

    @Override
    public final void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        float f10 = -1.0f * (f2 + f) / f7;
        float f11 = -1.0f * (f4 + f3) / f8;
        float f12 = -1.0f * (f6 + f5) / f9;
        this.matrixOrtho[0] = 2.0f / f7;
        this.matrixOrtho[5] = 2.0f / f8;
        this.matrixOrtho[10] = -2.0f / f9;
        this.matrixOrtho[12] = f10;
        this.matrixOrtho[13] = f11;
        this.matrixOrtho[14] = f12;
        this.glMultMatrixf(this.matrixOrtho, 0);
    }

    @Override
    public final void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f5 <= 0.0f || f6 < 0.0f) {
            throw new GLException("GL_INVALID_VALUE: zNear and zFar must be positive, and zNear>0");
        }
        if (f == f2 || f4 == f3) {
            throw new GLException("GL_INVALID_VALUE: top,bottom and left,right must not be equal");
        }
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        float f11 = (f2 + f) / f8;
        float f12 = (f4 + f3) / f9;
        float f13 = -1.0f * (f6 + f5) / f10;
        float f14 = -2.0f * (f6 * f5) / f10;
        this.matrixFrustum[0] = f7 / f8;
        this.matrixFrustum[5] = f7 / f9;
        this.matrixFrustum[10] = f13;
        this.matrixFrustum[8] = f11;
        this.matrixFrustum[9] = f12;
        this.matrixFrustum[14] = f14;
        this.matrixFrustum[11] = -1.0f;
        this.glMultMatrixf(this.matrixFrustum, 0);
    }

    public final void gluPerspective(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.tan(f * (float)Math.PI / 360.0f) * f3;
        float f6 = -1.0f * f5;
        float f7 = f2 * f6;
        float f8 = f2 * f5;
        this.glFrustumf(f7, f8, f6, f5, f3, f4);
    }

    public final void gluLookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.projectFloat.gluLookAt(this, f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public final boolean gluProject(float f, float f2, float f3, int[] nArray, int n, float[] fArray, int n2) {
        if (this.usesBackingArray) {
            return this.projectFloat.gluProject(f, f2, f3, this.matrixMv.array(), this.matrixMv.position(), this.matrixP.array(), this.matrixP.position(), nArray, n, fArray, n2);
        }
        return this.projectFloat.gluProject(f, f2, f3, this.matrixMv, this.matrixP, nArray, n, fArray, n2);
    }

    public final boolean gluUnProject(float f, float f2, float f3, int[] nArray, int n, float[] fArray, int n2) {
        if (this.usesBackingArray) {
            return this.projectFloat.gluUnProject(f, f2, f3, this.matrixMv.array(), this.matrixMv.position(), this.matrixP.array(), this.matrixP.position(), nArray, n, fArray, n2);
        }
        return this.projectFloat.gluUnProject(f, f2, f3, this.matrixMv, this.matrixP, nArray, n, fArray, n2);
    }

    public final void gluPickMatrix(float f, float f2, float f3, float f4, int[] nArray, int n) {
        this.projectFloat.gluPickMatrix(this, f, f2, f3, f4, nArray, n);
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = 0 != (1 & this.dirtyBits);
        boolean bl2 = 0 != (2 & this.dirtyBits);
        boolean bl3 = 0 != (4 & this.dirtyBits);
        boolean bl4 = 0 != (1 & this.requestMask);
        boolean bl5 = 0 != (2 & this.requestMask);
        boolean bl6 = 0 != (4 & this.requestMask);
        boolean bl7 = 0 != (1 & this.modifiedBits);
        boolean bl8 = 0 != (2 & this.modifiedBits);
        boolean bl9 = 0 != (4 & this.modifiedBits);
        stringBuilder.append("PMVMatrix[backingArray ").append(this.usesBackingArray());
        stringBuilder.append(", modified[P ").append(bl7).append(", Mv ").append(bl8).append(", T ").append(bl9);
        stringBuilder.append("], dirty/req[Mvi ").append(bl).append("/").append(bl4).append(", Mvit ").append(bl2).append("/").append(bl5).append(", Frustum ").append(bl3).append("/").append(bl6);
        stringBuilder.append("], Projection").append(Platform.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string, this.matrixP);
        stringBuilder.append(", Modelview").append(Platform.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string, this.matrixMv);
        stringBuilder.append(", Texture").append(Platform.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string, this.matrixTex);
        if (0 != (this.requestMask & 1)) {
            stringBuilder.append(", Inverse Modelview").append(Platform.NEWLINE);
            PMVMatrix.matrixToString(stringBuilder, string, this.matrixMvi);
        }
        if (0 != (this.requestMask & 2)) {
            stringBuilder.append(", Inverse Transposed Modelview").append(Platform.NEWLINE);
            PMVMatrix.matrixToString(stringBuilder, string, this.matrixMvit);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null, "%10.5f").toString();
    }

    public final int getModifiedBits(boolean bl) {
        int n = this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        return n;
    }

    public final int getDirtyBits() {
        return this.dirtyBits;
    }

    public final int getRequestMask() {
        return this.requestMask;
    }

    public final void clearAllUpdateRequests() {
        this.requestMask &= 0xFFFFFFF8;
    }

    public final boolean update() {
        return this.updateImpl(true);
    }

    private final boolean updateImpl(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        if (0 != (this.dirtyBits & (4 & this.requestMask))) {
            if (null == this.frustum) {
                this.frustum = new Frustum();
                this.mulPMV = new float[16];
            }
            FloatUtil.multMatrixf(this.matrixP, this.matrixMv, this.mulPMV, 0);
            this.frustum.updateByPMV(this.mulPMV, 0);
            this.dirtyBits &= 0xFFFFFFFB;
            bl2 = true;
        }
        if (0 == (this.dirtyBits & this.requestMask)) {
            return bl2;
        }
        if (this.nioBackupArraySupported >= 0) {
            try {
                this.nioBackupArraySupported = 1;
                return this.setMviMvitNIOBackupArray() || bl2;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.nioBackupArraySupported = -1;
            }
        }
        return this.setMviMvitNIODirectAccess() || bl2;
    }

    private final boolean setMviMvitNIOBackupArray() {
        float[] fArray = this.matrixMvi.array();
        int n = this.matrixMvi.position();
        boolean bl = false;
        if (0 != (this.dirtyBits & 1)) {
            if (!this.projectFloat.gluInvertMatrixf(this.matrixMv.array(), this.matrixMv.position(), fArray, n)) {
                throw new GLException("Invalid source Mv matrix, can't compute inverse");
            }
            this.dirtyBits &= 0xFFFFFFFE;
            bl = true;
        }
        if (0 != (this.requestMask & (this.dirtyBits & 2))) {
            float[] fArray2 = this.matrixMvit.array();
            int n2 = this.matrixMvit.position();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    fArray2[n2 + j + i * 4] = fArray[n + i + j * 4];
                }
            }
            this.dirtyBits &= 0xFFFFFFFD;
            bl = true;
        }
        return bl;
    }

    private final boolean setMviMvitNIODirectAccess() {
        boolean bl = false;
        if (0 != (this.dirtyBits & 1)) {
            if (!this.projectFloat.gluInvertMatrixf(this.matrixMv, this.matrixMvi)) {
                throw new GLException("Invalid source Mv matrix, can't compute inverse");
            }
            this.dirtyBits &= 0xFFFFFFFE;
            bl = true;
        }
        if (0 != (this.requestMask & (this.dirtyBits & 2))) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrixMvit.put(j + i * 4, this.matrixMvi.get(i + j * 4));
                }
            }
            this.dirtyBits &= 0xFFFFFFFD;
            bl = true;
        }
        return bl;
    }
}

