/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.TGAWriter;
import com.jogamp.opengl.util.awt.ImageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class Screenshot {
    private Screenshot() {
    }

    public static void writeToTargaFile(File file, int n, int n2) throws GLException, IOException {
        Screenshot.writeToTargaFile(file, n, n2, false);
    }

    public static void writeToTargaFile(File file, int n, int n2, boolean bl) throws GLException, IOException {
        Screenshot.writeToTargaFile(file, 0, 0, n, n2, bl);
    }

    public static void writeToTargaFile(File file, int n, int n2, int n3, int n4, boolean bl) throws GLException, IOException {
        if (bl) {
            Screenshot.checkExtABGR();
        }
        TGAWriter tGAWriter = new TGAWriter();
        tGAWriter.open(file, n3, n4, bl);
        ByteBuffer byteBuffer = tGAWriter.getImageData();
        GL gL = GLContext.getCurrentGL();
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
        gLPixelStorageModes.setPackAlignment(gL, 1);
        int n5 = bl ? 32768 : 32992;
        gL.glReadPixels(n, n2, n3, n4, n5, 5121, byteBuffer);
        gLPixelStorageModes.restore(gL);
        tGAWriter.close();
    }

    public static BufferedImage readToBufferedImage(int n, int n2) throws GLException {
        return Screenshot.readToBufferedImage(n, n2, false);
    }

    public static BufferedImage readToBufferedImage(int n, int n2, boolean bl) throws GLException {
        return Screenshot.readToBufferedImage(0, 0, n, n2, bl);
    }

    public static BufferedImage readToBufferedImage(int n, int n2, int n3, int n4, boolean bl) throws GLException {
        int n5;
        int n6 = bl ? 6 : 5;
        int n7 = n5 = bl ? 32768 : 32992;
        if (bl) {
            Screenshot.checkExtABGR();
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        GLContext gLContext = GLContext.getCurrent();
        GL gL = gLContext.getGL();
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
        gLPixelStorageModes.setPackAlignment(gL, 1);
        gL.glReadPixels(n, n2, n3, n4, n5, 5121, ByteBuffer.wrap(((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData()));
        gLPixelStorageModes.restore(gL);
        if (gLContext.getGLDrawable().isGLOriented()) {
            ImageUtil.flipImageVertically(bufferedImage);
        }
        return bufferedImage;
    }

    public static void writeToFile(File file, int n, int n2) throws IOException, GLException {
        Screenshot.writeToFile(file, n, n2, false);
    }

    public static void writeToFile(File file, int n, int n2, boolean bl) throws IOException, GLException {
        Screenshot.writeToFile(file, 0, 0, n, n2, bl);
    }

    public static void writeToFile(File file, int n, int n2, int n3, int n4, boolean bl) throws IOException, GLException {
        BufferedImage bufferedImage;
        String string = IOUtil.getFileSuffix(file);
        if (bl && (string.equals("jpg") || string.equals("jpeg"))) {
            bl = false;
        }
        if (!ImageIO.write((RenderedImage)(bufferedImage = Screenshot.readToBufferedImage(n, n2, n3, n4, bl)), string, file)) {
            throw new IOException("Unsupported file format " + string);
        }
    }

    private static void checkExtABGR() {
        GL gL = GLContext.getCurrentGL();
        if (!gL.isExtensionAvailable("GL_EXT_abgr")) {
            throw new IllegalArgumentException("Saving alpha channel requires GL_EXT_abgr");
        }
    }
}

