/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki;

import de.lmu.ifi.dbs.elki.application.KDDCLIApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import de.lmu.ifi.dbs.elki.workflow.EvaluationStep;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.util.Collection;

public class KDDTask {
    private Collection<TrackedParameter> settings;
    private InputStep inputStep;
    private AlgorithmStep algorithmStep;
    private EvaluationStep evaluationStep;
    private OutputStep outputStep;
    private ResultHierarchy hier;

    public KDDTask(InputStep inputStep, AlgorithmStep algorithmStep, EvaluationStep evaluationStep, OutputStep outputStep, Collection<TrackedParameter> settings) {
        this.inputStep = inputStep;
        this.algorithmStep = algorithmStep;
        this.evaluationStep = evaluationStep;
        this.outputStep = outputStep;
        this.settings = settings;
    }

    public void run() {
        Database db = this.inputStep.getDatabase();
        this.hier = db.getHierarchy();
        this.algorithmStep.runAlgorithms(db);
        this.hier.add(db, new SettingsResult(this.settings));
        this.evaluationStep.runEvaluators(this.hier, db);
        this.outputStep.runResultHandlers(this.hier, db);
    }

    public ResultHierarchy getResultHierarchy() {
        return this.hier;
    }

    public static void main(String[] args) {
        KDDCLIApplication.runCLIApplication(KDDCLIApplication.class, args);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        InputStep inputStep = null;
        AlgorithmStep algorithmStep = null;
        EvaluationStep evaluationStep = null;
        Collection<TrackedParameter> settings = null;
        OutputStep outputStep = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            TrackParameters track = new TrackParameters(config);
            this.inputStep = track.tryInstantiate(InputStep.class);
            this.algorithmStep = track.tryInstantiate(AlgorithmStep.class);
            this.evaluationStep = track.tryInstantiate(EvaluationStep.class);
            this.settings = track.getAllParameters();
            this.outputStep = config.tryInstantiate(OutputStep.class);
        }

        @Override
        protected KDDTask makeInstance() {
            return new KDDTask(this.inputStep, this.algorithmStep, this.evaluationStep, this.outputStep, this.settings);
        }
    }
}

