/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.exceptions.APIViolationException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractAlgorithm<R extends Result>
implements Algorithm {
    public static final OptionID ALGORITHM_ID = new OptionID("algorithm", "Algorithm to run.");

    protected AbstractAlgorithm() {
    }

    public R run(Database database) {
        TypeInformation[] inputs = this.getInputTypeRestriction();
        Object[] relations1 = new Object[inputs.length + 1];
        Class[] signature1 = new Class[inputs.length + 1];
        Object[] relations2 = new Object[inputs.length];
        Class[] signature2 = new Class[inputs.length];
        relations1[0] = database;
        signature1[0] = Database.class;
        for (int i = 0; i < inputs.length; ++i) {
            relations1[i + 1] = database.getRelation(inputs[i], new Object[0]);
            signature1[i + 1] = Relation.class;
            relations2[i] = database.getRelation(inputs[i], new Object[0]);
            signature2[i] = Relation.class;
        }
        try {
            Method runmethod1 = this.getClass().getMethod("run", signature1);
            return (R)((Result)runmethod1.invoke((Object)this, relations1));
        }
        catch (NoSuchMethodException runmethod1) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new APIViolationException("Invoking the real 'run' method failed.", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new APIViolationException("Invoking the real 'run' method failed: " + cause.toString(), cause);
        }
        try {
            Method runmethod2 = this.getClass().getMethod("run", signature2);
            return (R)((Result)runmethod2.invoke((Object)this, relations2));
        }
        catch (NoSuchMethodException runmethod2) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new APIViolationException("Invoking the real 'run' method failed.", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new APIViolationException("Invoking the real 'run' method failed: " + cause.toString(), cause);
        }
        throw new APIViolationException("No appropriate 'run' method found.");
    }

    @Override
    public abstract TypeInformation[] getInputTypeRestriction();

    protected abstract Logging getLogger();
}

