/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationAnalysisSolution;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.text.NumberFormat;
import java.util.Locale;

@Title(value="Dependency Derivator: Deriving numerical inter-dependencies on data")
@Description(value="Derives an equality-system describing dependencies between attributes in a correlation-cluster")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="Deriving Quantitative Dependencies for Correlation Clusters", booktitle="Proc. 12th Int. Conf. on Knowledge Discovery and Data Mining (KDD '06)", url="https://doi.org/10.1145/1150402.1150408", bibkey="DBLP:conf/kdd/AchtertBKKZ06")
@Priority(value=-5)
public class DependencyDerivator<V extends NumberVector>
extends AbstractNumberVectorDistanceBasedAlgorithm<V, CorrelationAnalysisSolution<V>> {
    private static final Logging LOG = Logging.getLogger(DependencyDerivator.class);
    private final int sampleSize;
    private final PCARunner pca;
    private final EigenPairFilter filter;
    private final NumberFormat nf;
    private final boolean randomsample;

    public DependencyDerivator(NumberVectorDistanceFunction<? super V> distanceFunction, NumberFormat nf, PCARunner pca, EigenPairFilter filter, int sampleSize, boolean randomsample) {
        super(distanceFunction);
        this.nf = nf;
        this.pca = pca;
        this.filter = filter;
        this.sampleSize = sampleSize;
        this.randomsample = randomsample;
    }

    public CorrelationAnalysisSolution<V> run(Database database, Relation<V> relation) {
        DBIDs ids;
        if (LOG.isVerbose()) {
            LOG.verbose("retrieving database objects...");
        }
        Centroid centroid = Centroid.make(relation, relation.getDBIDs());
        NumberVector.Factory<V> factory = RelationUtil.getNumberVectorFactory(relation);
        V centroidDV = factory.newNumberVector(centroid.getArrayRef());
        if (this.sampleSize > 0) {
            if (this.randomsample) {
                ids = DBIDUtil.randomSample(relation.getDBIDs(), this.sampleSize, RandomFactory.DEFAULT);
            } else {
                DistanceQuery<V> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
                KNNList queryResults = database.getKNNQuery(distanceQuery, this.sampleSize).getKNNForObject(centroidDV, this.sampleSize);
                ids = DBIDUtil.newHashSet(queryResults);
            }
        } else {
            ids = relation.getDBIDs();
        }
        return this.generateModel(relation, ids, centroid.getArrayRef());
    }

    public CorrelationAnalysisSolution<V> generateModel(Relation<V> db, DBIDs ids) {
        return this.generateModel(db, ids, Centroid.make(db, ids).getArrayRef());
    }

    public CorrelationAnalysisSolution<V> generateModel(Relation<V> relation, DBIDs ids, double[] centroid) {
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("PCA...");
        }
        PCAResult epairs = this.pca.processIds(ids, relation);
        int numstrong = this.filter.filter(epairs.getEigenvalues());
        PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), numstrong, 1.0, 0.0);
        double[][] transposedWeakEigenvectors = pcares.getWeakEigenvectors();
        double[][] transposedStrongEigenvectors = pcares.getStrongEigenvectors();
        if (transposedWeakEigenvectors.length == 0) {
            return new CorrelationAnalysisSolution<V>(null, relation, VMath.transpose(transposedStrongEigenvectors), new double[0][], pcares.similarityMatrix(), centroid);
        }
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder(1000);
            FormatUtil.formatTo(msg.append("Strong Eigenvectors:\n"), transposedStrongEigenvectors, " [", "]\n", ", ", this.nf);
            FormatUtil.formatTo(msg.append("\nWeak Eigenvectors:\n"), transposedWeakEigenvectors, " [", "]\n", ", ", this.nf);
            FormatUtil.formatTo(msg.append("\nEigenvalues:\n"), pcares.getEigenvalues(), ", ", this.nf);
            LOG.debugFine(msg.toString());
        }
        double[] b = VMath.times(transposedWeakEigenvectors, centroid);
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder(1000);
            FormatUtil.formatTo(msg.append("Centroid:\n"), centroid, ", ", this.nf);
            FormatUtil.formatTo(msg.append("\ntEV * Centroid\n"), b, ", ", this.nf);
            LOG.debugFine(msg.toString());
        }
        double[][] gaussJordan = new double[transposedWeakEigenvectors.length][transposedWeakEigenvectors[0].length + 1];
        VMath.setMatrix(gaussJordan, 0, transposedWeakEigenvectors.length, 0, transposedWeakEigenvectors[0].length, transposedWeakEigenvectors);
        VMath.setCol(gaussJordan, transposedWeakEigenvectors[0].length, b);
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Gauss-Jordan-Elimination of " + FormatUtil.format(gaussJordan, " [", "]\n", ", ", this.nf));
        }
        LinearEquationSystem lq = new LinearEquationSystem(VMath.copy(transposedWeakEigenvectors), b);
        lq.solveByTotalPivotSearch();
        CorrelationAnalysisSolution<V> sol = new CorrelationAnalysisSolution<V>(lq, relation, VMath.transpose(transposedStrongEigenvectors), VMath.transpose(transposedWeakEigenvectors), pcares.similarityMatrix(), centroid);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Solution:\n" + "Standard deviation " + sol.getStandardDeviation() + lq.equationsToString(this.nf.getMaximumFractionDigits()));
        }
        return sol;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID DEPENDENCY_DERIVATOR_RANDOM_SAMPLE_ID = new OptionID("derivator.randomSample", "Flag to use random sample (use knn query around centroid, if flag is not set).");
        public static final OptionID OUTPUT_ACCURACY_ID = new OptionID("derivator.accuracy", "Threshold for output accuracy fraction digits.");
        public static final OptionID SAMPLE_SIZE_ID = new OptionID("derivator.sampleSize", "Threshold for the size of the random sample to use. Default value is size of the complete dataset.");
        protected int outputAccuracy = 0;
        protected int sampleSize = 0;
        protected boolean randomSample = false;
        protected PCARunner pca = null;
        protected EigenPairFilter filter;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter filterP;
            ObjectParameter pcaP;
            Flag randomSampleF;
            IntParameter sampleSizeP;
            super.makeOptions(config);
            IntParameter outputAccuracyP = (IntParameter)new IntParameter(OUTPUT_ACCURACY_ID, 4).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(outputAccuracyP)) {
                this.outputAccuracy = (Integer)outputAccuracyP.getValue();
            }
            if (config.grab(sampleSizeP = (IntParameter)((IntParameter)new IntParameter(SAMPLE_SIZE_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.sampleSize = (Integer)sampleSizeP.getValue();
            }
            if (config.grab(randomSampleF = new Flag(DEPENDENCY_DERIVATOR_RANDOM_SAMPLE_ID))) {
                this.randomSample = (Boolean)randomSampleF.getValue();
            }
            if (config.grab(pcaP = new ObjectParameter(PCARunner.Parameterizer.PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                this.pca = (PCARunner)pcaP.instantiateClass(config);
            }
            if (config.grab(filterP = new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class))) {
                this.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
        }

        @Override
        protected DependencyDerivator<V> makeInstance() {
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setMaximumFractionDigits(this.outputAccuracy);
            nf.setMinimumFractionDigits(this.outputAccuracy);
            return new DependencyDerivator(this.distanceFunction, nf, this.pca, this.filter, this.sampleSize, this.randomSample);
        }
    }
}

