/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Dummy Algorithm")
@Description(value="The algorithm executes an Euclidean 10NN query on all data points, and can be used in unit testing")
@Priority(value=-100)
public class DummyAlgorithm<O extends NumberVector>
extends AbstractAlgorithm<Result> {
    private static final Logging LOG = Logging.getLogger(DummyAlgorithm.class);

    public Result run(Database database, Relation<O> relation) {
        DistanceQuery<NumberVector> distQuery = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> knnQuery = database.getKNNQuery(distQuery, 10);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            relation.get(iditer);
            knnQuery.getKNNForDBID(iditer, 10);
            iditer.advance();
        }
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(EuclideanDistanceFunction.STATIC.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

