/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Arrays;

@Title(value="KNN-Distance-Order")
@Description(value="Assesses the knn distances for a specified k and orders them.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.KNNDistanceOrder"})
@References(value={@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96"), @Reference(authors="Erich Schubert, J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="DBSCAN Revisited, Revisited: Why and How You Should (Still) Use DBSCAN", booktitle="ACM Trans. Database Systems (TODS)", url="https://doi.org/10.1145/3068335", bibkey="DBLP:journals/tods/SchubertSEKX17")})
public class KNNDistancesSampler<O>
extends AbstractDistanceBasedAlgorithm<O, KNNDistanceOrderResult> {
    private static final Logging LOG = Logging.getLogger(KNNDistancesSampler.class);
    protected int k;
    protected double sample;
    private RandomFactory rnd;

    public KNNDistancesSampler(DistanceFunction<? super O> distanceFunction, int k, double sample, RandomFactory rnd) {
        super(distanceFunction);
        this.k = k;
        this.sample = sample;
        this.rnd = rnd;
    }

    public KNNDistanceOrderResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        int size = (int)(this.sample <= 1.0 ? Math.ceil((double)relation.size() * this.sample) : this.sample);
        ModifiableDBIDs sample = DBIDUtil.randomSample(relation.getDBIDs(), size, this.rnd);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Sampling kNN distances", size, LOG) : null;
        double[] knnDistances = new double[size];
        int i = 0;
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            KNNList neighbors = knnQuery.getKNNForDBID(iditer, this.k + 1);
            knnDistances[i] = neighbors.getKNNDistance();
            LOG.incrementProcessed(prog);
            iditer.advance();
            ++i;
        }
        LOG.ensureCompleted(prog);
        return new KNNDistanceOrderResult(knnDistances, this.k);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knndistanceorder.k", "Specifies the distance of the k-distant object to be assessed, ignoring the query object.");
        public static final OptionID SAMPLING_ID = new OptionID("knndistanceorder.sample", "The percentage of objects to use for sampling, or the absolute number of samples.");
        public static final OptionID SEED_ID = new OptionID("knndistanceorder.seed", "Random generator seed for sampling.");
        protected int k;
        protected double percentage;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            DoubleParameter percentageP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
            if (config.grab(percentageP = (DoubleParameter)new DoubleParameter(SAMPLING_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.percentage = (Double)percentageP.getValue();
            }
            if (config.grab(randomP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected KNNDistancesSampler<O> makeInstance() {
            return new KNNDistancesSampler(this.distanceFunction, this.k, this.percentage, this.rnd);
        }
    }

    public static class KNNDistanceOrderResult
    extends XYCurve {
        private int k;

        public KNNDistanceOrderResult(double[] knnDistances, int k) {
            super("Objects", k + "-NN-distance", knnDistances.length + 1);
            this.k = k;
            Arrays.sort(knnDistances);
            for (int j = 0; j < knnDistances.length; ++j) {
                this.addAndSimplify(knnDistances.length - j, knnDistances[j]);
            }
        }

        @Override
        public String getLongName() {
            return this.k + "-NN distance order";
        }

        @Override
        public String getShortName() {
            return this.k + "-NNDistanceOrder";
        }
    }
}

