/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.MissingPrerequisitesException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="K-Nearest Neighbor Join")
@Description(value="Algorithm to find the k-nearest neighbors of each object in a spatial database")
@Priority(value=-10)
public class KNNJoin<V extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
extends AbstractDistanceBasedAlgorithm<V, Relation<KNNList>> {
    private static final Logging LOG = Logging.getLogger(KNNJoin.class);
    int k;

    public KNNJoin(DistanceFunction<? super V> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k;
    }

    public Relation<KNNList> run(Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDataStore<KNNList> knnLists = this.run(relation, ids);
        return new MaterializedRelation<KNNList>("k nearest neighbors", "kNNs", TypeUtil.KNNLIST, knnLists, ids);
    }

    public WritableDataStore<KNNList> run(Relation<V> relation, DBIDs ids) {
        if (!(this.getDistanceFunction() instanceof SpatialPrimitiveDistanceFunction)) {
            throw new IllegalStateException("Distance Function must be an instance of " + SpatialPrimitiveDistanceFunction.class.getName());
        }
        ArrayList<SpatialIndexTree> indexes = ResultUtil.filterResults(relation.getHierarchy(), relation, SpatialIndexTree.class);
        if (indexes.size() != 1) {
            throw new MissingPrerequisitesException("KNNJoin found " + indexes.size() + " spatial indexes, expected exactly one.");
        }
        SpatialIndexTree index = (SpatialIndexTree)indexes.iterator().next();
        return this.run(index, ids);
    }

    public WritableDataStore<KNNList> run(SpatialIndexTree<N, E> index, DBIDs ids) {
        IndefiniteProgress fprogress;
        List pr_heaps;
        SpatialPrimitiveDistanceFunction distFunction = (SpatialPrimitiveDistanceFunction)this.getDistanceFunction();
        ArrayList<E> ps_candidates = new ArrayList<E>(index.getLeaves());
        ArrayList<List<KNNHeap>> heaps = new ArrayList<List<KNNHeap>>(ps_candidates.size());
        for (int i = 0; i < ps_candidates.size(); ++i) {
            heaps.add(this.initHeaps(distFunction, (SpatialNode)index.getNode((Entry)ps_candidates.get(i))));
        }
        int sqsize = ps_candidates.size() * (ps_candidates.size() - 1) >>> 1;
        ComparableMinHeap<Task> pq = new ComparableMinHeap<Task>(sqsize);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Number of leaves: " + ps_candidates.size() + " so " + sqsize + " MBR computations.");
        }
        FiniteProgress mprogress = LOG.isVerbose() ? new FiniteProgress("Comparing leaf MBRs", sqsize, LOG) : null;
        for (int i = 0; i < ps_candidates.size(); ++i) {
            SpatialEntry pr_entry = (SpatialEntry)ps_candidates.get(i);
            SpatialNode pr = (SpatialNode)index.getNode(pr_entry);
            pr_heaps = (List)heaps.get(i);
            double pr_knn_distance = this.computeStopDistance(pr_heaps);
            for (int j = i + 1; j < ps_candidates.size(); ++j) {
                SpatialEntry ps_entry = (SpatialEntry)ps_candidates.get(j);
                SpatialNode ps = (SpatialNode)index.getNode(ps_entry);
                List ps_heaps = (List)heaps.get(j);
                double ps_knn_distance = this.computeStopDistance(ps_heaps);
                double minDist = distFunction.minDist(pr_entry, ps_entry);
                if (minDist <= 0.0) {
                    this.processDataPages(distFunction, pr_heaps, ps_heaps, pr, ps);
                } else if (minDist <= pr_knn_distance || minDist <= ps_knn_distance) {
                    pq.add(new Task(minDist, i, j));
                }
                LOG.incrementProcessed(mprogress);
            }
        }
        LOG.ensureCompleted(mprogress);
        FiniteProgress qprogress = LOG.isVerbose() ? new FiniteProgress("Processing queue", pq.size(), LOG) : null;
        IndefiniteProgress indefiniteProgress = fprogress = LOG.isVerbose() ? new IndefiniteProgress("Full comparisons", LOG) : null;
        while (!pq.isEmpty()) {
            boolean dos;
            Task task = (Task)pq.poll();
            pr_heaps = (List)heaps.get(task.i);
            List ps_heaps = (List)heaps.get(task.j);
            double pr_knn_distance = this.computeStopDistance(pr_heaps);
            double ps_knn_distance = this.computeStopDistance(ps_heaps);
            boolean dor = task.mindist <= pr_knn_distance;
            boolean bl = dos = task.mindist <= ps_knn_distance;
            if (dor || dos) {
                SpatialNode pr = (SpatialNode)index.getNode((Entry)ps_candidates.get(task.i));
                SpatialNode ps = (SpatialNode)index.getNode((Entry)ps_candidates.get(task.j));
                if (dor && dos) {
                    this.processDataPages(distFunction, pr_heaps, ps_heaps, pr, ps);
                } else if (dor) {
                    this.processDataPages(distFunction, pr_heaps, null, pr, ps);
                } else {
                    this.processDataPages(distFunction, ps_heaps, null, ps, pr);
                }
                LOG.incrementProcessed(fprogress);
            }
            LOG.incrementProcessed(qprogress);
        }
        LOG.ensureCompleted(qprogress);
        LOG.setCompleted(fprogress);
        WritableDataStore<KNNList> knnLists = DataStoreUtil.makeStorage(ids, 4, KNNList.class);
        FiniteProgress pageprog = LOG.isVerbose() ? new FiniteProgress("Number of processed data pages", ps_candidates.size(), LOG) : null;
        for (int i = 0; i < ps_candidates.size(); ++i) {
            SpatialNode pr = (SpatialNode)index.getNode((Entry)ps_candidates.get(i));
            List pr_heaps2 = (List)heaps.get(i);
            for (int j = 0; j < pr.getNumEntries(); ++j) {
                knnLists.put(((LeafEntry)pr.getEntry(j)).getDBID(), ((KNNHeap)pr_heaps2.get(j)).toKNNList());
            }
            heaps.set(i, null);
            LOG.incrementProcessed(pageprog);
        }
        LOG.ensureCompleted(pageprog);
        return knnLists;
    }

    private List<KNNHeap> initHeaps(SpatialPrimitiveDistanceFunction<V> distFunction, N pr) {
        ArrayList<KNNHeap> pr_heaps = new ArrayList<KNNHeap>(pr.getNumEntries());
        for (int j = 0; j < pr.getNumEntries(); ++j) {
            pr_heaps.add(DBIDUtil.newHeap(this.k));
        }
        this.processDataPages(distFunction, pr_heaps, null, pr, pr);
        return pr_heaps;
    }

    private void processDataPages(SpatialPrimitiveDistanceFunction<? super V> df, List<KNNHeap> pr_heaps, List<KNNHeap> ps_heaps, N pr, N ps) {
        for (int j = 0; j < ps.getNumEntries(); ++j) {
            SpatialPointLeafEntry s_e = (SpatialPointLeafEntry)ps.getEntry(j);
            KNNHeap hj = ps_heaps != null ? ps_heaps.get(j) : null;
            DBID s_id = s_e.getDBID();
            for (int i = 0; i < pr.getNumEntries(); ++i) {
                SpatialPointLeafEntry r_e = (SpatialPointLeafEntry)pr.getEntry(i);
                double distance = df.minDist(s_e, r_e);
                pr_heaps.get(i).insert(distance, s_id);
                if (hj == null) continue;
                hj.insert(distance, r_e.getDBID());
            }
        }
    }

    private double computeStopDistance(List<KNNHeap> heaps) {
        double pr_knn_distance = Double.NaN;
        for (KNNHeap knnList : heaps) {
            double kdist = knnList.getKNNDistance();
            pr_knn_distance = kdist < pr_knn_distance ? pr_knn_distance : kdist;
        }
        if (pr_knn_distance != pr_knn_distance) {
            return Double.POSITIVE_INFINITY;
        }
        return pr_knn_distance;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("knnjoin.k", "Specifies the k-nearest neighbors to be assigned.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
        }

        @Override
        protected KNNJoin<V, N, E> makeInstance() {
            return new KNNJoin(this.distanceFunction, this.k);
        }
    }

    private class Task
    implements Comparable<Task> {
        final double mindist;
        final int i;
        final int j;

        public Task(double mindist, int i, int j) {
            this.mindist = mindist;
            this.i = i;
            this.j = j;
        }

        @Override
        public int compareTo(Task o) {
            return Double.compare(this.mindist, o.mindist);
        }
    }
}

