/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.benchmark;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.IncompatibleDataException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class RangeQueryBenchmarkAlgorithm<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(RangeQueryBenchmarkAlgorithm.class);
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected RandomFactory random;

    public RangeQueryBenchmarkAlgorithm(DistanceFunction<? super O> distanceFunction, DatabaseConnection queries, double sampling, RandomFactory random) {
        super(distanceFunction);
        this.queries = queries;
        this.sampling = sampling;
        this.random = random;
    }

    public Result run(Database database, Relation<O> relation, Relation<NumberVector> radrel) {
        if (this.queries != null) {
            throw new AbortException("This 'run' method will not use the given query set!");
        }
        DistanceQuery<O> distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distQuery, new Object[0]);
        DBIDs sample = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
        int hash = 0;
        MeanVariance mv = new MeanVariance();
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            double r = radrel.get(iditer).doubleValue(0);
            DoubleDBIDList rres = rangeQuery.getRangeForDBID(iditer, r);
            int ichecksum = 0;
            DoubleDBIDListIter it = rres.iter();
            while (it.valid()) {
                ichecksum += DBIDUtil.asInteger(it);
                it.advance();
            }
            hash = Util.mixHashCodes(hash, ichecksum);
            mv.put(rres.size());
            LOG.incrementProcessed(prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics("Result hashcode: " + hash);
            LOG.statistics("Mean number of results: " + mv.getMean() + " +- " + mv.getNaiveStddev());
        }
        return null;
    }

    public Result run(Database database, Relation<O> relation) {
        if (this.queries == null) {
            throw new AbortException("A query set is required for this 'run' method.");
        }
        DistanceQuery<O> distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distQuery, new Object[0]);
        NumberVector.Factory<O> ofactory = RelationUtil.getNumberVectorFactory(relation);
        int dim = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation<NumberVector> res = VectorFieldTypeInformation.typeRequest(NumberVector.class, dim + 1, dim + 1);
        MultipleObjectsBundle bundle = this.queries.loadData();
        int col = -1;
        for (int i = 0; i < bundle.metaLength(); ++i) {
            if (!res.isAssignableFromType(bundle.meta(i))) continue;
            col = i;
            break;
        }
        if (col < 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("No compatible data type in query input was found. Expected: ");
            buf.append(((Object)res).toString());
            buf.append(" have: ");
            for (int i = 0; i < bundle.metaLength(); ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(bundle.meta(i).toString());
            }
            throw new IncompatibleDataException(buf.toString());
        }
        DBIDRange sids = DBIDUtil.generateStaticDBIDRange(bundle.dataLength());
        DBIDs sample = DBIDUtil.randomSample((DBIDs)sids, this.sampling, this.random);
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
        int hash = 0;
        MeanVariance mv = new MeanVariance();
        double[] buf = new double[dim];
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            int off = sids.binarySearch(iditer);
            assert (off >= 0);
            NumberVector o = (NumberVector)bundle.data(off, col);
            for (int i = 0; i < dim; ++i) {
                buf[i] = o.doubleValue(i);
            }
            O v = ofactory.newNumberVector(buf);
            double r = o.doubleValue(dim);
            DoubleDBIDList rres = rangeQuery.getRangeForObject(v, r);
            int ichecksum = 0;
            DoubleDBIDListIter it = rres.iter();
            while (it.valid()) {
                ichecksum += DBIDUtil.asInteger(it);
                it.advance();
            }
            hash = Util.mixHashCodes(hash, ichecksum);
            mv.put(rres.size());
            LOG.incrementProcessed(prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics("Result hashcode: " + hash);
            LOG.statistics("Mean number of results: " + mv.getMean() + " +- " + mv.getNaiveStddev());
        }
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        if (this.queries == null) {
            return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
        }
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID QUERY_ID = new OptionID("rangebench.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("rangebench.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID RANDOM_ID = new OptionID("rangebench.random", "Random generator for sampling.");
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected RandomFactory random;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            DoubleParameter samplingP;
            super.makeOptions(config);
            ObjectParameter queryP = new ObjectParameter(QUERY_ID, DatabaseConnection.class);
            queryP.setOptional(true);
            if (config.grab(queryP)) {
                this.queries = (DatabaseConnection)queryP.instantiateClass(config);
            }
            if (config.grab(samplingP = (DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setOptional(true))) {
                this.sampling = samplingP.doubleValue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT))) {
                this.random = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected RangeQueryBenchmarkAlgorithm<O> makeInstance() {
            return new RangeQueryBenchmarkAlgorithm(this.distanceFunction, this.queries, this.sampling, this.random);
        }
    }
}

