/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.benchmark;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.regex.Pattern;

public class ValidateApproximativeKNNIndex<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(ValidateApproximativeKNNIndex.class);
    protected int k = 10;
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected boolean forcelinear = false;
    protected RandomFactory random;
    protected Pattern pattern;

    public ValidateApproximativeKNNIndex(DistanceFunction<? super O> distanceFunction, int k, DatabaseConnection queries, double sampling, boolean forcelinear, RandomFactory random, Pattern pattern) {
        super(distanceFunction);
        this.k = k;
        this.queries = queries;
        this.sampling = sampling;
        this.forcelinear = forcelinear;
        this.random = random;
        this.pattern = pattern;
    }

    public Result run(Database database, Relation<O> relation) {
        DistanceQuery<O> distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<Object> knnQuery = database.getKNNQuery(distQuery, this.k, "optimized");
        if (knnQuery == null || knnQuery instanceof LinearScanQuery) {
            throw new AbortException("Expected an accelerated query, but got a linear scan -- index is not used.");
        }
        KNNQuery<Object> truekNNQuery = this.forcelinear ? QueryUtil.getLinearScanKNNQuery(distQuery) : database.getKNNQuery(distQuery, this.k, "exact");
        if (knnQuery.getClass().equals(truekNNQuery.getClass())) {
            LOG.warning("Query classes are the same. This experiment may be invalid!");
        }
        if (this.queries == null || this.pattern != null) {
            Relation<String> lrel = this.pattern != null ? DatabaseUtil.guessLabelRepresentation(database) : null;
            DBIDs sample = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
            FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
            MeanVariance mv = new MeanVariance();
            MeanVariance mvrec = new MeanVariance();
            MeanVariance mvdist = new MeanVariance();
            MeanVariance mvdaerr = new MeanVariance();
            MeanVariance mvdrerr = new MeanVariance();
            int misses = 0;
            DBIDIter iditer = sample.iter();
            while (iditer.valid()) {
                if (this.pattern == null || this.pattern.matcher(lrel.get(iditer)).find()) {
                    KNNList knns = knnQuery.getKNNForDBID(iditer, this.k);
                    KNNList trueknns = truekNNQuery.getKNNForDBID(iditer, this.k);
                    mv.put((double)(knns.size() * this.k) / (double)trueknns.size());
                    mvrec.put((double)DBIDUtil.intersectionSize(knns, trueknns) / (double)trueknns.size());
                    if (knns.size() >= this.k) {
                        double kdist = knns.getKNNDistance();
                        double tdist = trueknns.getKNNDistance();
                        if (tdist > 0.0) {
                            mvdist.put(kdist);
                            mvdaerr.put(kdist - tdist);
                            mvdrerr.put(kdist / tdist);
                        }
                    } else {
                        ++misses;
                    }
                }
                LOG.incrementProcessed(prog);
                iditer.advance();
            }
            LOG.ensureCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics("Mean number of results: " + mv.getMean() + " +- " + mv.getNaiveStddev());
                LOG.statistics("Recall of true results: " + mvrec.getMean() + " +- " + mvrec.getNaiveStddev());
                if (mvdist.getCount() > 0.0) {
                    LOG.statistics("Mean k-distance: " + mvdist.getMean() + " +- " + mvdist.getNaiveStddev());
                    LOG.statistics("Mean absolute k-error: " + mvdaerr.getMean() + " +- " + mvdaerr.getNaiveStddev());
                    LOG.statistics("Mean relative k-error: " + mvdrerr.getMean() + " +- " + mvdrerr.getNaiveStddev());
                }
                if (misses > 0) {
                    LOG.statistics(String.format("Number of queries that returned less than k=%d objects: %d (%.2f%%)", this.k, misses, (double)misses * 100.0 / mv.getCount()));
                }
            }
        } else {
            TypeInformation res = this.getDistanceFunction().getInputTypeRestriction();
            MultipleObjectsBundle bundle = this.queries.loadData();
            int col = -1;
            for (int i = 0; i < bundle.metaLength(); ++i) {
                if (!res.isAssignableFromType(bundle.meta(i))) continue;
                col = i;
                break;
            }
            if (col < 0) {
                throw new AbortException("No compatible data type in query input was found. Expected: " + res.toString());
            }
            DBIDRange sids = DBIDUtil.generateStaticDBIDRange(bundle.dataLength());
            DBIDs sample = DBIDUtil.randomSample((DBIDs)sids, this.sampling, this.random);
            FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
            MeanVariance mv = new MeanVariance();
            MeanVariance mvrec = new MeanVariance();
            MeanVariance mvdist = new MeanVariance();
            MeanVariance mvdaerr = new MeanVariance();
            MeanVariance mvdrerr = new MeanVariance();
            int misses = 0;
            DBIDIter iditer = sample.iter();
            while (iditer.valid()) {
                int off = sids.binarySearch(iditer);
                assert (off >= 0);
                Object o = bundle.data(off, col);
                KNNList knns = knnQuery.getKNNForObject(o, this.k);
                KNNList trueknns = truekNNQuery.getKNNForObject(o, this.k);
                mv.put((double)(knns.size() * this.k) / (double)trueknns.size());
                mvrec.put((double)DBIDUtil.intersectionSize(knns, trueknns) / (double)trueknns.size());
                if (knns.size() >= this.k) {
                    double kdist = knns.getKNNDistance();
                    double tdist = trueknns.getKNNDistance();
                    if (tdist > 0.0) {
                        mvdist.put(kdist);
                        mvdaerr.put(kdist - tdist);
                        mvdrerr.put(kdist / tdist);
                    }
                } else {
                    ++misses;
                }
                LOG.incrementProcessed(prog);
                iditer.advance();
            }
            LOG.ensureCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics("Mean number of results: " + mv.getMean() + " +- " + mv.getNaiveStddev());
                LOG.statistics("Recall of true results: " + mvrec.getMean() + " +- " + mvrec.getNaiveStddev());
                if (mvdist.getCount() > 0.0) {
                    LOG.statistics("Mean absolute k-error: " + mvdaerr.getMean() + " +- " + mvdaerr.getNaiveStddev());
                    LOG.statistics("Mean relative k-error: " + mvdrerr.getMean() + " +- " + mvdrerr.getNaiveStddev());
                }
                if (misses > 0) {
                    LOG.statistics(String.format("Number of queries that returned less than k=%d objects: %d (%.2f%%)", this.k, misses, (double)misses * 100.0 / mv.getCount()));
                }
            }
        }
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("validateknn.k", "Number of neighbors to retreive for kNN benchmarking.");
        public static final OptionID QUERY_ID = new OptionID("validateknn.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("validateknn.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID FORCE_ID = new OptionID("validateknn.force-linear", "Force the use of linear scanning as reference.");
        public static final OptionID RANDOM_ID = new OptionID("validateknn.random", "Random generator for sampling.");
        public static final OptionID PATTERN_ID = new OptionID("validateknn.pattern", "Pattern to select query points.");
        protected int k = 10;
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected boolean forcelinear = false;
        protected RandomFactory random;
        protected Pattern pattern;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            Flag forceP;
            PatternParameter patternP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(patternP = (PatternParameter)new PatternParameter(PATTERN_ID).setOptional(true))) {
                this.pattern = (Pattern)patternP.getValue();
            } else {
                ObjectParameter queryP = new ObjectParameter(QUERY_ID, DatabaseConnection.class);
                queryP.setOptional(true);
                if (config.grab(queryP)) {
                    this.queries = (DatabaseConnection)queryP.instantiateClass(config);
                }
            }
            DoubleParameter samplingP = (DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setOptional(true);
            if (config.grab(samplingP)) {
                this.sampling = samplingP.doubleValue();
            }
            if (config.grab(forceP = new Flag(FORCE_ID))) {
                this.forcelinear = forceP.isTrue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT))) {
                this.random = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected ValidateApproximativeKNNIndex<O> makeInstance() {
            return new ValidateApproximativeKNNIndex(this.distanceFunction, this.k, this.queries, this.sampling, this.forcelinear, this.random, this.pattern);
        }
    }
}

