/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;

public final class ClusteringAlgorithmUtil {
    private ClusteringAlgorithmUtil() {
    }

    public static ArrayModifiableDBIDs[] partitionsFromIntegerLabels(DBIDs ids, IntegerDataStore assignment, int k) {
        int[] sizes = new int[k];
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            int n = assignment.intValue(iter);
            sizes[n] = sizes[n] + 1;
            iter.advance();
        }
        ArrayModifiableDBIDs[] clusters = new ArrayModifiableDBIDs[k];
        for (int i = 0; i < k; ++i) {
            clusters[i] = DBIDUtil.newArray(sizes[i]);
        }
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            clusters[assignment.intValue(iter2)].add(iter2);
            iter2.advance();
        }
        return clusters;
    }
}

