/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="DBSCAN: Density-Based Clustering of Applications with Noise")
@Description(value="Algorithm to find density-connected sets in a database based on the parameters 'minpts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@References(value={@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96"), @Reference(authors="Erich Schubert, J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="DBSCAN Revisited, Revisited: Why and How You Should (Still) Use DBSCAN", booktitle="ACM Trans. Database Systems (TODS)", url="https://doi.org/10.1145/3068335", bibkey="DBLP:journals/tods/SchubertSEKX17")})
@Priority(value=200)
public class DBSCAN<O>
extends AbstractDistanceBasedAlgorithm<O, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(DBSCAN.class);
    protected double epsilon;
    protected int minpts;
    protected List<ModifiableDBIDs> resultList;
    protected ModifiableDBIDs noise;
    protected ModifiableDBIDs processedIDs;
    protected long ncounter;

    public DBSCAN(DistanceFunction<? super O> distanceFunction, double epsilon, int minpts) {
        super(distanceFunction);
        this.epsilon = epsilon;
        this.minpts = minpts;
    }

    public Clustering<Model> run(Relation<O> relation) {
        int size = relation.size();
        if (size < this.minpts) {
            Clustering<Model> result = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            result.addToplevelCluster(new Cluster<ClusterModel>(relation.getDBIDs(), true, ClusterModel.CLUSTER));
            return result;
        }
        RangeQuery<O> rangeQuery = QueryUtil.getRangeQuery(relation, this.getDistanceFunction(), new Object[0]);
        this.resultList = new ArrayList<ModifiableDBIDs>();
        this.noise = DBIDUtil.newHashSet();
        this.runDBSCAN(relation, rangeQuery);
        double averagen = (double)this.ncounter / (double)relation.size();
        LOG.statistics(new DoubleStatistic(DBSCAN.class.getName() + ".average-neighbors", averagen));
        if (averagen < 1.0 + 0.1 * (double)(this.minpts - 1)) {
            LOG.warning("There are very few neighbors found. Epsilon may be too small.");
        }
        if (averagen > (double)(100 * this.minpts)) {
            LOG.warning("There are very many neighbors found. Epsilon may be too large.");
        }
        Clustering<Model> result = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
        for (ModifiableDBIDs res : this.resultList) {
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)res, ClusterModel.CLUSTER));
        }
        result.addToplevelCluster(new Cluster<ClusterModel>(this.noise, true, ClusterModel.CLUSTER));
        return result;
    }

    protected void runDBSCAN(Relation<O> relation, RangeQuery<O> rangeQuery) {
        int size = relation.size();
        FiniteProgress objprog = LOG.isVerbose() ? new FiniteProgress("Processing objects", size, LOG) : null;
        IndefiniteProgress clusprog = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters", LOG) : null;
        this.processedIDs = DBIDUtil.newHashSet(size);
        ArrayModifiableDBIDs seeds = DBIDUtil.newArray();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            if (!this.processedIDs.contains(iditer)) {
                this.expandCluster(relation, rangeQuery, iditer, seeds, objprog, clusprog);
            }
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.processedIDs.size(), LOG);
                clusprog.setProcessed(this.resultList.size(), LOG);
            }
            if (this.processedIDs.size() == size) break;
            iditer.advance();
        }
        LOG.ensureCompleted(objprog);
        LOG.setCompleted(clusprog);
    }

    protected void expandCluster(Relation<O> relation, RangeQuery<O> rangeQuery, DBIDRef startObjectID, ArrayModifiableDBIDs seeds, FiniteProgress objprog, IndefiniteProgress clusprog) {
        DoubleDBIDList neighbors = rangeQuery.getRangeForDBID(startObjectID, this.epsilon);
        this.ncounter += (long)neighbors.size();
        if (neighbors.size() < this.minpts) {
            this.noise.add(startObjectID);
            this.processedIDs.add(startObjectID);
            if (objprog != null) {
                objprog.incrementProcessed(LOG);
            }
            return;
        }
        ArrayModifiableDBIDs currentCluster = DBIDUtil.newArray();
        currentCluster.add(startObjectID);
        this.processedIDs.add(startObjectID);
        assert (seeds.size() == 0);
        seeds.clear();
        this.processNeighbors(neighbors.iter(), currentCluster, seeds);
        DBIDVar o = DBIDUtil.newVar();
        while (!seeds.isEmpty()) {
            neighbors = rangeQuery.getRangeForDBID(seeds.pop(o), this.epsilon);
            this.ncounter += (long)neighbors.size();
            if (neighbors.size() >= this.minpts) {
                this.processNeighbors(neighbors.iter(), currentCluster, seeds);
            }
            if (objprog == null) continue;
            objprog.incrementProcessed(LOG);
        }
        this.resultList.add(currentCluster);
        if (clusprog != null) {
            clusprog.setProcessed(this.resultList.size(), LOG);
        }
    }

    private void processNeighbors(DoubleDBIDListIter neighbor, ModifiableDBIDs currentCluster, ArrayModifiableDBIDs seeds) {
        boolean ismetric = this.getDistanceFunction().isMetric();
        while (neighbor.valid()) {
            block8: {
                block7: {
                    block6: {
                        if (!this.processedIDs.add(neighbor)) break block6;
                        if (!ismetric || neighbor.doubleValue() > 0.0) {
                            seeds.add(neighbor);
                        }
                        break block7;
                    }
                    if (!this.noise.remove(neighbor)) break block8;
                }
                currentCluster.add(neighbor);
            }
            neighbor.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID EPSILON_ID = new OptionID("dbscan.epsilon", "The maximum radius of the neighborhood to be considered.");
        public static final OptionID MINPTS_ID = new OptionID("dbscan.minpts", "Threshold for minimum number of points in the epsilon-neighborhood of a point. The suggested value is '2 * dim - 1'.");
        protected double epsilon;
        protected int minpts;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            super.makeOptions(config);
            DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(epsilonP)) {
                this.epsilon = (Double)epsilonP.getValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = (Integer)minptsP.getValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
        }

        @Override
        protected DBSCAN<O> makeInstance() {
            return new DBSCAN(this.distanceFunction, this.epsilon, this.minpts);
        }
    }
}

