/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Assignment;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Border;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Core;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.MultiBorder;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.IncompatibleDataException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import net.jafama.FastMath;

@Title(value="GriDBSCAN: Using Grid for Accelerating Density-Based Clustering")
@Reference(authors="S. Mahran, K. Mahar", title="Using grid for accelerating density-based clustering", booktitle="8th IEEE Int. Conf. on Computer and Information Technology", url="https://doi.org/10.1109/CIT.2008.4594646", bibkey="DBLP:conf/IEEEcit/MahranM08")
public class GriDBSCAN<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(GriDBSCAN.class);
    protected double epsilon;
    protected int minpts;
    protected double gridwidth;

    public GriDBSCAN(DistanceFunction<? super V> distanceFunction, double epsilon, int minpts, double gridwidth) {
        super(distanceFunction);
        this.epsilon = epsilon;
        this.minpts = minpts;
        this.gridwidth = gridwidth;
    }

    public Clustering<Model> run(Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        if (ids.size() < this.minpts) {
            Clustering<Model> result = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            result.addToplevelCluster(new Cluster<ClusterModel>(ids, true, ClusterModel.CLUSTER));
            return result;
        }
        double gridwidth = this.gridwidth;
        if (gridwidth < 2.0 * this.epsilon) {
            LOG.warning("Invalid grid width (less than 2*epsilon, recommended 10*epsilon). Increasing grid width automatically.");
            gridwidth = 2.0 * this.epsilon;
        }
        return new Instance(this.getDistanceFunction(), this.epsilon, this.minpts, gridwidth).run(relation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        CombinedTypeInformation type = new CombinedTypeInformation(TypeUtil.NUMBER_VECTOR_FIELD, this.getDistanceFunction().getInputTypeRestriction());
        return TypeUtil.array(type);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID GRID_ID = new OptionID("gridbscan.gridwidth", "Width of the grid used, must be at least two times epsilon.");
        protected double epsilon;
        protected int minpts;
        protected double gridwidth;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            DoubleParameter epsilonP;
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)LPNormDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.epsilon = (Double)epsilonP.getValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = (Integer)minptsP.getValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
            DoubleParameter gridP = (DoubleParameter)new DoubleParameter(GRID_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (this.epsilon > 0.0) {
                ((DoubleParameter)gridP.setDefaultValue((Object)(10.0 * this.epsilon))).addConstraint((ParameterConstraint)new GreaterEqualConstraint(1.0 * this.epsilon));
            }
            if (config.grab(gridP)) {
                this.gridwidth = gridP.doubleValue();
            }
        }

        @Override
        protected GriDBSCAN<O> makeInstance() {
            return new GriDBSCAN(this.distanceFunction, this.epsilon, this.minpts, this.gridwidth);
        }
    }

    protected static class Instance<V extends NumberVector> {
        protected static final int UNPROCESSED = 0;
        protected static final int NOISE = 1;
        protected DistanceFunction<? super V> distanceFunction;
        protected double epsilon;
        protected int minpts;
        protected double gridwidth;
        protected double[][] domain;
        protected int dim;
        protected double[] offset;
        protected int[] cells;
        Long2ObjectOpenHashMap<ModifiableDBIDs> grid;
        private Core[] cores;
        private Border[] borders;
        private WritableDataStore<Assignment> clusterids;
        private WritableIntegerDataStore temporary;
        private boolean overflown;

        public Instance(DistanceFunction<? super V> distanceFunction, double epsilon, int minpts, double gridwidth) {
            this.distanceFunction = distanceFunction;
            this.epsilon = epsilon;
            this.minpts = minpts;
            this.gridwidth = gridwidth;
        }

        public Clustering<Model> run(Relation<V> relation) {
            DBIDs ids = relation.getDBIDs();
            int size = ids.size();
            this.domain = RelationUtil.computeMinMax(relation);
            this.dim = this.domain[0].length;
            this.offset = new double[this.dim];
            this.cells = new int[this.dim];
            long numcells = this.computeGridBaseOffsets();
            if (numcells > (long)size) {
                LOG.warning("The generated grid has more cells than data points. This may need excessive amounts of memory.");
            } else if (numcells == 1L) {
                LOG.warning("All data is in a single cell. This has degenerated to a non-indexed DBSCAN!");
            } else if (numcells <= (long)(this.dim * this.dim)) {
                LOG.warning("There are only " + numcells + " cells. This will likely be slower than regular DBSCAN!");
            }
            this.buildGrid(relation, (int)numcells, this.offset);
            if (this.grid.size() <= this.dim) {
                LOG.warning("There are only " + this.grid.size() + " occupied cells. This will likely be slower than regular DBSCAN!");
            }
            int mincells = this.checkGridCellSizes(size, numcells);
            this.clusterids = DataStoreUtil.makeStorage(ids, 1, Assignment.class);
            this.temporary = DataStoreUtil.makeIntegerStorage(ids, 1, 0);
            ArrayModifiableDBIDs activeSet = DBIDUtil.newArray();
            int clusterid = 2;
            this.cores = new Core[2];
            this.borders = new Border[2];
            ModifiableDoubleDBIDList neighbors = DBIDUtil.newDistanceDBIDList(this.minpts << 1);
            FiniteProgress cprog = LOG.isVerbose() ? new FiniteProgress("Processing grid cells", mincells, LOG) : null;
            for (ModifiableDBIDs cellids : this.grid.values()) {
                if (cellids.size() < this.minpts) continue;
                this.temporary.clear();
                ProxyView<V> rel = new ProxyView<V>(cellids, relation);
                RangeQuery<V> rq = rel.getRangeQuery(this.distanceFunction, this.epsilon);
                FiniteProgress pprog = LOG.isVerbose() ? new FiniteProgress("Running DBSCAN", cellids.size(), LOG) : null;
                DBIDMIter id = cellids.iter();
                while (id.valid()) {
                    if (this.temporary.intValue(id) == 0) {
                        neighbors.clear();
                        rq.getRangeForDBID(id, this.epsilon, neighbors);
                        if (neighbors.size() >= this.minpts) {
                            this.expandCluster(id, clusterid, this.temporary, neighbors, activeSet, rq, pprog);
                            ++clusterid;
                        } else {
                            this.temporary.putInt(id, 1);
                            LOG.incrementProcessed(pprog);
                        }
                    }
                    id.advance();
                }
                LOG.ensureCompleted(pprog);
                this.updateCoreBorderObjects(clusterid);
                this.mergeClusterInformation(cellids, this.temporary, this.clusterids);
                LOG.incrementProcessed(cprog);
            }
            LOG.ensureCompleted(cprog);
            this.temporary.destroy();
            FiniteProgress pprog = LOG.isVerbose() ? new FiniteProgress("Building final result", size, LOG) : null;
            ModifiableDBIDs[] clusters = new ModifiableDBIDs[clusterid];
            ArrayModifiableDBIDs noise = DBIDUtil.newArray();
            DBIDIter it = ids.iter();
            while (it.valid()) {
                Assignment cids = (Assignment)this.clusterids.get(it);
                if (cids == null) {
                    noise.add(it);
                } else {
                    if (cids instanceof MultiBorder) {
                        cids = ((MultiBorder)cids).getCore();
                    } else if (cids instanceof Border) {
                        cids = ((Border)cids).core;
                    }
                    assert (cids instanceof Core);
                    Core co = (Core)cids;
                    while (this.cores[co.num].num != co.num) {
                        co.num = this.cores[co.num].num;
                        co = this.cores[co.num];
                    }
                    ModifiableDBIDs clu = clusters[co.num];
                    if (clu == null) {
                        clu = clusters[co.num] = DBIDUtil.newArray();
                    }
                    clu.add(it);
                }
                LOG.incrementProcessed(pprog);
                it.advance();
            }
            LOG.ensureCompleted(pprog);
            this.clusterids.destroy();
            Clustering<Model> result = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            for (int i = 2; i < clusters.length; ++i) {
                if (clusters[i] == null) continue;
                result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)clusters[i], ClusterModel.CLUSTER));
            }
            if (noise.size() > 0) {
                result.addToplevelCluster(new Cluster<ClusterModel>(noise, true, ClusterModel.CLUSTER));
            }
            return result;
        }

        private void updateCoreBorderObjects(int clusterid) {
            this.cores = Arrays.copyOf(this.cores, clusterid);
            this.borders = Arrays.copyOf(this.borders, clusterid);
            for (int i = this.cores.length; i < clusterid; ++i) {
                this.cores[i] = new Core(i);
                this.borders[i] = new Border(this.cores[i]);
            }
        }

        private long computeGridBaseOffsets() {
            StringBuffer buf = LOG.isDebuggingFinest() ? new StringBuffer() : null;
            double[] min = this.domain[0];
            double[] max = this.domain[1];
            long total = 1L;
            for (int d = 0; d < this.dim; ++d) {
                double mi = min[d];
                double ma = max[d];
                double wi = ma - mi;
                if (mi == Double.NEGATIVE_INFINITY || ma == Double.POSITIVE_INFINITY || mi != mi || ma != ma) {
                    throw new IncompatibleDataException("Dimension " + d + " contains non-finite values.");
                }
                int c = this.cells[d] = Math.max(1, (int)FastMath.ceil(wi / this.gridwidth));
                this.offset[d] = mi - ((double)c * this.gridwidth - wi) * 0.5;
                assert (this.offset[d] <= mi) : "Grid inconsistent.";
                assert (this.offset[d] + (double)c * this.gridwidth >= ma) : "Grid inconsistent.";
                if ((total *= (long)c) < 0L) {
                    LOG.warning("Excessive amount of grid cells (long overflow)! Use larger grid cells.");
                    this.overflown = true;
                    total &= Long.MAX_VALUE;
                }
                if (buf == null) continue;
                buf.append(d).append(": min=").append(mi).append(" max=").append(ma);
                double s = this.offset[d];
                for (int i = 0; i <= c; ++i) {
                    buf.append(' ').append(s);
                    s += this.gridwidth;
                }
                buf.append('\n');
            }
            if (buf != null) {
                LOG.debugFinest(buf);
            }
            return total;
        }

        protected void buildGrid(Relation<V> relation, int numcells, double[] offset) {
            this.grid = new Long2ObjectOpenHashMap(numcells >>> 2);
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                NumberVector obj = (NumberVector)relation.get(it);
                this.insertIntoGrid(it, obj, 0, 0);
                it.advance();
            }
        }

        private void insertIntoGrid(DBIDRef id, V obj, int d, int v) {
            int cn = this.cells[d];
            int nd = d + 1;
            int mi = Math.max(0, (int)FastMath.floor((obj.doubleValue(d) - this.offset[d] - this.epsilon) / this.gridwidth));
            int ma = Math.min(cn - 1, (int)FastMath.floor((obj.doubleValue(d) - this.offset[d] + this.epsilon) / this.gridwidth));
            assert (mi <= ma) : "Grid inconsistent.";
            for (int i = mi; i <= ma; ++i) {
                int c = v * cn + i;
                if (nd == this.cells.length) {
                    ModifiableDBIDs ids = this.grid.get(c);
                    if (ids == null) {
                        ids = DBIDUtil.newArray();
                        this.grid.put(c, ids);
                    }
                    ids.add(id);
                    continue;
                }
                this.insertIntoGrid(id, obj, nd, c);
            }
        }

        protected int checkGridCellSizes(int size, long numcell) {
            int tcount = 0;
            int hasmin = 0;
            double sqcount = 0.0;
            for (ModifiableDBIDs cell : this.grid.values()) {
                int s = cell.size();
                if (s >= size >> 1) {
                    LOG.warning("A single cell contains half of the database (" + s + " objects). This will not scale very well.");
                }
                tcount += s;
                sqcount += (double)((long)s * (long)s);
                if (s < this.minpts) continue;
                ++hasmin;
            }
            double savings = sqcount / (double)size / (double)size;
            if (savings >= 1.0) {
                LOG.warning("Pairwise distances within each cells are more expensive than a full DBSCAN run due to overlap!");
            }
            if (this.overflown) {
                LOG.statistics(new StringStatistic(GriDBSCAN.class.getName() + ".all-cells", "overflow"));
            } else {
                LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".all-cells", numcell));
            }
            LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".used-cells", this.grid.size()));
            LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".minpts-cells", hasmin));
            LOG.statistics(new DoubleStatistic(GriDBSCAN.class.getName() + ".redundancy", (double)tcount / (double)size));
            LOG.statistics(new DoubleStatistic(GriDBSCAN.class.getName() + ".relative-cost", savings));
            return hasmin;
        }

        protected int expandCluster(DBIDRef seed, int clusterid, WritableIntegerDataStore clusterids, ModifiableDoubleDBIDList neighbors, ArrayModifiableDBIDs activeSet, RangeQuery<V> rq, FiniteProgress pprog) {
            assert (activeSet.size() == 0);
            int clustersize = 1 + this.processCorePoint(seed, neighbors, clusterid, clusterids, activeSet);
            LOG.incrementProcessed(pprog);
            DBIDVar id = DBIDUtil.newVar();
            while (!activeSet.isEmpty()) {
                activeSet.pop(id);
                neighbors.clear();
                rq.getRangeForDBID(id, this.epsilon, neighbors);
                if (neighbors.size() >= this.minpts) {
                    clustersize += this.processCorePoint(id, neighbors, clusterid, clusterids, activeSet);
                }
                LOG.incrementProcessed(pprog);
            }
            return clustersize;
        }

        protected int processCorePoint(DBIDRef seed, DoubleDBIDList newneighbors, int clusterid, WritableIntegerDataStore clusterids, ArrayModifiableDBIDs activeSet) {
            clusterids.putInt(seed, clusterid);
            int clustersize = 0;
            DoubleDBIDListIter it = newneighbors.iter();
            while (it.valid()) {
                block8: {
                    block7: {
                        int oldassign;
                        block6: {
                            oldassign = clusterids.intValue(it);
                            if (oldassign != 0) break block6;
                            if (it.doubleValue() > 0.0) {
                                activeSet.add(it);
                            }
                            break block7;
                        }
                        if (oldassign != 1) break block8;
                    }
                    ++clustersize;
                    clusterids.putInt(it, -clusterid);
                }
                it.advance();
            }
            return clustersize;
        }

        protected void mergeClusterInformation(ModifiableDBIDs cellids, WritableIntegerDataStore temporary, WritableDataStore<Assignment> clusterids) {
            FiniteProgress mprog = LOG.isVerbose() ? new FiniteProgress("Collecting result", cellids.size(), LOG) : null;
            DBIDMIter id = cellids.iter();
            while (id.valid()) {
                Assignment oclus;
                int nclus = temporary.intValue(id);
                if (nclus > 1) {
                    Core core = this.cores[nclus];
                    assert (core.num > 1);
                    oclus = (Assignment)clusterids.get(id);
                    if (oclus == null) {
                        clusterids.put(id, core);
                    } else if (oclus instanceof Core) {
                        core.mergeWith((Core)oclus);
                    } else if (oclus instanceof Border) {
                        core.mergeWith(((Border)oclus).core);
                        clusterids.put(id, core);
                    } else {
                        int m2;
                        int m;
                        assert (oclus instanceof MultiBorder);
                        if (LOG.isDebuggingFinest()) {
                            LOG.debugFinest("Multi-Merge: " + nclus + " - " + oclus + " -> " + core);
                        }
                        int n = m = (m = core.num) < (m2 = ((MultiBorder)oclus).getCore().num) ? m : m2;
                        assert (m > 1);
                        for (Border b : ((MultiBorder)oclus).cs) {
                            this.cores[b.core.num].num = m;
                        }
                        core.num = m;
                        clusterids.put(id, core);
                    }
                } else if (nclus < 0) {
                    Border border = this.borders[-nclus];
                    oclus = (Assignment)clusterids.get(id);
                    if (oclus == null) {
                        clusterids.put(id, border);
                    } else if (oclus instanceof Core) {
                        ((Core)oclus).mergeWith(border.core);
                    } else if (oclus instanceof Border) {
                        if (((Border)oclus).core.num != border.core.num) {
                            clusterids.put(id, new MultiBorder((Border)oclus, border));
                        }
                    } else {
                        assert (oclus instanceof MultiBorder);
                        clusterids.put(id, ((MultiBorder)oclus).update(border));
                    }
                } else assert (nclus == 1);
                LOG.incrementProcessed(mprog);
                id.advance();
            }
            LOG.ensureCompleted(mprog);
        }
    }
}

