/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.data.model.SimplePrototypeModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Reference(authors="J. A. Hartigan", title="Chapter 3: Quick Partition Algorithms, 3.2 Leader Algorithm", booktitle="Clustering algorithms", url="http://dl.acm.org/citation.cfm?id=540298", bibkey="books/wiley/Hartigan75/C3")
public class Leader<O>
extends AbstractDistanceBasedAlgorithm<O, Clustering<PrototypeModel<O>>>
implements ClusteringAlgorithm<Clustering<PrototypeModel<O>>> {
    private double threshold;
    private static final Logging LOG = Logging.getLogger(Leader.class);

    public Leader(DistanceFunction<? super O> distanceFunction, double threshold) {
        super(distanceFunction);
        this.threshold = threshold;
    }

    public Clustering<PrototypeModel<O>> run(Relation<O> relation) {
        RangeQuery<O> rq = relation.getRangeQuery(this.getDistanceFunction(), this.threshold);
        HashSetModifiableDBIDs seen = DBIDUtil.newHashSet(relation.size());
        Clustering<PrototypeModel<O>> clustering = new Clustering<PrototypeModel<O>>("Prototype clustering", "prototype-clustering");
        int queries = 0;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Leader clustering", relation.size(), LOG) : null;
        DBIDIter it = relation.iterDBIDs();
        while (it.valid() && seen.size() < relation.size()) {
            if (!seen.contains(it)) {
                DoubleDBIDList res = rq.getRangeForDBID(it, this.threshold);
                ++queries;
                ArrayModifiableDBIDs ids = DBIDUtil.newArray(res.size());
                DoubleDBIDListIter cand = res.iter();
                while (cand.valid()) {
                    if (seen.add(cand)) {
                        LOG.incrementProcessed(prog);
                        ids.add(cand);
                    }
                    cand.advance();
                }
                assert (ids.size() > 0 && ids.contains(it));
                SimplePrototypeModel<O> mod = new SimplePrototypeModel<O>(relation.get(it));
                clustering.addToplevelCluster(new Cluster<SimplePrototypeModel<O>>((DBIDs)ids, mod));
            }
            it.advance();
        }
        LOG.statistics(new LongStatistic(this.getClass().getName() + ".queries", queries));
        LOG.ensureCompleted(prog);
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID THRESHOLD_ID = new OptionID("leader.threshold", "Maximum distance from leading object.");
        private double threshold;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter thresholdP = new DoubleParameter(THRESHOLD_ID);
            if (config.grab(thresholdP)) {
                this.threshold = thresholdP.doubleValue();
            }
        }

        @Override
        protected Leader<O> makeInstance() {
            return new Leader(this.distanceFunction, this.threshold);
        }
    }
}

