/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractIndexBasedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SharedNearestNeighborSimilarityFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Title(value="SNN: Shared Nearest Neighbor Clustering")
@Description(value="Algorithm to find shared-nearest-neighbors-density-connected sets in a database based on the parameters 'minPts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="L. Ert\u00f6z, M. Steinbach, V. Kumar", title="Finding Clusters of Different Sizes, Shapes, and Densities in Noisy, High Dimensional Data", booktitle="Proc. of SIAM Data Mining (SDM'03)", url="https://doi.org/10.1137/1.9781611972733.5", bibkey="DBLP:conf/sdm/ErtozSK03")
public class SNNClustering<O>
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(SNNClustering.class);
    private int epsilon;
    private int minpts;
    protected List<ModifiableDBIDs> resultList;
    protected ModifiableDBIDs noise;
    protected ModifiableDBIDs processedIDs;
    private SharedNearestNeighborSimilarityFunction<O> similarityFunction;

    public SNNClustering(SharedNearestNeighborSimilarityFunction<O> similarityFunction, int epsilon, int minpts) {
        this.similarityFunction = similarityFunction;
        this.epsilon = epsilon;
        this.minpts = minpts;
    }

    public Clustering<Model> run(Database database, Relation<O> relation) {
        DBIDIter id;
        AbstractIndexBasedSimilarityFunction.Instance snnInstance = this.similarityFunction.instantiate(relation);
        FiniteProgress objprog = LOG.isVerbose() ? new FiniteProgress("SNNClustering", relation.size(), LOG) : null;
        IndefiniteProgress clusprog = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters", LOG) : null;
        this.resultList = new ArrayList<ModifiableDBIDs>();
        this.noise = DBIDUtil.newHashSet();
        this.processedIDs = DBIDUtil.newHashSet(relation.size());
        if (relation.size() >= this.minpts) {
            id = relation.iterDBIDs();
            while (id.valid()) {
                if (!this.processedIDs.contains(id)) {
                    this.expandCluster(snnInstance, id, objprog, clusprog);
                    if (this.processedIDs.size() == relation.size() && this.noise.size() == 0) break;
                }
                if (objprog != null && clusprog != null) {
                    objprog.setProcessed(this.processedIDs.size(), LOG);
                    clusprog.setProcessed(this.resultList.size(), LOG);
                }
                id.advance();
            }
        } else {
            id = relation.iterDBIDs();
            while (id.valid()) {
                this.noise.add(id);
                if (objprog != null && clusprog != null) {
                    objprog.setProcessed(this.noise.size(), LOG);
                    clusprog.setProcessed(this.resultList.size(), LOG);
                }
                id.advance();
            }
        }
        LOG.ensureCompleted(objprog);
        LOG.setCompleted(clusprog);
        Clustering<Model> result = new Clustering<Model>("Shared-Nearest-Neighbor Clustering", "snn-clustering");
        Iterator<ModifiableDBIDs> resultListIter = this.resultList.iterator();
        while (resultListIter.hasNext()) {
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)resultListIter.next(), ClusterModel.CLUSTER));
        }
        result.addToplevelCluster(new Cluster<ClusterModel>(this.noise, true, ClusterModel.CLUSTER));
        return result;
    }

    protected ArrayModifiableDBIDs findSNNNeighbors(SimilarityQuery<O> snnInstance, DBIDRef queryObject) {
        ArrayModifiableDBIDs neighbors = DBIDUtil.newArray();
        DBIDIter iditer = snnInstance.getRelation().iterDBIDs();
        while (iditer.valid()) {
            if (snnInstance.similarity(queryObject, (DBIDRef)iditer) >= (double)this.epsilon) {
                neighbors.add(iditer);
            }
            iditer.advance();
        }
        return neighbors;
    }

    protected void expandCluster(SimilarityQuery<O> snnInstance, DBIDRef startObjectID, FiniteProgress objprog, IndefiniteProgress clusprog) {
        ArrayModifiableDBIDs seeds = this.findSNNNeighbors(snnInstance, startObjectID);
        if (seeds.size() < this.minpts) {
            this.noise.add(startObjectID);
            this.processedIDs.add(startObjectID);
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.processedIDs.size(), LOG);
                clusprog.setProcessed(this.resultList.size(), LOG);
            }
            return;
        }
        ArrayModifiableDBIDs currentCluster = DBIDUtil.newArray();
        DBIDArrayMIter seed = seeds.iter();
        while (seed.valid()) {
            if (!this.processedIDs.contains(seed)) {
                currentCluster.add(seed);
                this.processedIDs.add(seed);
            } else if (this.noise.contains(seed)) {
                currentCluster.add(seed);
                this.noise.remove(seed);
            }
            seed.advance();
        }
        DBIDVar o = DBIDUtil.newVar();
        while (seeds.size() > 0) {
            seeds.pop(o);
            ArrayModifiableDBIDs neighborhood = this.findSNNNeighbors(snnInstance, o);
            if (neighborhood.size() >= this.minpts) {
                DBIDArrayMIter iter = neighborhood.iter();
                while (iter.valid()) {
                    boolean unclassified;
                    boolean inNoise = this.noise.contains(iter);
                    boolean bl = unclassified = !this.processedIDs.contains(iter);
                    if (inNoise || unclassified) {
                        if (unclassified) {
                            seeds.add(iter);
                        }
                        currentCluster.add(iter);
                        this.processedIDs.add(iter);
                        if (inNoise) {
                            this.noise.remove(iter);
                        }
                    }
                    iter.advance();
                }
            }
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.processedIDs.size(), LOG);
                int numClusters = currentCluster.size() > this.minpts ? this.resultList.size() + 1 : this.resultList.size();
                clusprog.setProcessed(numClusters, LOG);
            }
            if (this.processedIDs.size() != snnInstance.getRelation().size() || this.noise.size() != 0) continue;
            break;
        }
        if (currentCluster.size() >= this.minpts) {
            this.resultList.add(currentCluster);
        } else {
            this.noise.addDBIDs(currentCluster);
            this.noise.add(startObjectID);
            this.processedIDs.add(startObjectID);
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.similarityFunction.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("snn.epsilon", "The minimum SNN density.");
        public static final OptionID MINPTS_ID = new OptionID("snn.minpts", "Threshold for minimum number of points in the epsilon-SNN-neighborhood of a point.");
        protected int epsilon;
        protected int minpts;
        private SharedNearestNeighborSimilarityFunction<O> similarityFunction;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            super.makeOptions(config);
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(SharedNearestNeighborSimilarityFunction.class);
            this.similarityFunction = (SharedNearestNeighborSimilarityFunction)config.tryInstantiate(cls);
            IntParameter epsilonP = new IntParameter(EPSILON_ID);
            if (config.grab(epsilonP)) {
                this.epsilon = (Integer)epsilonP.getValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = minptsP.intValue();
            }
        }

        @Override
        protected SNNClustering<O> makeInstance() {
            return new SNNClustering<O>(this.similarityFunction, this.epsilon, this.minpts);
        }
    }
}

