/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.DistanceBasedInitializationWithMedian;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

@Title(value="Affinity Propagation: Clustering by Passing Messages Between Data Points")
@Reference(title="Clustering by Passing Messages Between Data Points", authors="B. J. Frey, D. Dueck", booktitle="Science Vol 315", url="https://doi.org/10.1126/science.1136800", bibkey="doi:10.1126/science.1136800")
public class AffinityPropagationClusteringAlgorithm<O>
extends AbstractAlgorithm<Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(AffinityPropagationClusteringAlgorithm.class);
    AffinityPropagationInitialization<O> initialization;
    double lambda = 0.5;
    int convergence = 10;
    int maxiter = 1000;

    public AffinityPropagationClusteringAlgorithm(AffinityPropagationInitialization<O> initialization, double lambda, int convergence, int maxiter) {
        this.initialization = initialization;
        this.lambda = lambda;
        this.convergence = convergence;
        this.maxiter = maxiter;
    }

    public Clustering<MedoidModel> run(Database db, Relation<O> relation) {
        int i;
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        int size = ids.size();
        int[] assignment = new int[size];
        double[][] s = this.initialization.getSimilarityMatrix(db, relation, ids);
        double[][] r = new double[size][size];
        double[][] a = new double[size][size];
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("Affinity Propagation Iteration", LOG) : null;
        MutableProgress aprog = LOG.isVerbose() ? new MutableProgress("Stable assignments", size + 1, LOG) : null;
        int inactive = 0;
        for (int iteration = 0; iteration < this.maxiter && inactive < this.convergence; ++iteration) {
            for (int i2 = 0; i2 < size; ++i2) {
                double val;
                int k;
                double[] ai = a[i2];
                double[] ri = r[i2];
                double[] si = s[i2];
                double max1 = Double.NEGATIVE_INFINITY;
                double max2 = Double.NEGATIVE_INFINITY;
                int maxk = -1;
                for (k = 0; k < size; ++k) {
                    val = ai[k] + si[k];
                    if (val > max1) {
                        max2 = max1;
                        max1 = val;
                        maxk = k;
                        continue;
                    }
                    if (!(val > max2)) continue;
                    max2 = val;
                }
                for (k = 0; k < size; ++k) {
                    val = si[k] - (k != maxk ? max1 : max2);
                    ri[k] = ri[k] * this.lambda + val * (1.0 - this.lambda);
                }
            }
            for (int k = 0; k < size; ++k) {
                int i3;
                double colposum = 0.0;
                for (i3 = 0; i3 < size; ++i3) {
                    if (i3 != k && !(r[i3][k] > 0.0)) continue;
                    colposum += r[i3][k];
                }
                for (i3 = 0; i3 < size; ++i3) {
                    double val = colposum;
                    if (i3 == k || r[i3][k] > 0.0) {
                        val -= r[i3][k];
                    }
                    if (i3 != k && val > 0.0) {
                        val = 0.0;
                    }
                    a[i3][k] = a[i3][k] * this.lambda + val * (1.0 - this.lambda);
                }
            }
            int changed = 0;
            for (i = 0; i < size; ++i) {
                double[] ai = a[i];
                double[] ri = r[i];
                double max = Double.NEGATIVE_INFINITY;
                int maxj = -1;
                for (int j = 0; j < size; ++j) {
                    double v = ai[j] + ri[j];
                    if (!(v > max) && (i != j || !(v >= max))) continue;
                    max = v;
                    maxj = j;
                }
                if (assignment[i] == maxj) continue;
                ++changed;
                assignment[i] = maxj;
            }
            inactive = changed > 0 ? 0 : inactive + 1;
            LOG.incrementProcessed(prog);
            if (aprog == null) continue;
            aprog.setProcessed(size - changed, LOG);
        }
        if (aprog != null) {
            aprog.setProcessed(aprog.getTotal(), LOG);
        }
        LOG.setCompleted(prog);
        Int2ObjectOpenHashMap<ModifiableDBIDs> map = new Int2ObjectOpenHashMap<ModifiableDBIDs>();
        DBIDArrayIter i1 = ids.iter();
        i = 0;
        while (i1.valid()) {
            int c = assignment[i];
            ModifiableDBIDs cids = (ModifiableDBIDs)map.get(c);
            if (cids == null) {
                cids = DBIDUtil.newArray();
                map.put(c, cids);
            }
            cids.add(i1);
            i1.advance();
            ++i;
        }
        ObjectIterator iter = map.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            int key;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            int targetkey = key = entry.getIntKey();
            ModifiableDBIDs tids = null;
            while (tids == null && assignment[targetkey] != targetkey) {
                targetkey = assignment[targetkey];
                tids = (ModifiableDBIDs)map.get(targetkey);
            }
            if (tids == null || targetkey == key) continue;
            tids.addDBIDs((DBIDs)entry.getValue());
            iter.remove();
        }
        Clustering<MedoidModel> clustering = new Clustering<MedoidModel>("Affinity Propagation Clustering", "ap-clustering");
        ArrayModifiableDBIDs noise = DBIDUtil.newArray();
        ObjectIterator iter2 = map.int2ObjectEntrySet().fastIterator();
        while (iter2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter2.next();
            i1.seek(entry.getIntKey());
            if (((ModifiableDBIDs)entry.getValue()).size() > 1) {
                MedoidModel mod = new MedoidModel(DBIDUtil.deref(i1));
                clustering.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)entry.getValue(), mod));
                continue;
            }
            noise.add(i1);
        }
        if (noise.size() > 0) {
            MedoidModel mod = new MedoidModel(DBIDUtil.deref(noise.iter()));
            clustering.addToplevelCluster(new Cluster<MedoidModel>(noise, true, mod));
        }
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.initialization.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID INITIALIZATION_ID = new OptionID("ap.initialization", "Similarity matrix initialization..");
        public static final OptionID LAMBDA_ID = new OptionID("ap.lambda", "Dampening factor lambda. Usually 0.5 to 1.");
        public static final OptionID CONVERGENCE_ID = new OptionID("ap.convergence", "Number of stable iterations for convergence.");
        public static final OptionID MAXITER_ID = new OptionID("ap.maxiter", "Maximum number of iterations.");
        AffinityPropagationInitialization<O> initialization;
        double lambda = 0.5;
        int convergence;
        int maxiter;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxiterP;
            IntParameter convergenceP;
            DoubleParameter lambdaP;
            super.makeOptions(config);
            ObjectParameter param = new ObjectParameter(INITIALIZATION_ID, (Class<?>)AffinityPropagationInitialization.class, DistanceBasedInitializationWithMedian.class);
            if (config.grab(param)) {
                this.initialization = (AffinityPropagationInitialization)param.instantiateClass(config);
            }
            if (config.grab(lambdaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(LAMBDA_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE))) {
                this.lambda = lambdaP.doubleValue();
            }
            if (config.grab(convergenceP = (IntParameter)new IntParameter(CONVERGENCE_ID, 15).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.convergence = convergenceP.intValue();
            }
            if (config.grab(maxiterP = new IntParameter(MAXITER_ID, 1000))) {
                this.maxiter = maxiterP.intValue();
            }
        }

        @Override
        protected AffinityPropagationClusteringAlgorithm<O> makeInstance() {
            return new AffinityPropagationClusteringAlgorithm<O>(this.initialization, this.lambda, this.convergence, this.maxiter);
        }
    }
}

