/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class DistanceBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    DistanceFunction<? super O> distance;
    double quantile;

    public DistanceBasedInitializationWithMedian(DistanceFunction<? super O> distance, double quantile) {
        this.distance = distance;
        this.quantile = quantile;
    }

    @Override
    public double[][] getSimilarityMatrix(Database db, Relation<O> relation, ArrayDBIDs ids) {
        int size = ids.size();
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.distance, new Object[0]);
        double[][] mat = new double[size][size];
        double[] flat = new double[size * (size - 1) >> 1];
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            double[] mati = mat[i];
            i2.seek(i + 1);
            for (int k = i + 1; k < size; ++k) {
                mati[k] = -dq.distance((DBIDRef)i1, (DBIDRef)i2);
                mat[k][i] = mati[k];
                flat[j] = mati[k];
                ++j;
                i2.advance();
            }
            i1.advance();
        }
        double median = QuickSelect.quantile(flat, this.quantile);
        for (int i = 0; i < size; ++i) {
            mat[i][i] = median;
        }
        return mat;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ap.distance", "Distance function to use.");
        DistanceFunction<? super O> distance;
        double quantile;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter quantileP;
            super.makeOptions(config);
            ObjectParameter param = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(param)) {
                this.distance = (DistanceFunction)param.instantiateClass(config);
            }
            if (config.grab(quantileP = new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5))) {
                this.quantile = quantileP.doubleValue();
            }
        }

        @Override
        protected DistanceBasedInitializationWithMedian<O> makeInstance() {
            return new DistanceBasedInitializationWithMedian<O>(this.distance, this.quantile);
        }
    }
}

