/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class SimilarityBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    SimilarityFunction<? super O> similarity;
    double quantile;

    public SimilarityBasedInitializationWithMedian(SimilarityFunction<? super O> similarity, double quantile) {
        this.similarity = similarity;
        this.quantile = quantile;
    }

    @Override
    public double[][] getSimilarityMatrix(Database db, Relation<O> relation, ArrayDBIDs ids) {
        int i;
        int size = ids.size();
        SimilarityQuery<O> sq = db.getSimilarityQuery(relation, this.similarity, new Object[0]);
        double[][] mat = new double[size][size];
        double[] flat = new double[size * (size - 1) >> 1];
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        for (i = 0; i < size; ++i) {
            mat[i][i] = sq.similarity((DBIDRef)i1, (DBIDRef)i1) * 0.5;
            i1.advance();
        }
        i1.seek(0);
        int j = 0;
        for (i = 0; i < size; ++i) {
            double[] mati = mat[i];
            i2.seek(i + 1);
            for (int k = i + 1; k < size; ++k) {
                mati[k] = sq.similarity((DBIDRef)i1, (DBIDRef)i2) - mati[i] - mat[k][k];
                mat[k][i] = mati[k];
                flat[j] = mati[k];
                ++j;
                i2.advance();
            }
            i1.advance();
        }
        double median = QuickSelect.quantile(flat, this.quantile);
        for (int i3 = 0; i3 < size; ++i3) {
            mat[i3][i3] = median;
        }
        return mat;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.similarity.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID SIMILARITY_ID = new OptionID("ap.similarity", "Similarity function to use.");
        SimilarityFunction<? super O> similarity;
        double quantile;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter quantileP;
            super.makeOptions(config);
            ObjectParameter param = new ObjectParameter(SIMILARITY_ID, (Class<?>)SimilarityFunction.class, LinearKernelFunction.class);
            if (config.grab(param)) {
                this.similarity = (SimilarityFunction)param.instantiateClass(config);
            }
            if (config.grab(quantileP = new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5))) {
                this.quantile = quantileP.doubleValue();
            }
        }

        @Override
        protected SimilarityBasedInitializationWithMedian<O> makeInstance() {
            return new SimilarityBasedInitializationWithMedian<O>(this.similarity, this.quantile);
        }
    }
}

