/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.BiclusterModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import java.util.BitSet;

public abstract class AbstractBiclustering<V extends NumberVector, M extends BiclusterModel>
extends AbstractAlgorithm<Clustering<M>>
implements ClusteringAlgorithm<Clustering<M>> {
    private Database database;
    protected Relation<V> relation;
    private DBIDArrayIter iter;
    protected ArrayDBIDs rowIDs;
    private int colDim;

    protected AbstractBiclustering() {
    }

    public final Clustering<M> run(Relation<V> relation) {
        this.relation = relation;
        this.colDim = RelationUtil.dimensionality(relation);
        this.rowIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        this.iter = this.rowIDs.iter();
        return this.biclustering();
    }

    protected abstract Clustering<M> biclustering();

    protected int[] colsBitsetToIDs(BitSet cols) {
        int[] colIDs = new int[cols.cardinality()];
        int colsIndex = 0;
        int i = cols.nextSetBit(0);
        while (i >= 0) {
            colIDs[colsIndex] = i;
            ++colsIndex;
            i = cols.nextSetBit(i + 1);
        }
        return colIDs;
    }

    protected ArrayDBIDs rowsBitsetToIDs(BitSet rows) {
        ArrayModifiableDBIDs rowIDs = DBIDUtil.newArray(rows.cardinality());
        DBIDArrayIter iter = this.rowIDs.iter();
        int i = rows.nextSetBit(0);
        while (i >= 0) {
            iter.seek(i);
            rowIDs.add(iter);
            i = rows.nextSetBit(i + 1);
        }
        return rowIDs;
    }

    protected Cluster<BiclusterModel> defineBicluster(BitSet rows, BitSet cols) {
        ArrayDBIDs rowIDs = this.rowsBitsetToIDs(rows);
        int[] colIDs = this.colsBitsetToIDs(cols);
        return new Cluster<BiclusterModel>((DBIDs)rowIDs, new BiclusterModel(colIDs));
    }

    protected Cluster<BiclusterModel> defineBicluster(long[] rows, long[] cols) {
        ArrayDBIDs rowIDs = this.rowsBitsetToIDs(rows);
        int[] colIDs = this.colsBitsetToIDs(cols);
        return new Cluster<BiclusterModel>((DBIDs)rowIDs, new BiclusterModel(colIDs));
    }

    protected double valueAt(int row, int col) {
        this.iter.seek(row);
        return ((NumberVector)this.relation.get(this.iter)).doubleValue(col);
    }

    @Deprecated
    protected DBID getRowDBID(int row) {
        return this.rowIDs.get(row);
    }

    protected int[] colsBitsetToIDs(long[] cols) {
        int[] colIDs = new int[BitsUtil.cardinality(cols)];
        int colsIndex = 0;
        int cpos = 0;
        for (int clpos = 0; clpos < cols.length; ++clpos) {
            long clong = cols[clpos];
            if (clong == 0L) {
                cpos += 64;
                continue;
            }
            int j = 0;
            while (j < 64) {
                if ((clong & 1L) == 1L) {
                    colIDs[colsIndex] = cpos;
                    ++colsIndex;
                }
                ++j;
                ++cpos;
                clong >>>= 1;
            }
        }
        return colIDs;
    }

    protected ArrayDBIDs rowsBitsetToIDs(long[] rows) {
        ArrayModifiableDBIDs rowIDs = DBIDUtil.newArray(BitsUtil.cardinality(rows));
        DBIDArrayIter iter = this.rowIDs.iter();
        block0: for (int rlpos = 0; rlpos < rows.length; ++rlpos) {
            long rlong = rows[rlpos];
            if (rlong == 0L) {
                iter.advance(64);
                continue;
            }
            int i = 0;
            while (i < 64) {
                if (!iter.valid()) break block0;
                if ((rlong & 1L) == 1L) {
                    rowIDs.add(iter);
                }
                ++i;
                rlong >>>= 1;
                iter.advance();
            }
        }
        return rowIDs;
    }

    protected int getRowDim() {
        return this.rowIDs.size();
    }

    protected int getColDim() {
        return this.colDim;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Relation<V> getRelation() {
        return this.relation;
    }
}

