/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering;

import de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering.AbstractBiclustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.BiclusterWithInversionsModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="Y. Cheng, G. M. Church", title="Biclustering of expression data", booktitle="Proc. 8th Int. Conf. on Intelligent Systems for Molecular Biology (ISMB)", url="http://www.aaai.org/Library/ISMB/2000/ismb00-010.php", bibkey="DBLP:conf/ismb/ChengC00")
public class ChengAndChurch<V extends NumberVector>
extends AbstractBiclustering<V, BiclusterWithInversionsModel> {
    private static final Logging LOG = Logging.getLogger(ChengAndChurch.class);
    private static final int MIN_COLUMN_REMOVE_THRESHOLD = 100;
    private static final int MIN_ROW_REMOVE_THRESHOLD = 100;
    private double delta;
    private double alpha;
    private int n;
    private boolean useinverted = true;
    private Distribution dist;

    public ChengAndChurch(double delta, double alpha, int n, Distribution dist) {
        this.delta = delta;
        this.alpha = alpha;
        this.n = n;
        this.dist = dist;
    }

    @Override
    public Clustering<BiclusterWithInversionsModel> biclustering() {
        BiclusterWithInversionsModel model;
        double[][] mat = RelationUtil.relationAsMatrix(this.relation, this.rowIDs);
        BiclusterCandidate cand = new BiclusterCandidate(this.getRowDim(), this.getColDim());
        Clustering<BiclusterWithInversionsModel> result = new Clustering<BiclusterWithInversionsModel>("Cheng-and-Church", "Cheng and Church Biclustering");
        HashSetModifiableDBIDs noise = DBIDUtil.newHashSet(this.relation.getDBIDs());
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Extracting Cluster", this.n, LOG) : null;
        for (int i = 0; i < this.n; ++i) {
            cand.reset();
            this.multipleNodeDeletion(mat, cand);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 2: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
            }
            this.singleNodeDeletion(mat, cand);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 1: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
            }
            this.nodeAddition(mat, cand);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 3: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
            }
            cand.maskMatrix(mat, this.dist);
            model = new BiclusterWithInversionsModel(this.colsBitsetToIDs(cand.cols), this.rowsBitsetToIDs(cand.irow));
            ArrayDBIDs cids = this.rowsBitsetToIDs(cand.rows);
            noise.removeDBIDs(cids);
            result.addToplevelCluster(new Cluster<BiclusterWithInversionsModel>((DBIDs)cids, model));
            if (LOG.isVerbose()) {
                LOG.verbose("Score of bicluster " + (i + 1) + ": " + cand.residue + "\n");
                LOG.verbose("Number of rows: " + cand.rowcard + "\n");
                LOG.verbose("Number of columns: " + cand.colcard + "\n");
            }
            LOG.incrementProcessed(prog);
        }
        if (!noise.isEmpty()) {
            long[] allcols = BitsUtil.ones(this.getColDim());
            model = new BiclusterWithInversionsModel(this.colsBitsetToIDs(allcols), DBIDUtil.EMPTYDBIDS);
            result.addToplevelCluster(new Cluster<BiclusterWithInversionsModel>(noise, true, model));
        }
        LOG.ensureCompleted(prog);
        return result;
    }

    private void singleNodeDeletion(final double[][] mat, final BiclusterCandidate cand) {
        while (cand.residue > this.delta && (cand.colcard > 2 || cand.rowcard > 2)) {
            final double[] max = new double[]{Double.NEGATIVE_INFINITY};
            final int[] best = new int[]{-1, -1};
            if (cand.rowcard > 2) {
                cand.visitColumn(mat, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                        assert (selrow);
                        double rowResidue = cand.computeRowResidue(mat, row, false);
                        if (max[0] < rowResidue) {
                            max[0] = rowResidue;
                            best[0] = row;
                        }
                        return false;
                    }
                });
            }
            if (cand.colcard > 2) {
                cand.visitRow(mat, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                        assert (selcol);
                        double colResidue = cand.computeColResidue(mat, col);
                        if (max[0] < colResidue) {
                            max[0] = colResidue;
                            best[1] = col;
                        }
                        return false;
                    }
                });
            }
            if (best[1] >= 0) {
                cand.selectColumn(best[1], false);
            } else {
                assert (best[0] >= 0);
                cand.selectRow(best[0], false);
            }
            cand.updateRowAndColumnMeans(mat, false);
            cand.computeMeanSquaredDeviation(mat);
            if (!LOG.isDebuggingFine()) continue;
            LOG.debugFine("Residue in Alg 1: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
        }
    }

    private void multipleNodeDeletion(final double[][] mat, final BiclusterCandidate cand) {
        cand.updateRowAndColumnMeans(mat, false);
        cand.computeMeanSquaredDeviation(mat);
        while (cand.residue > this.delta) {
            double alphaResidue;
            final boolean[] modified = new boolean[]{false, false};
            if (cand.rowcard > 100) {
                alphaResidue = this.alpha * cand.residue;
                cand.visitColumn(mat, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                        assert (selrow);
                        if (cand.computeRowResidue(mat, row, false) > alphaResidue) {
                            cand.selectRow(row, false);
                            modified[0] = true;
                        }
                        return cand.rowcard > 100;
                    }
                });
                if (modified[0]) {
                    cand.updateRowAndColumnMeans(mat, false);
                    cand.computeMeanSquaredDeviation(mat);
                }
            }
            if (cand.colcard > 100) {
                alphaResidue = this.alpha * cand.residue;
                cand.visitRow(mat, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                        assert (selcol);
                        if (cand.computeColResidue(mat, col) > alphaResidue) {
                            cand.selectColumn(col, false);
                            modified[1] = true;
                        }
                        return cand.colcard > 100;
                    }
                });
                if (modified[1]) {
                    cand.updateRowAndColumnMeans(mat, false);
                    cand.computeMeanSquaredDeviation(mat);
                }
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Residue in Alg 2: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
            }
            if (modified[0] || modified[1]) continue;
            break;
        }
    }

    private void nodeAddition(final double[][] mat, final BiclusterCandidate cand) {
        boolean[] added;
        cand.updateRowAndColumnMeans(mat, true);
        cand.computeMeanSquaredDeviation(mat);
        do {
            added = new boolean[]{false, false};
            cand.visitRow(mat, 0, 2, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (!selcol);
                    if (cand.computeColResidue(mat, col) <= cand.residue) {
                        cand.selectColumn(col, true);
                        added[0] = true;
                    }
                    return false;
                }
            });
            if (added[0]) {
                cand.updateRowAndColumnMeans(mat, true);
                cand.computeMeanSquaredDeviation(mat);
            }
            cand.visitColumn(mat, 0, 2, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (!selrow);
                    if (cand.computeRowResidue(mat, row, false) <= cand.residue) {
                        cand.selectRow(row, true);
                        added[1] = true;
                    }
                    return false;
                }
            });
            if (this.useinverted) {
                cand.visitColumn(mat, 0, 2, new CellVisitor(){

                    @Override
                    public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                        assert (!selrow);
                        if (cand.computeRowResidue(mat, row, true) <= cand.residue) {
                            cand.selectRow(row, true);
                            cand.invertRow(row, true);
                            added[1] = true;
                        }
                        return false;
                    }
                });
            }
            if (!added[1]) continue;
            cand.updateRowAndColumnMeans(mat, true);
            cand.computeMeanSquaredDeviation(mat);
            if (!LOG.isDebuggingFine()) continue;
            LOG.debugFine("Residue in Alg 3: " + cand.residue + " " + cand.rowcard + "x" + cand.colcard);
        } while (added[0] || added[1]);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIST_ID = new OptionID("chengandchurch.replacement", "Distribution of replacement values when masking found clusters.");
        public static final OptionID DELTA_ID = new OptionID("chengandchurch.delta", "Threshold value to determine the maximal acceptable score (mean squared residue) of a bicluster.");
        public static final OptionID ALPHA_ID = new OptionID("chengandchurch.alpha", "Parameter for multiple node deletion to accelerate the algorithm.");
        public static final OptionID N_ID = new OptionID("chengandchurch.n", "The number of biclusters to be found.");
        private double delta;
        private double alpha;
        private int n;
        private Distribution dist;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter distP;
            DoubleParameter alphaP;
            IntParameter nP;
            super.makeOptions(config);
            DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(deltaP)) {
                this.delta = deltaP.doubleValue();
            }
            if (config.grab(nP = (IntParameter)new IntParameter(N_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.n = nP.intValue();
            }
            if (config.grab(alphaP = (DoubleParameter)new DoubleParameter(ALPHA_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE))) {
                this.alpha = alphaP.doubleValue();
            }
            if (config.grab(distP = new ObjectParameter(DIST_ID, (Class<?>)Distribution.class, UniformDistribution.class))) {
                this.dist = (Distribution)distP.instantiateClass(config);
            }
        }

        @Override
        protected ChengAndChurch<V> makeInstance() {
            return new ChengAndChurch(this.delta, this.alpha, this.n, this.dist);
        }
    }

    protected static class BiclusterCandidate {
        int rowcard;
        int colcard;
        double[] rowM;
        double[] colM;
        long[] rows;
        long[] irow;
        long[] cols;
        double allM;
        double residue;
        private final CellVisitor MEANVISITOR = new CellVisitor(){

            @Override
            public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                if (selcol) {
                    int n = row;
                    rowM[n] = rowM[n] + val;
                }
                if (selrow) {
                    int n = col;
                    colM[n] = colM[n] + val;
                }
                if (selcol && selrow) {
                    allM += val;
                }
                return false;
            }
        };

        protected BiclusterCandidate(int rows, int cols) {
            this.rows = BitsUtil.ones(rows);
            this.irow = BitsUtil.zero(rows);
            this.rowcard = rows;
            this.rowM = new double[rows];
            this.cols = BitsUtil.ones(cols);
            this.colcard = cols;
            this.colM = new double[cols];
        }

        protected void reset() {
            this.rows = BitsUtil.ones(this.rowM.length);
            this.rowcard = this.rowM.length;
            this.cols = BitsUtil.ones(this.colM.length);
            this.colcard = this.colM.length;
            BitsUtil.zeroI(this.irow);
        }

        protected void visitAll(double[][] mat, int mode, CellVisitor visitor) {
            int rpos = 0;
            for (int rlpos = 0; rlpos < this.rows.length; ++rlpos) {
                long rlong = this.rows[rlpos];
                if (mode == 1 && rlong == 0L || mode == 2 && rlong == -1L) {
                    rpos += 64;
                    continue;
                }
                int i = 0;
                while (i < 64 && rpos < this.rowM.length) {
                    boolean rselected;
                    boolean bl = rselected = (rlong & 1L) == 1L;
                    if (!(mode == 1 && !rselected || mode == 2 && rselected)) {
                        int cpos = 0;
                        for (int clpos = 0; clpos < this.cols.length; ++clpos) {
                            long clong = this.cols[clpos];
                            if (mode == 1 && clong == 0L || mode == 2 && clong == -1L) {
                                cpos += 64;
                                continue;
                            }
                            int j = 0;
                            while (j < 64 && cpos < this.colM.length) {
                                boolean stop;
                                boolean cselected;
                                boolean bl2 = cselected = (clong & 1L) == 1L;
                                if (!(mode == 1 && !cselected || mode == 2 && cselected || !(stop = visitor.visit(mat[rpos][cpos], rpos, cpos, rselected, cselected)))) {
                                    return;
                                }
                                ++j;
                                ++cpos;
                                clong >>>= 1;
                            }
                        }
                    }
                    ++i;
                    ++rpos;
                    rlong >>>= 1;
                }
            }
        }

        protected void visitColumn(double[][] mat, int col, int mode, CellVisitor visitor) {
            boolean cselected = BitsUtil.get(this.cols, col);
            int rpos = 0;
            for (int rlpos = 0; rlpos < this.rows.length; ++rlpos) {
                long rlong = this.rows[rlpos];
                if (mode == 1 && rlong == 0L) {
                    rpos += 64;
                    continue;
                }
                if (mode == 2 && rlong == -1L) {
                    rpos += 64;
                    continue;
                }
                int i = 0;
                while (i < 64 && rpos < this.rowM.length) {
                    boolean stop;
                    boolean rselected;
                    boolean bl = rselected = (rlong & 1L) == 1L;
                    if (!(mode == 1 && !rselected || mode == 2 && rselected || !(stop = visitor.visit(mat[rpos][col], rpos, col, rselected, cselected)))) {
                        return;
                    }
                    ++i;
                    ++rpos;
                    rlong >>>= 1;
                }
            }
        }

        protected void visitRow(double[][] mat, int row, int mode, CellVisitor visitor) {
            boolean rselected = BitsUtil.get(this.rows, row);
            double[] rowdata = mat[row];
            int cpos = 0;
            for (int clpos = 0; clpos < this.cols.length; ++clpos) {
                long clong = this.cols[clpos];
                if (mode == 1 && clong == 0L) {
                    cpos += 64;
                    continue;
                }
                if (mode == 2 && clong == -1L) {
                    cpos += 64;
                    continue;
                }
                int j = 0;
                while (j < 64 && cpos < this.colM.length) {
                    boolean stop;
                    boolean cselected;
                    boolean bl = cselected = (clong & 1L) == 1L;
                    if (!(mode == 1 && !cselected || mode == 2 && cselected || !(stop = visitor.visit(rowdata[cpos], row, cpos, rselected, cselected)))) {
                        return;
                    }
                    ++j;
                    ++cpos;
                    clong >>>= 1;
                }
            }
        }

        protected double updateRowAndColumnMeans(double[][] mat, boolean all) {
            int mode = all ? 0 : 1;
            Arrays.fill(this.rowM, 0.0);
            Arrays.fill(this.colM, 0.0);
            this.allM = 0.0;
            this.visitAll(mat, mode, this.MEANVISITOR);
            this.visitColumn(mat, 0, mode, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    int n = row;
                    rowM[n] = rowM[n] / (double)colcard;
                    return false;
                }
            });
            this.visitRow(mat, 0, mode, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    int n = col;
                    colM[n] = colM[n] / (double)rowcard;
                    return false;
                }
            });
            this.allM /= (double)(this.colcard * this.rowcard);
            return this.allM;
        }

        protected double computeMeanSquaredDeviation(double[][] mat) {
            final Mean msr = new Mean();
            this.visitAll(mat, 1, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (selrow && selcol);
                    double v = val - rowM[row] - colM[col] + allM;
                    msr.put(v * v);
                    return false;
                }
            });
            this.residue = msr.getMean();
            return this.residue;
        }

        protected double computeRowResidue(double[][] mat, int row, final boolean rowinverted) {
            final Mean rowResidue = new Mean();
            this.visitRow(mat, row, 1, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (selcol);
                    double rowMean = rowM[row];
                    double colMean = colM[col];
                    double v = (!rowinverted ? val - rowMean : rowMean - val) - colMean + allM;
                    rowResidue.put(v * v);
                    return false;
                }
            });
            return rowResidue.getMean();
        }

        protected double computeColResidue(double[][] mat, int col) {
            final double bias = this.colM[col] - this.allM;
            final Mean colResidue = new Mean();
            this.visitColumn(mat, col, 1, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (selrow);
                    double rowMean = rowM[row];
                    double v = val - rowMean - bias;
                    colResidue.put(v * v);
                    return false;
                }
            });
            return colResidue.getMean();
        }

        protected void maskMatrix(final double[][] mat, final Distribution replacement) {
            this.visitAll(mat, 1, new CellVisitor(){

                @Override
                public boolean visit(double val, int row, int col, boolean selrow, boolean selcol) {
                    assert (selrow && selcol);
                    mat[row][col] = replacement.nextRandom();
                    return false;
                }
            });
        }

        protected void selectColumn(int cnum, boolean set) {
            if (set) {
                BitsUtil.setI(this.cols, cnum);
                ++this.colcard;
            } else {
                BitsUtil.clearI(this.cols, cnum);
                --this.colcard;
            }
        }

        protected void selectRow(int rnum, boolean set) {
            if (set) {
                BitsUtil.setI(this.rows, rnum);
                ++this.rowcard;
            } else {
                BitsUtil.clearI(this.rows, rnum);
                --this.rowcard;
            }
        }

        protected void invertRow(int rnum, boolean b) {
            BitsUtil.setI(this.irow, rnum);
        }
    }

    protected static interface CellVisitor {
        public static final int ALL = 0;
        public static final int SELECTED = 1;
        public static final int NOT_SELECTED = 2;

        public boolean visit(double var1, int var3, int var4, boolean var5, boolean var6);
    }
}

