/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.COPACNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.DimensionModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="COPAC: COrrelation PArtition Clustering")
@Description(value="Partitions a database according to the correlation dimension of its objects and performs a clustering algorithm over the partitions.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM Int. Conf. on Data Mining (SDM'07)", url="https://doi.org/10.1137/1.9781611972771.37", bibkey="DBLP:conf/sdm/AchtertBKKZ07")
public class COPAC<V extends NumberVector>
extends AbstractAlgorithm<Clustering<DimensionModel>>
implements ClusteringAlgorithm<Clustering<DimensionModel>> {
    private static final Logging LOG = Logging.getLogger(COPAC.class);
    Settings settings;

    public COPAC(Settings settings) {
        this.settings = settings;
    }

    public Clustering<DimensionModel> run(Database database, Relation<V> relation) {
        COPACNeighborPredicate.Instance npred = new COPACNeighborPredicate<V>(this.settings).instantiate(database, relation);
        MinPtsCorePredicate.Instance cpred = new MinPtsCorePredicate(this.settings.minpts).instantiate(database);
        Clustering<Model> dclusters = new GeneralizedDBSCAN.Instance<DBIDs>(npred, cpred, false).run();
        Clustering<DimensionModel> result = new Clustering<DimensionModel>("COPAC clustering", "copac-clustering");
        It<Cluster<Model>> iter = dclusters.iterToplevelClusters();
        while (iter.valid()) {
            Cluster<Model> clus = iter.get();
            if (clus.size() > 0) {
                int dim = npred.dimensionality(clus.getIDs().iter());
                DimensionModel model = new DimensionModel(dim);
                result.addToplevelCluster(new Cluster<DimensionModel>(clus.getIDs(), model));
            }
            iter.advance();
        }
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("copac.knn", "Number of neighbors to use for PCA.");
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            DoubleParameter epsilonP;
            ObjectParameter filterP;
            ObjectParameter pcaP;
            this.settings = new Settings();
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.settings.k = kP.intValue();
            }
            if (config.grab(pcaP = new ObjectParameter(PCARunner.Parameterizer.PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                this.settings.pca = (PCARunner)pcaP.instantiateClass(config);
            }
            if (config.grab(filterP = new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class))) {
                this.settings.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
            if (config.grab(epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.settings.epsilon = epsilonP.doubleValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.settings.minpts = minptsP.intValue();
            }
        }

        @Override
        protected COPAC<V> makeInstance() {
            return new COPAC(this.settings);
        }
    }

    public static class Settings {
        public int k;
        public PCARunner pca;
        public EigenPairFilter filter;
        public double epsilon;
        public int minpts;
    }
}

