/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.ERiCNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.FirstNEigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="ERiC: Exploring Relationships among Correlation Clusters")
@Description(value="Performs the DBSCAN algorithm on the data using a special distance function taking into account correlations among attributes and builds a hierarchy that allows multiple inheritance from the correlation clustering result.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="On Exploring Complex Relationships of Correlation Clusters", booktitle="Proc. 19th Int. Conf. Scientific and Statistical Database Management (SSDBM 2007)", url="https://doi.org/10.1109/SSDBM.2007.21", bibkey="DBLP:conf/ssdbm/AchtertBKKZ07")
public class ERiC<V extends NumberVector>
extends AbstractAlgorithm<Clustering<CorrelationModel>>
implements ClusteringAlgorithm<Clustering<CorrelationModel>> {
    private static final Logging LOG = Logging.getLogger(ERiC.class);
    private Settings settings;

    public ERiC(Settings settings) {
        this.settings = settings;
    }

    public Clustering<CorrelationModel> run(Database database, Relation<V> relation) {
        int dim = RelationUtil.dimensionality(relation);
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
        LOG.beginStep(stepprog, 1, "Preprocessing local correlation dimensionalities and partitioning data");
        ERiCNeighborPredicate.Instance npred = new ERiCNeighborPredicate<V>(this.settings).instantiate(database, relation);
        MinPtsCorePredicate.Instance cpred = new MinPtsCorePredicate(this.settings.minpts).instantiate(database);
        Clustering<Model> copacResult = new GeneralizedDBSCAN.Instance<DBIDs>(npred, cpred, false).run();
        LOG.beginStep(stepprog, 2, "Extract correlation clusters");
        List<List<Cluster<CorrelationModel>>> clusterMap = this.extractCorrelationClusters(copacResult, relation, dim, npred);
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder("Step 2: Extract correlation clusters...");
            for (int corrDim = 0; corrDim < clusterMap.size(); ++corrDim) {
                List<Cluster<CorrelationModel>> correlationClusters = clusterMap.get(corrDim);
                msg.append("\n\ncorrDim ").append(corrDim);
                for (Cluster<CorrelationModel> cluster : correlationClusters) {
                    msg.append("\n  cluster ").append(cluster).append(", ids: ").append(cluster.getIDs().size());
                }
            }
            LOG.debugFine(msg.toString());
        }
        if (LOG.isVerbose()) {
            int clusters = 0;
            for (List<Cluster<CorrelationModel>> correlationClusters : clusterMap) {
                clusters += correlationClusters.size();
            }
            LOG.verbose(clusters + " clusters extracted.");
        }
        LOG.beginStep(stepprog, 3, "Building hierarchy");
        Clustering<CorrelationModel> clustering = new Clustering<CorrelationModel>("ERiC clustering", "eric-clustering");
        this.buildHierarchy(clustering, clusterMap, npred);
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder("Step 3: Build hierarchy");
            for (int corrDim = 0; corrDim < clusterMap.size(); ++corrDim) {
                List<Cluster<CorrelationModel>> correlationClusters = clusterMap.get(corrDim);
                for (Cluster<CorrelationModel> cluster : correlationClusters) {
                    msg.append("\n  cluster ").append(cluster).append(", ids: ").append(cluster.getIDs().size());
                    It<Cluster<CorrelationModel>> iter = clustering.getClusterHierarchy().iterParents(cluster);
                    while (iter.valid()) {
                        msg.append("\n   parent ").append(iter.get());
                        iter.advance();
                    }
                    iter = clustering.getClusterHierarchy().iterChildren(cluster);
                    while (iter.valid()) {
                        msg.append("\n   child ").append(iter.get());
                        iter.advance();
                    }
                }
            }
            LOG.debugFine(msg.toString());
        }
        LOG.setCompleted(stepprog);
        for (Cluster<CorrelationModel> rc : clusterMap.get(clusterMap.size() - 1)) {
            clustering.addToplevelCluster(rc);
        }
        return clustering;
    }

    private List<List<Cluster<CorrelationModel>>> extractCorrelationClusters(Clustering<Model> dbscanResult, Relation<V> relation, int dimensionality, ERiCNeighborPredicate.Instance npred) {
        ArrayList<List<Cluster<CorrelationModel>>> clusterMap = new ArrayList<List<Cluster<CorrelationModel>>>();
        for (int i = 0; i <= dimensionality; ++i) {
            clusterMap.add(new ArrayList());
        }
        Cluster<Model> noise = null;
        for (Cluster<Model> clus : dbscanResult.getAllClusters()) {
            int dim;
            DBIDs group = clus.getIDs();
            int n = dim = clus.isNoise() ? dimensionality : npred.dimensionality(clus.getIDs().iter());
            if (dim < dimensionality) {
                FirstNEigenPairFilter filter = new FirstNEigenPairFilter(dim);
                List correlationClusters = (List)clusterMap.get(dim);
                PCAResult epairs = this.settings.pca.processIds(group, relation);
                int numstrong = filter.filter(epairs.getEigenvalues());
                PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), numstrong, 1.0, 0.0);
                double[] centroid = Centroid.make(relation, group).getArrayRef();
                Cluster<CorrelationModel> correlationCluster = new Cluster<CorrelationModel>("[" + dim + "_" + correlationClusters.size() + "]", group, new CorrelationModel(pcares, centroid));
                correlationClusters.add(correlationCluster);
                continue;
            }
            if (noise == null) {
                noise = clus;
                continue;
            }
            HashSetModifiableDBIDs merged = DBIDUtil.newHashSet(noise.getIDs());
            merged.addDBIDs(clus.getIDs());
            noise.setIDs(merged);
        }
        if (noise != null && noise.size() > 0) {
            List correlationClusters = (List)clusterMap.get(dimensionality);
            FirstNEigenPairFilter filter = new FirstNEigenPairFilter(dimensionality);
            PCAResult epairs = this.settings.pca.processIds(noise.getIDs(), relation);
            int numstrong = filter.filter(epairs.getEigenvalues());
            PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), numstrong, 1.0, 0.0);
            double[] centroid = Centroid.make(relation, noise.getIDs()).getArrayRef();
            Cluster<CorrelationModel> correlationCluster = new Cluster<CorrelationModel>("[noise]", noise.getIDs(), new CorrelationModel(pcares, centroid));
            correlationClusters.add(correlationCluster);
        }
        for (int i = dimensionality; i > 0 && ((List)clusterMap.get(i)).isEmpty(); --i) {
            clusterMap.remove(i);
        }
        return clusterMap;
    }

    private void buildHierarchy(Clustering<CorrelationModel> clustering, List<List<Cluster<CorrelationModel>>> clusterMap, ERiCNeighborPredicate.Instance npred) {
        StringBuilder msg = LOG.isDebuggingFine() ? new StringBuilder() : null;
        Hierarchy<Cluster<CorrelationModel>> hier = clustering.getClusterHierarchy();
        int lambda_max = clusterMap.size() - 1;
        for (int childCorrDim = 0; childCorrDim < lambda_max; ++childCorrDim) {
            List<Cluster<CorrelationModel>> children = clusterMap.get(childCorrDim);
            if (msg != null) {
                msg.append("\ncorrdim ").append(childCorrDim);
            }
            for (Cluster<CorrelationModel> child : children) {
                for (int parentCorrDim = childCorrDim + 1; parentCorrDim <= lambda_max; ++parentCorrDim) {
                    List<Cluster<CorrelationModel>> parents = clusterMap.get(parentCorrDim);
                    for (Cluster<CorrelationModel> parent : parents) {
                        int subspaceDim_parent = parent.getModel().getPCAResult().getCorrelationDimension();
                        if (subspaceDim_parent == lambda_max && hier.numParents(child) == 0) {
                            clustering.addChildCluster(parent, child);
                            if (msg == null) continue;
                            msg.append('\n').append(parent).append(" is parent of ").append(child);
                            continue;
                        }
                        boolean dist = npred.weakNeighbors((double[])parent.getModel().getPrototype(), (double[])child.getModel().getPrototype(), parent.getModel().getPCAResult(), child.getModel().getPCAResult());
                        if (dist || hier.numParents(child) != 0 && this.isParent(npred, parent, hier.iterParents(child))) continue;
                        clustering.addChildCluster(parent, child);
                        if (msg == null) continue;
                        msg.append('\n').append(parent).append(" is parent of ").append(child);
                    }
                }
            }
        }
        if (msg != null) {
            LOG.debugFine(msg.toString());
        }
    }

    private boolean isParent(ERiCNeighborPredicate.Instance npred, Cluster<CorrelationModel> parent, It<Cluster<CorrelationModel>> iter) {
        StringBuilder msg;
        StringBuilder stringBuilder = msg = LOG.isDebugging() ? new StringBuilder() : null;
        while (iter.valid()) {
            Cluster<CorrelationModel> child = iter.get();
            if (parent.getModel().getPCAResult().getCorrelationDimension() == child.getModel().getPCAResult().getCorrelationDimension()) {
                return false;
            }
            boolean dist = npred.weakNeighbors((double[])parent.getModel().getPrototype(), (double[])child.getModel().getPrototype(), parent.getModel().getPCAResult(), child.getModel().getPCAResult());
            if (msg != null) {
                msg.append("\ndist(").append(child).append(" - ").append(parent).append(") = ").append(dist);
            }
            if (dist) {
                if (msg != null) {
                    LOG.debugFine(msg);
                }
                return true;
            }
            iter.advance();
        }
        if (msg != null) {
            LOG.debugFine(msg.toString());
        }
        return false;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("eric.k", "Number of neighbors to use for PCA.");
        public static final OptionID DELTA_ID = new OptionID("ericdf.delta", "Threshold for approximate linear dependency: the strong eigenvectors of q are approximately linear dependent from the strong eigenvectors p if the following condition holds for all stroneg eigenvectors q_i of q (lambda_q < lambda_p): q_i' * M^check_p * q_i <= delta^2.");
        public static final OptionID TAU_ID = new OptionID("ericdf.tau", "Threshold for the maximum distance between two approximately linear dependent subspaces of two objects p and q (lambda_q < lambda_p) before considering them as parallel.");
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            DoubleParameter tauP;
            DoubleParameter deltaP;
            ObjectParameter filterP;
            ObjectParameter pcaP;
            this.settings = new Settings();
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.settings.k = kP.intValue();
            }
            if (config.grab(pcaP = new ObjectParameter(PCARunner.Parameterizer.PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                this.settings.pca = (PCARunner)pcaP.instantiateClass(config);
            }
            if (config.grab(filterP = new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class))) {
                this.settings.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
            if (config.grab(deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.settings.delta = deltaP.doubleValue();
            }
            if (config.grab(tauP = (DoubleParameter)new DoubleParameter(TAU_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.settings.tau = tauP.doubleValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.settings.minpts = minptsP.intValue();
            }
        }

        @Override
        protected ERiC<V> makeInstance() {
            return new ERiC(this.settings);
        }
    }

    public static class Settings {
        public int k;
        public PCARunner pca;
        public EigenPairFilter filter;
        public double delta;
        public double tau;
        public int minpts;
    }
}

