/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.FourCCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.FourCNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.LimitEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="4C: Computing Correlation Connected Clusters")
@Description(value="4C identifies local subgroups of data objects sharing a uniform correlation. The algorithm is based on a combination of PCA and density-based clustering (DBSCAN).")
@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourC<V extends NumberVector>
extends GeneralizedDBSCAN {
    private static final Logging LOG = Logging.getLogger(FourC.class);

    public FourC(Settings settings) {
        super(new FourCNeighborPredicate(settings), new FourCCorePredicate(settings), false);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.settings = config.tryInstantiate(Settings.class);
        }

        @Override
        protected FourC<O> makeInstance() {
            return new FourC(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public boolean absolute = false;
        public double delta = 0.0;
        public double kappa = 50.0;
        public int lambda = Integer.MAX_VALUE;
        public int minpts;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final double DEFAULT_DELTA = 0.1;
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            @Override
            protected void makeOptions(Parameterization config) {
                this.settings = new Settings();
                this.configEpsilon(config);
                this.configMinPts(config);
                this.configDelta(config);
                this.configKappa(config);
                this.configLambda(config);
            }

            protected void configEpsilon(Parameterization config) {
                DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (config.grab(epsilonP)) {
                    this.settings.epsilon = epsilonP.doubleValue();
                }
            }

            protected void configMinPts(Parameterization config) {
                IntParameter minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(minptsP)) {
                    this.settings.minpts = minptsP.intValue();
                }
            }

            protected void configDelta(Parameterization config) {
                Flag absoluteF = new Flag(LimitEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_ABSOLUTE);
                if (config.grab(absoluteF)) {
                    this.settings.absolute = absoluteF.isTrue();
                }
                DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(LimitEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_DELTA).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (!this.settings.absolute) {
                    deltaP.setDefaultValue((Object)0.1);
                } else {
                    deltaP.addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
                }
                if (config.grab(deltaP)) {
                    this.settings.delta = deltaP.doubleValue();
                }
            }

            protected void configKappa(Parameterization config) {
                DoubleParameter kappaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0);
                if (config.grab(kappaP)) {
                    this.settings.kappa = kappaP.doubleValue();
                }
            }

            protected void configLambda(Parameterization config) {
                IntParameter lambdaP = (IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true);
                if (config.grab(lambdaP)) {
                    this.settings.lambda = lambdaP.intValue();
                }
            }

            @Override
            protected Object makeInstance() {
                return this.settings;
            }
        }
    }
}

