/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.FilteredLocalPCAIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.KNNQueryFilteredPCAIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Arrays;
import java.util.Comparator;

@Title(value="Mining Hierarchies of Correlation Clusters")
@Description(value="Algorithm for detecting hierarchies of correlation clusters.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Peer Kr\u00f6ger, Arthur Zimek", title="Mining Hierarchies of Correlation Clusters", booktitle="Proc. Int. Conf. on Scientific and Statistical Database Management (SSDBM'06)", url="https://doi.org/10.1109/SSDBM.2006.35", bibkey="DBLP:conf/ssdbm/AchtertBKZ06")
public class HiCO<V extends NumberVector>
extends GeneralizedOPTICS<V, CorrelationClusterOrder> {
    private static final Logging LOG = Logging.getLogger(HiCO.class);
    public static final double DEFAULT_DELTA = 0.25;
    public static final double DEFAULT_ALPHA = 0.85;
    private KNNQueryFilteredPCAIndex.Factory<V> indexfactory;
    double deltasq;
    int mu;

    public HiCO(KNNQueryFilteredPCAIndex.Factory<V> indexfactory, int mu, double delta) {
        this.mu = mu;
        this.indexfactory = indexfactory;
        this.deltasq = delta * delta;
    }

    public CorrelationClusterOrder run(Database db, Relation<V> relation) {
        if (this.mu >= relation.size()) {
            throw new AbortException("Parameter mu is chosen unreasonably large. This won't yield meaningful results.");
        }
        return new Instance(db, relation).run();
    }

    public int correlationDistance(PCAFilteredResult pca1, PCAFilteredResult pca2, int dimensionality) {
        double[][] v1t = VMath.copy(pca1.getEigenvectors());
        double[][] v1t_strong = pca1.getStrongEigenvectors();
        int lambda1 = pca1.getCorrelationDimension();
        double[][] v2t = VMath.copy(pca2.getEigenvectors());
        double[][] v2t_strong = pca2.getStrongEigenvectors();
        int lambda2 = pca2.getCorrelationDimension();
        double[][] m1_czech = pca1.dissimilarityMatrix();
        for (int i = 0; i < v2t_strong.length; ++i) {
            double[] v2_i = v2t_strong[i];
            double distsq = VMath.squareSum(v2_i) - VMath.transposeTimesTimes(v2_i, m1_czech, v2_i);
            if (lambda1 >= dimensionality || !(distsq > this.deltasq)) continue;
            this.adjust(v1t, v2_i, lambda1++);
            double[] e1_czech_d = new double[v1t.length];
            Arrays.fill(e1_czech_d, 0, lambda1, 1.0);
            m1_czech = VMath.transposeDiagonalTimes(v1t, e1_czech_d, v1t);
        }
        double[][] m2_czech = pca2.dissimilarityMatrix();
        for (int i = 0; i < v1t_strong.length; ++i) {
            double[] v1_i = v1t_strong[i];
            double distsq = VMath.squareSum(v1_i) - VMath.transposeTimesTimes(v1_i, m2_czech, v1_i);
            if (lambda2 >= dimensionality || !(distsq > this.deltasq)) continue;
            this.adjust(v2t, v1_i, lambda2++);
            double[] e2_czech_d = new double[v1t.length];
            Arrays.fill(e2_czech_d, 0, lambda2, 1.0);
            m2_czech = VMath.transposeDiagonalTimes(v2t, e2_czech_d, v2t);
        }
        return Math.max(lambda1, lambda2);
    }

    private void adjust(double[][] v, double[] vector, int corrDim) {
        double[] sum = new double[v.length];
        for (int k = 0; k < corrDim; ++k) {
            VMath.plusTimesEquals(sum, v[k], VMath.transposeTimes(vector, v[k]));
        }
        v[corrDim] = VMath.normalizeEquals(VMath.minus(vector, sum));
    }

    @Override
    public int getMinPts() {
        return this.mu;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.indexfactory.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MU_ID = new OptionID("hico.mu", "Specifies the smoothing factor. The mu-nearest neighbor is used to compute the correlation reachability of an object.");
        public static final OptionID K_ID = new OptionID("hico.k", "Optional parameter to specify the number of nearest neighbors considered in the PCA. If this parameter is not set, k is set to the value of parameter mu.");
        public static final OptionID DELTA_ID = new OptionID("hico.delta", "Threshold of a distance between a vector q and a given space that indicates that q adds a new dimension to the space.");
        public static final OptionID ALPHA_ID = new OptionID("hico.alpha", "The threshold for 'strong' eigenvectors: the 'strong' eigenvectors explain a portion of at least alpha of the total variance.");
        int mu = -1;
        double delta;
        private KNNQueryFilteredPCAIndex.Factory<V> indexfactory;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter kP;
            super.makeOptions(config);
            IntParameter muP = (IntParameter)new IntParameter(MU_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(muP)) {
                this.mu = (Integer)muP.getValue();
            }
            int k = config.grab(kP = (IntParameter)((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)) ? (Integer)kP.getValue() : this.mu;
            DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID, 0.25).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(deltaP)) {
                this.delta = deltaP.doubleValue();
            }
            DoubleParameter alphaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.85).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
            double alpha = 0.85;
            if (config.grab(alphaP)) {
                alpha = alphaP.doubleValue();
            }
            ListParameterization params = new ListParameterization();
            params.addParameter(KNNQueryFilteredPCAIndex.Factory.Parameterizer.K_ID, (Object)k);
            params.addParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Object)new PercentageEigenPairFilter(alpha));
            ChainedParameterization chain = new ChainedParameterization(params, config);
            chain.errorsTo(config);
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(KNNQueryFilteredPCAIndex.Factory.class);
            this.indexfactory = (KNNQueryFilteredPCAIndex.Factory)chain.tryInstantiate(cls);
        }

        @Override
        protected HiCO<V> makeInstance() {
            return new HiCO<V>(this.indexfactory, this.mu, this.delta);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, CorrelationClusterOrder> {
        private FilteredLocalPCAIndex<V> index;
        private Relation<V> relation;
        private ArrayModifiableDBIDs clusterOrder;
        private WritableIntegerDataStore correlationValue;
        private WritableIntegerDataStore tmpCorrelation;
        private WritableDoubleDataStore tmpDistance;
        private ArrayModifiableDBIDs tmpIds;
        Comparator<DBIDRef> tmpcomp;

        public Instance(Database db, Relation<V> relation) {
            super(db, relation);
            this.tmpcomp = new Comparator<DBIDRef>(){

                @Override
                public int compare(DBIDRef o1, DBIDRef o2) {
                    int c = Integer.compare(Instance.this.tmpCorrelation.intValue(o2), Instance.this.tmpCorrelation.intValue(o1));
                    return c != 0 ? c : Double.compare(Instance.this.tmpDistance.doubleValue(o1), Instance.this.tmpDistance.doubleValue(o2));
                }
            };
            DBIDs ids = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(ids.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(ids, 30, Integer.MAX_VALUE);
            this.tmpIds = DBIDUtil.newArray(ids);
            this.tmpCorrelation = DataStoreUtil.makeIntegerStorage(ids, 3);
            this.tmpDistance = DataStoreUtil.makeDoubleStorage(ids, 3);
        }

        @Override
        public CorrelationClusterOrder run() {
            this.index = HiCO.this.indexfactory.instantiate(this.relation);
            return (CorrelationClusterOrder)super.run();
        }

        @Override
        protected CorrelationClusterOrder buildResult() {
            return new CorrelationClusterOrder("HiCO Cluster Order", "hico-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue);
        }

        @Override
        protected void initialDBID(DBIDRef id) {
            this.correlationValue.put(id, Integer.MAX_VALUE);
        }

        @Override
        protected void expandDBID(DBIDRef id) {
            this.clusterOrder.add(id);
            PCAFilteredResult pca1 = this.index.getLocalProjection(id);
            NumberVector dv1 = (NumberVector)this.relation.get(id);
            int dim = dv1.getDimensionality();
            DBIDArrayMIter iter = this.tmpIds.iter();
            while (iter.valid()) {
                if (this.processedIDs.contains(iter)) {
                    this.tmpCorrelation.putInt(iter, 0);
                } else {
                    PCAFilteredResult pca2 = this.index.getLocalProjection(iter);
                    NumberVector dv2 = (NumberVector)this.relation.get(iter);
                    this.tmpCorrelation.putInt(iter, HiCO.this.correlationDistance(pca1, pca2, dim));
                    this.tmpDistance.putDouble(iter, EuclideanDistanceFunction.STATIC.distance(dv1, dv2));
                }
                iter.advance();
            }
            this.tmpIds.sort(this.tmpcomp);
            double coredist = this.tmpDistance.doubleValue(iter.seek(HiCO.this.mu - 1));
            iter.seek(0);
            while (iter.valid()) {
                int curcorr;
                int prevcorr;
                if (!this.processedIDs.contains(iter) && (prevcorr = this.correlationValue.intValue(iter)) >= (curcorr = this.tmpCorrelation.intValue(iter))) {
                    double prevdist;
                    double currdist = MathUtil.max(this.tmpDistance.doubleValue(iter), coredist);
                    if (prevcorr != curcorr || !((prevdist = this.reachability.doubleValue(iter)) <= currdist)) {
                        this.correlationValue.putInt(iter, curcorr);
                        this.reachability.putDouble(iter, currdist);
                        this.predecessor.putDBID(iter, id);
                        if (prevcorr == Integer.MAX_VALUE) {
                            this.candidates.add(iter);
                        }
                    }
                }
                iter.advance();
            }
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            int c = Integer.compare(this.correlationValue.intValue(o2), this.correlationValue.intValue(o1));
            return c != 0 ? c : super.compare(o1, o2);
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

