/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.CASHIntervalSplit;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class CASHInterval
extends HyperBoundingBox
implements Comparable<CASHInterval> {
    private static final Logging LOG = Logging.getLogger(CASHInterval.class);
    private static final long serialVersionUID = 1L;
    private static int ID = 0;
    private final int intervalID = ++ID;
    private int level;
    private double d_min;
    private double d_max;
    private ModifiableDBIDs ids;
    private int maxSplitDimension;
    private CASHInterval leftChild;
    private CASHInterval rightChild;
    private CASHIntervalSplit split;

    public CASHInterval() {
    }

    public CASHInterval(double[] min, double[] max, CASHIntervalSplit split, ModifiableDBIDs ids, int maxSplitDimension, int level, double d_min, double d_max) {
        super(min, max);
        this.split = split;
        this.ids = ids;
        this.maxSplitDimension = maxSplitDimension;
        this.level = level;
        this.d_min = d_min;
        this.d_max = d_max;
    }

    public ModifiableDBIDs getIDs() {
        return this.ids;
    }

    public void removeIDs(DBIDs ids2) {
        this.ids.removeDBIDs(ids2);
    }

    public int numObjects() {
        return this.ids.size();
    }

    @Override
    public String toString() {
        return super.toString() + ", ids: " + this.ids.size() + ", d_min: " + this.d_min + ", d_max " + this.d_max;
    }

    public int priority() {
        return this.numObjects();
    }

    public int getMaxSplitDimension() {
        return this.maxSplitDimension;
    }

    public int getLevel() {
        return this.level;
    }

    public CASHInterval getLeftChild() {
        return this.leftChild;
    }

    public CASHInterval getRightChild() {
        return this.rightChild;
    }

    public double getD_min() {
        return this.d_min;
    }

    public double getD_max() {
        return this.d_max;
    }

    @Override
    public int compareTo(CASHInterval other) {
        if (this.equals(other)) {
            return 0;
        }
        int c = Integer.compare(this.priority(), other.priority());
        c = c == 0 ? Integer.compare(this.level, other.level) : c;
        c = c == 0 ? Integer.compare(this.maxSplitDimension, other.maxSplitDimension) : c;
        return c == 0 ? Integer.compare(other.intervalID, this.intervalID) : c;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.intervalID == ((CASHInterval)o).intervalID;
    }

    @Override
    public int hashCode() {
        return this.intervalID;
    }

    public boolean hasChildren() {
        return this.leftChild != null || this.rightChild != null;
    }

    public void split() {
        if (this.hasChildren()) {
            return;
        }
        boolean issplit = this.maxSplitDimension >= this.getDimensionality() - 1;
        int childLevel = issplit ? this.level + 1 : this.level;
        int splitDim = issplit ? 0 : this.maxSplitDimension + 1;
        double splitPoint = this.getMin(splitDim) + (this.getMax(splitDim) - this.getMin(splitDim)) * 0.5;
        for (int i = 0; i < 2; ++i) {
            double[] min = SpatialUtil.getMin(this);
            double[] max = SpatialUtil.getMax(this);
            if (i == 0) {
                min[splitDim] = splitPoint;
            } else {
                max[splitDim] = splitPoint;
            }
            ModifiableDBIDs childIDs = this.split.determineIDs(this.getIDs(), new HyperBoundingBox(min, max), this.d_min, this.d_max);
            if (childIDs == null) continue;
            if (i == 0) {
                this.rightChild = new CASHInterval(min, max, this.split, childIDs, splitDim, childLevel, this.d_min, this.d_max);
                continue;
            }
            this.leftChild = new CASHInterval(min, max, this.split, childIDs, splitDim, childLevel, this.d_min, this.d_max);
        }
        if (LOG.isDebuggingFine()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Child level ").append(childLevel).append(",  split Dim   ").append(splitDim);
            if (this.leftChild != null) {
                msg.append("\nleft   ").append(this.leftChild);
            }
            if (this.rightChild != null) {
                msg.append("\nright   ").append(this.rightChild);
            }
            LOG.fine(msg.toString());
        }
    }
}

