/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.ParameterizationFunction;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.util.HashMap;
import java.util.Map;

public class CASHIntervalSplit {
    private Relation<ParameterizationFunction> database;
    private Map<HyperBoundingBox, Map<DBID, Double>> f_minima;
    private Map<HyperBoundingBox, Map<DBID, Double>> f_maxima;
    private int minPts;
    private static final Logging LOG = Logging.getLogger(CASHIntervalSplit.class);

    public CASHIntervalSplit(Relation<ParameterizationFunction> database, int minPts) {
        this.database = database;
        this.minPts = minPts;
        this.f_minima = new HashMap<HyperBoundingBox, Map<DBID, Double>>();
        this.f_maxima = new HashMap<HyperBoundingBox, Map<DBID, Double>>();
    }

    public ModifiableDBIDs determineIDs(DBIDs superSetIDs, HyperBoundingBox interval, double d_min, double d_max) {
        StringBuilder msg;
        StringBuilder stringBuilder = msg = LOG.isDebugging() ? new StringBuilder() : null;
        if (msg != null) {
            msg.append("interval ").append(interval);
        }
        HashSetModifiableDBIDs childIDs = DBIDUtil.newHashSet(superSetIDs.size());
        Map<DBID, Double> minima = this.f_minima.get(interval);
        Map<DBID, Double> maxima = this.f_maxima.get(interval);
        if (minima == null || maxima == null) {
            minima = new HashMap<DBID, Double>();
            this.f_minima.put(interval, minima);
            maxima = new HashMap<DBID, Double>();
            this.f_maxima.put(interval, maxima);
        }
        DBIDIter iter = superSetIDs.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            Double f_min = minima.get(id);
            Double f_max = maxima.get(id);
            if (f_min == null) {
                ParameterizationFunction f = this.database.get(id);
                HyperBoundingBox minMax = f.determineAlphaMinMax(interval);
                f_min = f.function(SpatialUtil.getMin(minMax));
                f_max = f.function(SpatialUtil.getMax(minMax));
                minima.put(id, f_min);
                maxima.put(id, f_max);
            }
            if (msg != null) {
                msg.append("\n\nf_min ").append(f_min);
                msg.append("\nf_max ").append(f_max);
                msg.append("\nd_min ").append(d_min);
                msg.append("\nd_max ").append(d_max);
            }
            if (f_min - f_max > 1.0E-10) {
                throw new IllegalArgumentException("Houston, we have a problem: f_min > f_max! \nf_min[" + FormatUtil.format(SpatialUtil.centroid(interval)) + "] = " + f_min + "\nf_max[" + FormatUtil.format(SpatialUtil.centroid(interval)) + "] = " + f_max + "\nf " + this.database.get(id));
            }
            if (f_min <= d_max && f_max >= d_min) {
                childIDs.add(id);
                if (msg != null) {
                    msg.append("\nid ").append(id).append(" appended");
                }
            } else if (msg != null) {
                msg.append("\nid ").append(id).append(" NOT appended");
            }
            iter.advance();
        }
        if (msg != null) {
            msg.append("\nchildIds ").append(childIDs.size());
            LOG.debugFine(msg.toString());
        }
        if (childIDs.size() < this.minPts) {
            return null;
        }
        return childIDs;
    }
}

