/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import net.jafama.FastMath;

public class ParameterizationFunction {
    public static final double DELTA = 1.0E-10;
    private double[] alphaExtremum;
    private ExtremumType extremumType;
    private NumberVector vec;

    public ParameterizationFunction(NumberVector vec) {
        this.vec = vec;
        this.determineGlobalExtremum();
    }

    public double function(double[] alpha) {
        int d = this.vec.getDimensionality();
        if (alpha.length != d - 1) {
            throw new IllegalArgumentException("Parameter alpha must have a dimensionality of " + (d - 1) + ", read: " + alpha.length);
        }
        double result = 0.0;
        for (int i = 0; i < d; ++i) {
            double alpha_i = i == d - 1 ? 0.0 : alpha[i];
            result += this.vec.doubleValue(i) * ParameterizationFunction.sinusProduct(0, i, alpha) * FastMath.cos(alpha_i);
        }
        return result;
    }

    public HyperBoundingBox determineAlphaMinMax(HyperBoundingBox interval) {
        int dim = this.vec.getDimensionality();
        if (interval.getDimensionality() != dim - 1) {
            throw new IllegalArgumentException("Interval needs to have dimensionality d=" + (dim - 1) + ", read: " + interval.getDimensionality());
        }
        if (this.extremumType.equals((Object)ExtremumType.CONSTANT)) {
            double[] centroid = SpatialUtil.centroid(interval);
            return new HyperBoundingBox(centroid, centroid);
        }
        double[] alpha_min = new double[dim - 1];
        double[] alpha_max = new double[dim - 1];
        if (SpatialUtil.contains((SpatialComparable)interval, this.alphaExtremum)) {
            if (this.extremumType.equals((Object)ExtremumType.MINIMUM)) {
                alpha_min = this.alphaExtremum;
                for (int d = dim - 2; d >= 0; --d) {
                    alpha_max[d] = this.determineAlphaMax(d, alpha_max, interval);
                }
            } else {
                alpha_max = this.alphaExtremum;
                for (int d = dim - 2; d >= 0; --d) {
                    alpha_min[d] = this.determineAlphaMin(d, alpha_min, interval);
                }
            }
        } else {
            for (int d = dim - 2; d >= 0; --d) {
                alpha_min[d] = this.determineAlphaMin(d, alpha_min, interval);
                alpha_max[d] = this.determineAlphaMax(d, alpha_max, interval);
            }
        }
        return new HyperBoundingBox(alpha_min, alpha_max);
    }

    private ExtremumType extremumType(int n, double[] alpha_extreme, HyperBoundingBox interval) {
        if (n == alpha_extreme.length - 1) {
            return this.extremumType;
        }
        double[] alpha_extreme_l = new double[alpha_extreme.length];
        double[] alpha_extreme_r = new double[alpha_extreme.length];
        double[] alpha_extreme_c = new double[alpha_extreme.length];
        System.arraycopy(alpha_extreme, 0, alpha_extreme_l, 0, alpha_extreme.length);
        System.arraycopy(alpha_extreme, 0, alpha_extreme_r, 0, alpha_extreme.length);
        System.arraycopy(alpha_extreme, 0, alpha_extreme_c, 0, alpha_extreme.length);
        double[] centroid = SpatialUtil.centroid(interval);
        for (int i = 0; i < n; ++i) {
            alpha_extreme_l[i] = centroid[i];
            alpha_extreme_r[i] = centroid[i];
            alpha_extreme_c[i] = centroid[i];
        }
        double intervalLength = interval.getMax(n) - interval.getMin(n);
        alpha_extreme_l[n] = Math.random() * intervalLength + interval.getMin(n);
        alpha_extreme_r[n] = Math.random() * intervalLength + interval.getMin(n);
        double f_c = this.function(alpha_extreme_c);
        double f_l = this.function(alpha_extreme_l);
        double f_r = this.function(alpha_extreme_r);
        if (f_l < f_c && (f_r < f_c || Math.abs(f_r - f_c) < 1.0E-10)) {
            return ExtremumType.MAXIMUM;
        }
        if (f_r < f_c && (f_l < f_c || Math.abs(f_l - f_c) < 1.0E-10)) {
            return ExtremumType.MAXIMUM;
        }
        if (f_l > f_c && (f_r > f_c || Math.abs(f_r - f_c) < 1.0E-10)) {
            return ExtremumType.MINIMUM;
        }
        if (f_r > f_c && (f_l > f_c || Math.abs(f_l - f_c) < 1.0E-10)) {
            return ExtremumType.MINIMUM;
        }
        if (Math.abs(f_l - f_c) < 1.0E-10 && Math.abs(f_r - f_c) < 1.0E-10) {
            return ExtremumType.CONSTANT;
        }
        throw new IllegalArgumentException("Houston, we have a problem!\n" + this + "\nf_l " + f_l + "\nf_c " + f_c + "\nf_r " + f_r + "\np " + this.vec + "\nalpha   " + FormatUtil.format(alpha_extreme_c) + "\nalpha_l " + FormatUtil.format(alpha_extreme_l) + "\nalpha_r " + FormatUtil.format(alpha_extreme_r) + "\nn " + n);
    }

    private double determineAlphaMin(int n, double[] alpha_min, HyperBoundingBox interval) {
        double alpha_n = this.extremum_alpha_n(n, alpha_min);
        double lower = interval.getMin(n);
        double upper = interval.getMax(n);
        double[] alpha_extreme = new double[alpha_min.length];
        System.arraycopy(alpha_min, n, alpha_extreme, n, alpha_extreme.length - n);
        alpha_extreme[n] = alpha_n;
        ExtremumType type = this.extremumType(n, alpha_extreme, interval);
        if (type.equals((Object)ExtremumType.MINIMUM) || type.equals((Object)ExtremumType.CONSTANT)) {
            if (lower <= alpha_n && alpha_n <= upper) {
                return alpha_n;
            }
            if (alpha_n < lower) {
                return lower;
            }
            if (alpha_n <= upper) {
                throw new IllegalStateException("Should never happen!");
            }
            return upper;
        }
        if (lower <= alpha_n && alpha_n <= upper) {
            if (alpha_n - lower <= upper - alpha_n) {
                return upper;
            }
            return lower;
        }
        if (alpha_n < lower) {
            return upper;
        }
        if (alpha_n <= upper) {
            throw new IllegalStateException("Should never happen!");
        }
        return lower;
    }

    private double determineAlphaMax(int n, double[] alpha_max, HyperBoundingBox interval) {
        double alpha_n = this.extremum_alpha_n(n, alpha_max);
        double lower = interval.getMin(n);
        double upper = interval.getMax(n);
        double[] alpha_extreme = new double[alpha_max.length];
        System.arraycopy(alpha_max, n, alpha_extreme, n, alpha_extreme.length - n);
        alpha_extreme[n] = alpha_n;
        ExtremumType type = this.extremumType(n, alpha_extreme, interval);
        if (type.equals((Object)ExtremumType.MINIMUM) || type.equals((Object)ExtremumType.CONSTANT)) {
            if (lower <= alpha_n && alpha_n <= upper) {
                if (alpha_n - lower <= upper - alpha_n) {
                    return upper;
                }
                return lower;
            }
            if (alpha_n < lower) {
                return upper;
            }
            if (alpha_n <= upper) {
                throw new IllegalStateException("Should never happen!");
            }
            return lower;
        }
        if (lower <= alpha_n && alpha_n <= upper) {
            return alpha_n;
        }
        if (alpha_n < lower) {
            return lower;
        }
        if (alpha_n <= upper) {
            throw new IllegalStateException("Should never happen!");
        }
        return upper;
    }

    public double[] getGlobalAlphaExtremum() {
        return this.alphaExtremum;
    }

    public double getGlobalExtremum() {
        return this.function(this.alphaExtremum);
    }

    public ExtremumType getGlobalExtremumType() {
        return this.extremumType;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int offset) {
        StringBuilder result = new StringBuilder();
        for (int d = 0; d < this.vec.getDimensionality(); ++d) {
            if (d != 0) {
                result.append(" + \n");
                FormatUtil.whitespace(result, offset);
            }
            result.append(this.vec.doubleValue(d));
            for (int j = 0; j < d; ++j) {
                result.append(" * sin(a_").append(j + 1).append(')');
            }
            if (d == this.vec.getDimensionality() - 1) continue;
            result.append(" * cos(a_").append(d + 1).append(')');
        }
        return result.toString();
    }

    public static double sinusProduct(int start, int end, double[] alpha) {
        double result = 1.0;
        for (int j = start; j < end; ++j) {
            result *= FastMath.sin(alpha[j]);
        }
        return result;
    }

    private void determineGlobalExtremum() {
        this.alphaExtremum = new double[this.vec.getDimensionality() - 1];
        for (int n = this.alphaExtremum.length - 1; n >= 0; --n) {
            this.alphaExtremum[n] = this.extremum_alpha_n(n, this.alphaExtremum);
            if (!Double.isNaN(this.alphaExtremum[n])) continue;
            throw new IllegalStateException("Houston, we have a problem!\n" + this + "\n" + this.vec + "\n" + FormatUtil.format(this.alphaExtremum));
        }
        this.determineGlobalExtremumType();
    }

    private void determineGlobalExtremumType() {
        double f = this.function(this.alphaExtremum);
        double[] alpha_1 = new double[this.alphaExtremum.length];
        double[] alpha_2 = new double[this.alphaExtremum.length];
        for (int i = 0; i < this.alphaExtremum.length; ++i) {
            alpha_1[i] = Math.random() * Math.PI;
            alpha_2[i] = Math.random() * Math.PI;
        }
        double f1 = this.function(alpha_1);
        double f2 = this.function(alpha_2);
        if (f1 < f && f2 < f) {
            this.extremumType = ExtremumType.MAXIMUM;
        } else if (f1 > f && f2 > f) {
            this.extremumType = ExtremumType.MINIMUM;
        } else if (Math.abs(f1 - f) < 1.0E-10 && Math.abs(f2 - f) < 1.0E-10) {
            this.extremumType = ExtremumType.CONSTANT;
        } else {
            throw new IllegalStateException("Houston, we have a problem:\n" + this + "\nextremum at " + FormatUtil.format(this.alphaExtremum) + "\nf  " + f + "\nf1 " + f1 + "\nf2 " + f2);
        }
    }

    private double extremum_alpha_n(int n, double[] alpha) {
        if (this.vec.doubleValue(n) == 0.0) {
            return 1.5707963267948966;
        }
        double tan = 0.0;
        for (int j = n + 1; j < this.vec.getDimensionality(); ++j) {
            double alpha_j = j == this.vec.getDimensionality() - 1 ? 0.0 : alpha[j];
            tan += this.vec.doubleValue(j) * ParameterizationFunction.sinusProduct(n + 1, j, alpha) * FastMath.cos(alpha_j);
        }
        double alpha_n = Math.atan(tan /= this.vec.doubleValue(n));
        if (alpha_n < 0.0) {
            alpha_n = Math.PI + alpha_n;
        }
        return alpha_n;
    }

    public double[] getColumnVector() {
        return this.vec.toArray();
    }

    public int getDimensionality() {
        return this.vec.getDimensionality();
    }

    public static enum ExtremumType {
        MINIMUM,
        MAXIMUM,
        CONSTANT;

    }
}

