/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;
import net.jafama.FastMath;

public class DiagonalGaussianModel
implements EMClusterModel<EMModel> {
    private static final double SINGULARITY_CHEAT = 1.0E-9;
    double[] mean;
    double[] variances;
    double[] nmea;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double[] priordiag;

    public DiagonalGaussianModel(double weight, double[] mean) {
        this(weight, mean, null);
    }

    public DiagonalGaussianModel(double weight, double[] mean, double[] variances) {
        this.weight = weight;
        int dim = mean.length;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.logNormDet = FastMath.log(weight) - 0.5 * this.logNorm;
        this.nmea = new double[dim];
        if (variances == null) {
            this.variances = new double[dim];
            Arrays.fill(variances, 1.0);
        } else {
            this.variances = variances;
            this.priordiag = VMath.copy(variances);
        }
        this.wsum = 0.0;
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        VMath.clear(this.mean);
        VMath.clear(this.variances);
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        int i;
        assert (vec.getDimensionality() == this.mean.length);
        double nwsum = this.wsum + wei;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = vec.doubleValue(i) - this.mean[i];
            double rval = delta * wei / nwsum;
            this.nmea[i] = this.mean[i] + rval;
        }
        for (i = 0; i < this.mean.length; ++i) {
            double vi = vec.doubleValue(i);
            int n = i;
            this.variances[n] = this.variances[n] + (vi - this.nmea[i]) * (vi - this.mean[i]) * wei;
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        int dim = this.variances.length;
        this.weight = weight;
        double logDet = 0.0;
        if (prior > 0.0 && this.priordiag != null) {
            double nu = dim + 2;
            double f2 = 1.0 / (this.wsum + prior * (nu + (double)dim + 2.0));
            for (int i = 0; i < dim; ++i) {
                this.variances[i] = (this.variances[i] + prior * this.priordiag[i]) * f2;
                logDet += FastMath.log(this.variances[i]);
            }
        } else if (this.wsum > 0.0) {
            double s = 1.0 / this.wsum;
            for (int i = 0; i < dim; ++i) {
                double v = this.variances[i];
                this.variances[i] = v > 0.0 ? v * s : 1.0E-9;
                logDet += FastMath.log(this.variances[i]);
            }
        }
        this.logNormDet = FastMath.log(weight) - 0.5 * (this.logNorm + logDet);
    }

    public double mahalanobisDistance(NumberVector vec) {
        double agg = 0.0;
        for (int i = 0; i < this.variances.length; ++i) {
            double diff = vec.doubleValue(i) - this.mean[i];
            agg += diff / this.variances[i] * diff;
        }
        return agg;
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, VMath.diagonal(this.variances));
    }
}

