/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CholeskyDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class MultivariateGaussianModel
implements EMClusterModel<EMModel> {
    private static Logging LOG = Logging.getLogger(MultivariateGaussianModel.class);
    private static final double SINGULARITY_CHEAT = 1.0E-10;
    double[] mean;
    double[][] covariance;
    CholeskyDecomposition chol;
    double[] nmea;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double prior = 0.0;
    double[][] priormatrix;

    public MultivariateGaussianModel(double weight, double[] mean) {
        this(weight, mean, null);
    }

    public MultivariateGaussianModel(double weight, double[] mean, double[][] covariance) {
        this.weight = weight;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.nmea = new double[mean.length];
        this.covariance = covariance != null ? covariance : VMath.identity(mean.length, mean.length);
        this.priormatrix = covariance != null ? VMath.copy(covariance) : (double[][])null;
        this.wsum = 0.0;
        this.updateCholesky();
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        VMath.clear(this.mean);
        VMath.clear(this.covariance);
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        int i;
        int dim = this.mean.length;
        assert (vec.getDimensionality() == dim);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        double nwsum = this.wsum + wei;
        double f = wei / nwsum;
        for (i = 0; i < dim; ++i) {
            double delta = vec.doubleValue(i) - this.mean[i];
            this.nmea[i] = this.mean[i] + delta * f;
        }
        for (i = 0; i < dim; ++i) {
            double vi = vec.doubleValue(i);
            double delta_i = vi - this.nmea[i];
            double[] cov_i = this.covariance[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                cov_i[n] = cov_i[n] + delta_i * (vec.doubleValue(j) - this.mean[j]) * wei;
            }
            int n = i;
            cov_i[n] = cov_i[n] + delta_i * (vi - this.mean[i]) * wei;
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        double f;
        this.weight = weight;
        this.prior = prior;
        int dim = this.covariance.length;
        double d = f = this.wsum > Double.MIN_NORMAL && this.wsum < Double.POSITIVE_INFINITY ? 1.0 / this.wsum : 1.0;
        assert (f > 0.0) : this.wsum;
        if (prior > 0.0 && this.priormatrix != null) {
            double nu = dim + 2;
            double f2 = 1.0 / (this.wsum + prior * (nu + (double)dim + 2.0));
            for (int i = 0; i < dim; ++i) {
                double[] row_i = this.covariance[i];
                double[] pri_i = this.priormatrix[i];
                for (int j = 0; j < i; ++j) {
                    this.covariance[j][i] = row_i[j] = (row_i[j] + prior * pri_i[j]) * f2;
                }
                row_i[i] = (row_i[i] + prior * pri_i[i]) * f2;
            }
        } else {
            int i = 0;
            while (i < dim) {
                double[] row_i = this.covariance[i];
                for (int j = 0; j < i; ++j) {
                    int n = j;
                    double d2 = row_i[n] * f;
                    row_i[n] = d2;
                    this.covariance[j][i] = d2;
                }
                int n = i++;
                row_i[n] = row_i[n] * f;
            }
        }
        this.updateCholesky();
        if (prior > 0.0 && this.priormatrix == null) {
            this.priormatrix = VMath.copy(this.covariance);
        }
    }

    private void updateCholesky() {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.covariance);
        if (!chol.isSPD()) {
            int i;
            double s = 0.0;
            for (i = 0; i < this.covariance.length; ++i) {
                s += this.covariance[i][i];
            }
            s *= 1.0E-10 / (double)this.covariance.length;
            i = 0;
            while (i < this.covariance.length) {
                double[] dArray = this.covariance[i];
                int n = i++;
                dArray[n] = dArray[n] + s;
            }
            chol = new CholeskyDecomposition(this.covariance);
        }
        if (!chol.isSPD()) {
            LOG.warning("A cluster has degenerated, likely due to lack of variance in a subset of the data or too extreme magnitude differences.\nThe algorithm will likely stop without converging, and fail to produce a good fit.");
            chol = this.chol != null ? this.chol : chol;
        }
        this.chol = chol;
        this.logNormDet = FastMath.log(this.weight) - 0.5 * this.logNorm - this.getHalfLogDeterminant(this.chol);
    }

    private double getHalfLogDeterminant(CholeskyDecomposition chol) {
        double[][] l = chol.getL();
        double logdet = FastMath.log(l[0][0]);
        for (int i = 1; i < l.length; ++i) {
            logdet += FastMath.log(l[i][i]);
        }
        return logdet;
    }

    public double mahalanobisDistance(NumberVector vec) {
        return VMath.squareSum(this.chol.solveLInplace(VMath.minusEquals(vec.toArray(), this.mean)));
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, this.covariance);
    }
}

