/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class SphericalGaussianModel
implements EMClusterModel<EMModel> {
    double[] mean;
    double variance;
    double[] nmea;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double priorvar;

    public SphericalGaussianModel(double weight, double[] mean) {
        this(weight, mean, 1.0);
    }

    public SphericalGaussianModel(double weight, double[] mean, double var) {
        this.weight = weight;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.logNormDet = FastMath.log(weight) - 0.5 * this.logNorm;
        this.nmea = new double[mean.length];
        this.variance = var;
        this.priorvar = var;
        this.wsum = 0.0;
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        this.variance = 0.0;
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        int i;
        assert (vec.getDimensionality() == this.mean.length);
        double nwsum = this.wsum + wei;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = vec.doubleValue(i) - this.mean[i];
            double rval = delta * wei / nwsum;
            this.nmea[i] = this.mean[i] + rval;
        }
        for (i = 0; i < this.mean.length; ++i) {
            double vi = vec.doubleValue(i);
            this.variance += (vi - this.nmea[i]) * (vi - this.mean[i]) * wei;
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        int dim = this.mean.length;
        this.weight = weight;
        double logDet = 0.0;
        if (prior > 0.0) {
            double nu = dim + 2;
            this.variance /= (double)dim;
            this.variance = (this.variance + prior * this.priorvar) / (this.wsum + prior * (nu + (double)dim + 2.0));
            logDet = FastMath.log(this.variance);
        } else if (this.wsum > 0.0) {
            logDet = FastMath.log(this.variance /= this.wsum * (double)dim);
        }
        this.logNormDet = FastMath.log(weight) - 0.5 * this.logNorm - logDet;
    }

    public double mahalanobisDistance(double[] vec) {
        double agg = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            double diff = vec[i] - this.mean[i];
            agg += diff / this.variance * diff;
        }
        return agg;
    }

    public double mahalanobisDistance(NumberVector vec) {
        double agg = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double diff = vec.doubleValue(i) - this.mean[i];
            agg += diff / this.variance * diff;
        }
        return agg;
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, VMath.timesEquals(VMath.identity(this.nmea.length, this.nmea.length), this.variance));
    }
}

