/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.AbstractEMModelFactory;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.SphericalGaussianModel;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class SphericalGaussianModelFactory<V extends NumberVector>
extends AbstractEMModelFactory<V, EMModel> {
    public SphericalGaussianModelFactory(KMeansInitialization initializer) {
        super(initializer);
    }

    @Override
    public List<SphericalGaussianModel> buildInitialModels(Database database, Relation<V> relation, int k, NumberVectorDistanceFunction<? super V> df) {
        int d;
        double[][] initialMeans = this.initializer.chooseInitialMeans(database, relation, k, df);
        assert (initialMeans.length == k);
        int dim = RelationUtil.dimensionality(relation);
        MeanVariance[] mvs = MeanVariance.newArray(dim);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            NumberVector v = (NumberVector)relation.get(it);
            for (d = 0; d < dim; ++d) {
                mvs[d].put(v.doubleValue(d));
            }
            it.advance();
        }
        double varsum = 0.0;
        for (d = 0; d < dim; ++d) {
            varsum += mvs[d].getSampleVariance();
        }
        varsum *= FastMath.pow(k, -2.0 / (double)dim);
        ArrayList<SphericalGaussianModel> models = new ArrayList<SphericalGaussianModel>(k);
        for (double[] nv : initialMeans) {
            models.add(new SphericalGaussianModel(1.0 / (double)k, nv, varsum));
        }
        return models;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractEMModelFactory.Parameterizer<V> {
        @Override
        protected SphericalGaussianModelFactory<V> makeInstance() {
            return new SphericalGaussianModelFactory(this.initializer);
        }
    }
}

