/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.AbstractEMModelFactory;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.TextbookMultivariateGaussianModel;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class TextbookMultivariateGaussianModelFactory<V extends NumberVector>
extends AbstractEMModelFactory<V, EMModel> {
    public TextbookMultivariateGaussianModelFactory(KMeansInitialization initializer) {
        super(initializer);
    }

    @Override
    public List<TextbookMultivariateGaussianModel> buildInitialModels(Database database, Relation<V> relation, int k, NumberVectorDistanceFunction<? super V> df) {
        double[][] initialMeans = this.initializer.chooseInitialMeans(database, relation, k, df);
        assert (initialMeans.length == k);
        double[][] covmat = CovarianceMatrix.make(relation).destroyToSampleMatrix();
        VMath.timesEquals(covmat, FastMath.pow(k, -2.0 / (double)covmat.length));
        ArrayList<TextbookMultivariateGaussianModel> models = new ArrayList<TextbookMultivariateGaussianModel>(k);
        for (double[] nv : initialMeans) {
            models.add(new TextbookMultivariateGaussianModel(1.0 / (double)k, nv, VMath.copy(covmat)));
        }
        return models;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractEMModelFactory.Parameterizer<V> {
        @Override
        protected TextbookMultivariateGaussianModelFactory<V> makeInstance() {
            return new TextbookMultivariateGaussianModelFactory(this.initializer);
        }
    }
}

