/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRangeQueryNeighborPredicate<O, M, N>
implements NeighborPredicate<N> {
    protected double epsilon;
    protected DistanceFunction<? super O> distFunc;

    public AbstractRangeQueryNeighborPredicate(double epsilon, DistanceFunction<? super O> distFunc) {
        this.epsilon = epsilon;
        this.distFunc = distFunc;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distFunc.getInputTypeRestriction();
    }

    public DataStore<M> preprocess(Class<? super M> modelcls, Relation<O> relation, RangeQuery<O> query) {
        WritableDataStore<M> storage = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, modelcls);
        Duration time = this.getLogger().newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), this.getLogger()) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            DoubleDBIDList neighbors = query.getRangeForDBID(iditer, this.epsilon);
            storage.put(iditer, this.computeLocalModel(iditer, neighbors, relation));
            this.getLogger().incrementProcessed(progress);
            iditer.advance();
        }
        this.getLogger().ensureCompleted(progress);
        this.getLogger().statistics(time.end());
        return storage;
    }

    protected abstract M computeLocalModel(DBIDRef var1, DoubleDBIDList var2, Relation<O> var3);

    abstract Logging getLogger();

    public static abstract class Parameterizer<O>
    extends AbstractParameterizer {
        double epsilon;
        DistanceFunction<O> distfun = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.configDistance(config);
            this.configEpsilon(config);
        }

        protected void configDistance(Parameterization config) {
            ObjectParameter distanceP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceP)) {
                this.distfun = (DistanceFunction)distanceP.instantiateClass(config);
            }
        }

        protected void configEpsilon(Parameterization config) {
            DoubleParameter epsilonP = new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID);
            if (config.grab(epsilonP)) {
                this.epsilon = (Double)epsilonP.getValue();
            }
        }
    }

    public static abstract class Instance<N, M>
    implements NeighborPredicate.Instance<N> {
        protected DBIDs ids;
        protected DataStore<M> storage;

        public Instance(DBIDs ids, DataStore<M> storage) {
            this.ids = ids;
            this.storage = storage;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }
    }
}

