/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.COPAC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM Int. Conf. on Data Mining (SDM'07)", url="https://doi.org/10.1137/1.9781611972771.37", bibkey="DBLP:conf/sdm/AchtertBKKZ07")
public class COPACNeighborPredicate<V extends NumberVector>
implements NeighborPredicate<COPACModel> {
    private static final Logging LOG = Logging.getLogger(COPACNeighborPredicate.class);
    protected final COPAC.Settings settings;
    protected double epsilonsq;

    public COPACNeighborPredicate(COPAC.Settings settings) {
        this.settings = settings;
        this.epsilonsq = settings.epsilon * settings.epsilon;
    }

    @Override
    public NeighborPredicate.Instance<COPACModel> instantiate(Database database) {
        return this.instantiate(database, database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]));
    }

    public Instance instantiate(Database database, Relation<V> relation) {
        DistanceQuery<NumberVector> dq = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> knnq = database.getKNNQuery(dq, this.settings.k);
        WritableDataStore<COPACModel> storage = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, COPACModel.class);
        Duration time = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList ref = knnq.getKNNForDBID(iditer, this.settings.k);
            storage.put(iditer, this.computeLocalModel(iditer, ref, relation));
            LOG.incrementProcessed(progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.statistics(time.end());
        return new Instance(relation.getDBIDs(), (DataStore<COPACModel>)storage);
    }

    protected COPACModel computeLocalModel(DBIDRef id, DoubleDBIDList knnneighbors, Relation<V> relation) {
        PCAResult epairs = this.settings.pca.processIds(knnneighbors, relation);
        int pdim = this.settings.filter.filter(epairs.getEigenvalues());
        PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), pdim, 1.0, 0.0);
        double[][] mat = pcares.similarityMatrix();
        double[] vecP = ((NumberVector)relation.get(id)).toArray();
        if (pdim == vecP.length) {
            return new COPACModel(pdim, DBIDUtil.EMPTYDBIDS);
        }
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet();
        DBIDIter neighbor = relation.iterDBIDs();
        while (neighbor.valid()) {
            double[] diff = VMath.minusEquals(((NumberVector)relation.get(neighbor)).toArray(), vecP);
            double cdistP = VMath.transposeTimesTimes(diff, mat, diff);
            if (cdistP <= this.epsilonsq) {
                survivors.add(neighbor);
            }
            neighbor.advance();
        }
        return new COPACModel(pdim, survivors);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<COPACModel> getOutputType() {
        return new SimpleTypeInformation<COPACModel>(COPACModel.class);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected COPAC.Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            this.settings = config.tryInstantiate(COPAC.Settings.class);
        }

        @Override
        protected COPACNeighborPredicate<V> makeInstance() {
            return new COPACNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<COPACModel, COPACModel> {
        public Instance(DBIDs ids, DataStore<COPACModel> storage) {
            super(ids, storage);
        }

        @Override
        public COPACModel getNeighbors(DBIDRef reference) {
            COPACModel asymmetric = (COPACModel)this.storage.get(reference);
            if (asymmetric.ids.size() <= 0) {
                return asymmetric;
            }
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                COPACModel nmodel = (COPACModel)this.storage.get(neighbor);
                if (nmodel.cdim == asymmetric.cdim && nmodel.ids.contains(reference)) {
                    ids.add(neighbor);
                }
                neighbor.advance();
            }
            return new COPACModel(asymmetric.cdim, ids);
        }

        @Override
        public DBIDIter iterDBIDs(COPACModel neighbors) {
            return neighbors.ids.iter();
        }

        public int dimensionality(DBIDRef id) {
            return ((COPACModel)this.storage.get((DBIDRef)id)).cdim;
        }
    }

    public static class COPACModel
    implements SetDBIDs {
        int cdim;
        SetDBIDs ids;

        public COPACModel(int cdim, SetDBIDs ids) {
            this.cdim = cdim;
            this.ids = ids;
        }

        @Override
        public DBIDIter iter() {
            return this.ids.iter();
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        public boolean contains(DBIDRef o) {
            return this.ids.contains(o);
        }

        @Override
        public boolean isEmpty() {
            return this.ids.isEmpty();
        }
    }
}

