/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.ERiC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="On Exploring Complex Relationships of Correlation Clusters", booktitle="Proc. 19th Int. Conf. Scientific and Statistical Database Management (SSDBM 2007)", url="https://doi.org/10.1109/SSDBM.2007.21", bibkey="DBLP:conf/ssdbm/AchtertBKKZ07")
public class ERiCNeighborPredicate<V extends NumberVector>
implements NeighborPredicate<DBIDs> {
    private static final Logging LOG = Logging.getLogger(ERiCNeighborPredicate.class);
    protected final ERiC.Settings settings;
    private double deltasq;

    public ERiCNeighborPredicate(ERiC.Settings settings) {
        this.settings = settings;
        this.deltasq = settings.delta * settings.delta;
    }

    public Instance instantiate(Database database) {
        return this.instantiate(database, database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]));
    }

    public Instance instantiate(Database database, Relation<V> relation) {
        DistanceQuery<NumberVector> dq = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> knnq = database.getKNNQuery(dq, this.settings.k);
        WritableDataStore<PCAFilteredResult> storage = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, PCAFilteredResult.class);
        PCARunner pca = this.settings.pca;
        EigenPairFilter filter = this.settings.filter;
        Duration time = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList ref = knnq.getKNNForDBID(iditer, this.settings.k);
            PCAResult pcares = pca.processQueryResult(ref, relation);
            storage.put(iditer, new PCAFilteredResult(pcares.getEigenPairs(), filter.filter(pcares.getEigenvalues()), 1.0, 0.0));
            LOG.incrementProcessed(progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.statistics(time.end());
        return new Instance(relation.getDBIDs(), storage, relation);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<DBIDs> getOutputType() {
        return new SimpleTypeInformation<DBIDs>(DBIDs.class);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected ERiC.Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            this.settings = config.tryInstantiate(ERiC.Settings.class);
        }

        @Override
        protected ERiCNeighborPredicate<V> makeInstance() {
            return new ERiCNeighborPredicate(this.settings);
        }
    }

    public class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<DBIDs, PCAFilteredResult> {
        private Relation<? extends NumberVector> relation;

        public Instance(DBIDs ids, DataStore<PCAFilteredResult> storage, Relation<? extends NumberVector> relation) {
            super(ids, storage);
            this.relation = relation;
        }

        @Override
        public DBIDs getNeighbors(DBIDRef reference) {
            PCAFilteredResult pca1 = (PCAFilteredResult)this.storage.get(reference);
            NumberVector v1 = this.relation.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
            DBIDIter neighbor = this.relation.iterDBIDs();
            while (neighbor.valid()) {
                PCAFilteredResult pca2 = (PCAFilteredResult)this.storage.get(neighbor);
                NumberVector v2 = this.relation.get(neighbor);
                if (this.strongNeighbors(v1, v2, pca1, pca2)) {
                    ids.add(neighbor);
                }
                neighbor.advance();
            }
            return ids;
        }

        @Override
        public DBIDIter iterDBIDs(DBIDs neighbors) {
            return neighbors.iter();
        }

        public boolean strongNeighbors(NumberVector v1, NumberVector v2, PCAFilteredResult pca1, PCAFilteredResult pca2) {
            if (pca1.getCorrelationDimension() != pca2.getCorrelationDimension()) {
                return false;
            }
            if (!this.approximatelyLinearDependent(pca1, pca2) || !this.approximatelyLinearDependent(pca2, pca1)) {
                return false;
            }
            double[] v = VMath.minusEquals(v1.toArray(), v2.toArray());
            return VMath.transposeTimesTimes(v, pca1.similarityMatrix(), v) <= ERiCNeighborPredicate.this.settings.tau && VMath.transposeTimesTimes(v, pca2.similarityMatrix(), v) <= ERiCNeighborPredicate.this.settings.tau;
        }

        public boolean weakNeighbors(double[] v1, double[] v2, PCAFilteredResult pca1, PCAFilteredResult pca2) {
            if (pca1.getCorrelationDimension() < pca2.getCorrelationDimension() || !this.approximatelyLinearDependent(pca1, pca2) || pca1.getCorrelationDimension() == pca2.getCorrelationDimension() && !this.approximatelyLinearDependent(pca2, pca1)) {
                return false;
            }
            double[] v = VMath.minus(v1, v2);
            return VMath.transposeTimesTimes(v, pca1.similarityMatrix(), v) <= ERiCNeighborPredicate.this.settings.tau && (pca1.getCorrelationDimension() != pca2.getCorrelationDimension() || VMath.transposeTimesTimes(v, pca2.similarityMatrix(), v) <= ERiCNeighborPredicate.this.settings.tau);
        }

        protected boolean approximatelyLinearDependent(PCAFilteredResult pca1, PCAFilteredResult pca2) {
            double[][] m1_czech = pca1.dissimilarityMatrix();
            double[][] v2_strong = pca2.getStrongEigenvectors();
            for (int i = 0; i < v2_strong.length; ++i) {
                double[] v2_i = v2_strong[i];
                double distsq = VMath.squareSum(v2_i) - VMath.transposeTimesTimes(v2_i, m1_czech, v2_i);
                if (!(distsq > ERiCNeighborPredicate.this.deltasq)) continue;
                return false;
            }
            return true;
        }

        public int dimensionality(DBIDRef id) {
            return ((PCAFilteredResult)this.storage.get(id)).getCorrelationDimension();
        }
    }
}

